/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.subscription;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.config.group.GroupConfigurable;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.subscription.DefaultFilterSubscription;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.issue.subscription.SendFilterJob;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.mail.MailingListCompiler;
import com.atlassian.jira.mail.SubscriptionMailQueueItem;
import com.atlassian.jira.mail.SubscriptionMailQueueItemFactory;
import com.atlassian.jira.scheduler.cron.SimpleToCronTriggerConverter;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubscriptionManager
extends MailingListCompiler
implements SubscriptionManager,
GroupConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSubscriptionManager.class);
    public static final String SUBSCRIPTION_PREFIX = DefaultSubscriptionManager.class.getName();
    public static final String JOB_RUNNER_KEY = DefaultSubscriptionManager.class.getName();
    private static final String ENTITY_NAME = "FilterSubscription";
    private final MailQueue mailQueue;
    private final SubscriptionMailQueueItemFactory subscriptionMailQueueItemFactory;
    private final GroupManager groupManager;
    private final SchedulerService schedulerService;
    private final EntityEngine entityEngine;
    private final UserManager userManager;

    public DefaultSubscriptionManager(MailQueue mailQueue, TemplateManager templateManager, SubscriptionMailQueueItemFactory subscriptionMailQueueItemFactory, ProjectRoleManager projectRoleManager, GroupManager groupManager, SchedulerService schedulerService, EntityEngine entityEngine, DateTimeFormatterFactory dateTimeFormatterFactory, UserManager userManager) {
        super(templateManager, projectRoleManager, dateTimeFormatterFactory);
        this.mailQueue = mailQueue;
        this.subscriptionMailQueueItemFactory = subscriptionMailQueueItemFactory;
        this.groupManager = groupManager;
        this.schedulerService = schedulerService;
        this.entityEngine = entityEngine;
        this.userManager = userManager;
        schedulerService.registerJobRunner(JobRunnerKey.of((String)JOB_RUNNER_KEY), (JobRunner)new SendFilterJob());
    }

    public boolean hasSubscription(ApplicationUser user, Long filterId) throws GenericEntityException {
        return !this.getFilterSubscriptions(user, filterId).isEmpty();
    }

    public FilterSubscription getFilterSubscription(Long subId) throws GenericEntityException {
        return (FilterSubscription)Select.from(Entity.FILTER_SUBSCRIPTION).byId(subId).runWith(this.entityEngine).singleValue();
    }

    public FilterSubscription getFilterSubscription(ApplicationUser user, Long subId) throws GenericEntityException {
        return (FilterSubscription)Select.from(Entity.FILTER_SUBSCRIPTION).byId(subId).whereEqual("username", ApplicationUsers.getKeyFor(user)).runWith(this.entityEngine).singleValue();
    }

    private EntityCondition getFilterByUserCondition(ApplicationUser user, Long filterId) {
        ArrayList entityExpressions = Lists.newArrayList();
        entityExpressions.add(new EntityExpr("username", EntityOperator.EQUALS, (Object)ApplicationUsers.getKeyFor(user)));
        Collection groups = this.groupManager.getGroupNamesForUser(user);
        for (String group : groups) {
            entityExpressions.add(new EntityExpr("group", EntityOperator.EQUALS, (Object)group));
        }
        EntityConditionList ownershipCondition = new EntityConditionList((List)entityExpressions, EntityOperator.OR);
        EntityExpr filterCondition = new EntityExpr("filterID", EntityOperator.EQUALS, (Object)filterId);
        return new EntityConditionList((List)ImmutableList.of((Object)ownershipCondition, (Object)filterCondition), EntityOperator.AND);
    }

    public List<FilterSubscription> getFilterSubscriptions(ApplicationUser user, Long filterId) throws GenericEntityException {
        EntityCondition filterCondition = this.getFilterByUserCondition(user, filterId);
        return Select.from(Entity.FILTER_SUBSCRIPTION).whereCondition(filterCondition).runWith(this.entityEngine).asList();
    }

    @Nullable
    public String getCronExpressionForSubscription(FilterSubscription subscription) {
        return this.getCronExpression(subscription.getId());
    }

    @Nullable
    private String getCronExpression(long subscriptionId) {
        JobDetails jobDetails = this.schedulerService.getJobDetails(DefaultSubscriptionManager.toJobId(subscriptionId));
        if (jobDetails == null) {
            return null;
        }
        return DefaultSubscriptionManager.getCronExpression(jobDetails.getSchedule());
    }

    @Nullable
    private static String getCronExpression(Schedule schedule) {
        String cronExpression;
        if (schedule.getCronScheduleInfo() != null) {
            cronExpression = schedule.getCronScheduleInfo().getCronExpression();
        } else if (schedule.getIntervalScheduleInfo() != null) {
            long interval = schedule.getIntervalScheduleInfo().getIntervalInMillis();
            cronExpression = new SimpleToCronTriggerConverter().convertToCronString((Date)new Date(), (long)interval).cronString;
        } else {
            cronExpression = null;
        }
        return cronExpression;
    }

    public void updateSubscription(ApplicationUser user, Long subId, String groupName, String cronExpression, Boolean emailOnEmpty) throws DataAccessException {
        Schedule schedule = Schedule.forCronExpression((String)cronExpression);
        try {
            this.schedulerService.unscheduleJob(DefaultSubscriptionManager.toJobId(subId));
            Update.into(ENTITY_NAME).set("username", ApplicationUsers.getKeyFor(user)).set("group", groupName).set("emailOnEmpty", emailOnEmpty.toString()).whereEqual("id", subId).execute(this.entityEngine);
            JobConfig config = DefaultSubscriptionManager.getJobConfig(subId, schedule);
            this.schedulerService.scheduleJob(DefaultSubscriptionManager.toJobId(subId), config);
        }
        catch (SchedulerServiceException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private static JobId toJobId(Long subId) {
        return JobId.of((String)(SUBSCRIPTION_PREFIX + ':' + subId));
    }

    private static JobConfig getJobConfig(Long subscriptionId, Schedule schedule) {
        return JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)JOB_RUNNER_KEY)).withSchedule(schedule).withParameters((Map)ImmutableMap.of((Object)"SUBSCRIPTION_ID", (Object)subscriptionId));
    }

    public List<FilterSubscription> getAllFilterSubscriptions(Long filterId) {
        return Select.from(Entity.FILTER_SUBSCRIPTION).whereEqual("filterID", filterId).runWith(this.entityEngine).asList();
    }

    public List<FilterSubscription> getAllFilterSubscriptions() {
        return Select.from(Entity.FILTER_SUBSCRIPTION).runWith(this.entityEngine).asList();
    }

    public FilterSubscription createSubscription(ApplicationUser user, Long filterId, String groupName, String cronExpression, Boolean emailOnEmpty) {
        Schedule schedule = Schedule.forCronExpression((String)cronExpression);
        return this.createSubscription(user, filterId, groupName, emailOnEmpty, schedule);
    }

    @Nullable
    public Date getNextSendTime(@Nonnull FilterSubscription sub) {
        JobDetails jobDetails = this.schedulerService.getJobDetails(DefaultSubscriptionManager.toJobId(sub.getId()));
        return jobDetails == null ? null : jobDetails.getNextRunTime();
    }

    private FilterSubscription createSubscription(ApplicationUser user, Long filterId, String groupName, Boolean emailOnEmpty, Schedule schedule) {
        DefaultFilterSubscription newSubscription = new DefaultFilterSubscription(null, filterId, user.getKey(), groupName, null, emailOnEmpty);
        try {
            FilterSubscription subscription = this.entityEngine.createValue(Entity.FILTER_SUBSCRIPTION, newSubscription);
            JobConfig config = DefaultSubscriptionManager.getJobConfig(subscription.getId(), schedule);
            this.schedulerService.scheduleJob(DefaultSubscriptionManager.toJobId(subscription.getId()), config);
            return subscription;
        }
        catch (SchedulerServiceException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void deleteSubscription(Long subId) throws GenericEntityException {
        FilterSubscription subscription = this.getFilterSubscription(subId);
        if (subscription == null) {
            LOG.debug("Unable to find subscription for id : " + subId);
        }
        if (this.schedulerService.getJobDetails(DefaultSubscriptionManager.toJobId(subId)) != null) {
            this.schedulerService.unscheduleJob(DefaultSubscriptionManager.toJobId(subId));
        } else {
            LOG.debug("Unable to find a scheduled job for the subscription: " + subId + "; removing the subscription anyway.");
        }
        Delete.from(Entity.FILTER_SUBSCRIPTION).whereIdEquals(subId).execute(this.entityEngine);
    }

    public void deleteSubscriptionsForUser(@Nonnull ApplicationUser user) throws GenericEntityException {
        String userKey = ((ApplicationUser)Assertions.notNull((String)"user", (Object)user)).getKey();
        Delete.from(Entity.FILTER_SUBSCRIPTION).whereEqual("username", userKey).execute(this.entityEngine);
    }

    private void runSubscription(FilterSubscription sub) throws GenericEntityException {
        Timestamp ts = new Timestamp(new Date().getTime());
        Update.into(ENTITY_NAME).set("lastRun", ts).whereEqual("id", sub.getId()).execute(this.entityEngine);
        if (this.userManager.getUserByKey(sub.getUserKey()).isActive()) {
            SubscriptionMailQueueItem item = this.subscriptionMailQueueItemFactory.getSubscriptionMailQueueItem(sub);
            this.mailQueue.addItem((MailQueueItem)item);
        }
    }

    public void runSubscription(Long subId) throws GenericEntityException {
        this.runSubscription(this.getFilterSubscription(subId));
    }

    public void runSubscription(ApplicationUser user, Long subId) throws GenericEntityException {
        this.runSubscription(this.getFilterSubscription(user, subId));
    }

    public void deleteSubscriptionsForGroup(Group group) throws GenericEntityException {
        Assertions.notNull((String)"group", (Object)group);
        List<FilterSubscription> subscriptions = this.getGroupSubscriptions(group);
        for (FilterSubscription subscription : subscriptions) {
            this.deleteSubscription(subscription.getId());
        }
    }

    private List<FilterSubscription> getGroupSubscriptions(Group group) {
        return Select.from(Entity.FILTER_SUBSCRIPTION).whereEqual("group", group.getName()).runWith(this.entityEngine).asList();
    }

    @Override
    public boolean isGroupUsed(@Nonnull Group group) {
        return this.getGroupSubscriptions(group).size() > 0;
    }
}

