/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import java.util.Objects;
import org.apache.lucene.search.IndexSearcher;

public class SearchProviderFactoryImpl
implements SearchProviderFactory {
    private final IssueIndexManager indexManager;

    public SearchProviderFactoryImpl(IssueIndexManager indexManager) {
        this.indexManager = Objects.requireNonNull(indexManager, "indexManager");
    }

    public IndexSearcher getSearcher(String searcherName) {
        if ("issues".equals(searcherName)) {
            return this.indexManager.getIssueSearcher();
        }
        if ("comments".equals(searcherName)) {
            return this.indexManager.getCommentSearcher();
        }
        if ("changes".equals(searcherName)) {
            return this.indexManager.getChangeHistorySearcher();
        }
        if ("worklog".equals(searcherName)) {
            return this.indexManager.getWorklogSearcher();
        }
        throw new UnsupportedOperationException("Only issue, comment and change history indexes are catered for currently");
    }
}

