/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestEntity;
import com.atlassian.jira.issue.search.SearchRequestStore;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.sharing.IdsRetrievalDescriptor;
import com.atlassian.jira.sharing.IndexableSharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Visitor;
import com.atlassian.jira.util.collect.CollectionEnclosedIterable;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@EventComponent
public class CachingSearchRequestStore
implements SearchRequestStore {
    private final SearchRequestStore delegateStore;
    private final Cache<String, List<Long>> cacheByUser;
    private final Cache<Long, CacheObject<SearchRequest>> cacheById;

    public CachingSearchRequestStore(SearchRequestStore delegateStore, CacheManager cacheManager) {
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
        this.cacheByUser = cacheManager.getCache(CachingSearchRequestStore.class.getName() + ".cacheByUser", (CacheLoader)new ByUserCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cacheById = cacheManager.getCache(CachingSearchRequestStore.class.getName() + ".cacheById", (CacheLoader)new ByIdCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cacheById.removeAll();
        this.cacheByUser.removeAll();
    }

    @Override
    public EnclosedIterable<SearchRequest> get(SharedEntityAccessor.RetrievalDescriptor descriptor) {
        IdsRetrievalDescriptor searchRequestsFromDb = new IdsRetrievalDescriptor((Collection)descriptor.getIds().stream().filter(id -> !this.cacheById.containsKey(id)).collect(CollectorsUtil.toImmutableListWithSizeOf((Collection)descriptor.getIds())), false);
        this.delegateStore.get(searchRequestsFromDb).foreach(searchRequest -> this.cacheById.put((Object)searchRequest.getId(), CacheObject.wrap(searchRequest)));
        return CollectionEnclosedIterable.from((Collection)((Collection)descriptor.getIds().stream().filter(arg_0 -> this.cacheById.containsKey(arg_0)).map(arg_0 -> this.cacheById.get(arg_0)).filter(CacheObject::hasValue).map(CacheObject::getValue).collect(CollectorsUtil.toImmutableListWithSizeOf((Collection)descriptor.getIds()))));
    }

    @Override
    public EnclosedIterable<SearchRequest> getAll() {
        return this.delegateStore.getAll();
    }

    @Override
    public void visitAll(Visitor<SearchRequestEntity> visitor) {
        this.delegateStore.visitAll(visitor);
    }

    @Override
    public EnclosedIterable<IndexableSharedEntity<SearchRequest>> getAllIndexableSharedEntities() {
        return this.delegateStore.getAllIndexableSharedEntities();
    }

    @Override
    public Collection<SearchRequest> getAllOwnedSearchRequests(ApplicationUser owner) {
        Assertions.notNull((String)"owner", (Object)owner);
        return this.getAllOwnedSearchRequests(owner.getKey());
    }

    @Override
    public Collection<SearchRequest> getAllOwnedSearchRequests(String userKey) {
        Assertions.notNull((String)"userKey", (Object)userKey);
        Collection ownedSearchRequestIds = (Collection)this.cacheByUser.get((Object)userKey);
        ArrayList<SearchRequest> returnPages = new ArrayList<SearchRequest>(ownedSearchRequestIds.size());
        for (Long id : ownedSearchRequestIds) {
            SearchRequest searchRequest = this.getSearchRequest(id);
            if (searchRequest == null) continue;
            returnPages.add(searchRequest);
        }
        return returnPages;
    }

    @Override
    public SearchRequest getRequestByAuthorAndName(ApplicationUser author, String name) {
        return this.delegateStore.getRequestByAuthorAndName(author, name);
    }

    @Override
    public SearchRequest getSearchRequest(@Nonnull Long searchRequestId) {
        Assertions.notNull((String)"searchRequestId", (Object)searchRequestId);
        return this.copySearch((SearchRequest)((CacheObject)this.cacheById.get((Object)searchRequestId)).getValue());
    }

    @Override
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK_EXCEPTION_PATH"}, justification="This appears to be doing exactly the right thing with the finally-clause to release the lock")
    public SearchRequest create(@Nonnull SearchRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        SearchRequest savedRequest = null;
        try {
            savedRequest = this.delegateStore.create(request);
        }
        finally {
            if (savedRequest != null) {
                this.cacheById.remove((Object)savedRequest.getId());
                if (request.getOwner() != null) {
                    this.cacheByUser.remove((Object)request.getOwner().getKey());
                }
            }
        }
        return this.copySearch(savedRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchRequest update(@Nonnull SearchRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        Assertions.notNull((String)"request.id", (Object)request.getId());
        SearchRequest returnRequest = null;
        SearchRequest oldSearchRequest = null;
        try {
            oldSearchRequest = this.delegateStore.getSearchRequest(request.getId());
            returnRequest = this.delegateStore.update(request);
        }
        finally {
            this.cacheById.remove((Object)request.getId());
            if (request.getOwner() != null && (oldSearchRequest == null || request.getOwner() != oldSearchRequest.getOwner())) {
                this.cacheByUser.remove((Object)request.getOwner().getKey());
            }
            if (oldSearchRequest != null && oldSearchRequest.getOwner() != request.getOwner()) {
                this.cacheByUser.remove((Object)oldSearchRequest.getOwner().getKey());
            }
        }
        return this.copySearch(returnRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchRequest adjustFavouriteCount(@Nonnull Long searchRequestId, int incrementValue) {
        Assertions.notNull((String)"searchRequestId", (Object)searchRequestId);
        SearchRequest returnRequest = null;
        try {
            returnRequest = this.delegateStore.adjustFavouriteCount(searchRequestId, incrementValue);
        }
        finally {
            this.cacheById.remove((Object)searchRequestId);
        }
        return this.copySearch(returnRequest);
    }

    @Override
    public void delete(@Nonnull Long searchId) {
        Assertions.notNull((String)"searchId", (Object)searchId);
        SearchRequest oldSearchRequest = null;
        try {
            oldSearchRequest = this.delegateStore.getSearchRequest(searchId);
            this.delegateStore.delete(searchId);
        }
        finally {
            this.cacheById.remove((Object)searchId);
            if (oldSearchRequest != null && oldSearchRequest.getOwner() != null) {
                this.cacheByUser.remove((Object)oldSearchRequest.getOwner().getKey());
            }
        }
    }

    @Override
    public EnclosedIterable<SearchRequest> getSearchRequests(Project project) {
        return this.delegateStore.getSearchRequests(project);
    }

    @Override
    @Nonnull
    public List<SearchRequest> findByNameIgnoreCase(String name) {
        return this.delegateStore.findByNameIgnoreCase(name);
    }

    @Override
    public EnclosedIterable<SearchRequest> getSearchRequests(Group group) {
        return this.delegateStore.getSearchRequests(group);
    }

    private SearchRequest copySearch(SearchRequest searchRequest) {
        return searchRequest != null ? new SearchRequest(searchRequest) : null;
    }

    private class ByIdCacheLoader
    implements CacheLoader<Long, CacheObject<SearchRequest>> {
        private ByIdCacheLoader() {
        }

        @Nonnull
        public CacheObject<SearchRequest> load(@Nonnull Long searchRequestId) {
            return CacheObject.wrap(CachingSearchRequestStore.this.delegateStore.getSearchRequest(searchRequestId));
        }
    }

    private class ByUserCacheLoader
    implements CacheLoader<String, List<Long>> {
        private ByUserCacheLoader() {
        }

        @Nonnull
        public List<Long> load(@Nonnull String ownerKey) {
            Collection<SearchRequest> requestsFromDatabase = CachingSearchRequestStore.this.delegateStore.getAllOwnedSearchRequests(ownerKey);
            if (requestsFromDatabase != null) {
                ArrayList<Long> ownedSearchRequestIds = new ArrayList<Long>(requestsFromDatabase.size());
                for (SearchRequest searchRequest : requestsFromDatabase) {
                    ownedSearchRequestIds.add(searchRequest.getId());
                }
                return ImmutableList.copyOf(ownedSearchRequestIds);
            }
            return ImmutableList.of();
        }
    }
}

