/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Unit;
import com.atlassian.jira.bc.issue.properties.IssuePropertyHelper;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.io.InputStreamFunctionFactory;
import com.atlassian.jira.issue.AttachmentIndexManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentKeyMapper;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.plugin.attachment.AttachmentArchive;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveEntry;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveImpl;
import com.atlassian.jira.plugin.attachment.AttachmentProcessor;
import com.atlassian.jira.plugin.attachment.AttachmentProcessorModuleDescriptor;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.util.concurrent.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttachmentIndexManager
implements AttachmentIndexManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAttachmentIndexManager.class);
    private static final String NO_INDEX = "[]";
    private final PluginAccessor pluginAccessor;
    private final StreamAttachmentStore attachmentStore;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final IssuePropertyHelper issuePropertyHelper;
    private final String entityDbName;
    private final InputStreamFunctionFactory inputStreamFunctionFactory;
    private final AttachmentKeyMapper attachmentKeyMapper;

    public DefaultAttachmentIndexManager(PluginAccessor pluginAccessor, StreamAttachmentStore attachmentStore, JsonEntityPropertyManager jsonEntityPropertyManager, IssuePropertyHelper entityPropertyHelper, InputStreamFunctionFactory inputStreamFunctionFactory, AttachmentKeyMapper attachmentKeyMapper) {
        this.pluginAccessor = pluginAccessor;
        this.attachmentStore = attachmentStore;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.issuePropertyHelper = entityPropertyHelper;
        this.inputStreamFunctionFactory = inputStreamFunctionFactory;
        this.attachmentKeyMapper = attachmentKeyMapper;
        this.entityDbName = entityPropertyHelper.getEntityPropertyType().getDbEntityName();
    }

    @Override
    public void processAttachmentAndCreateIndex(@Nonnull File file, @Nonnull Attachment attachment, @Nonnull Issue issue) {
        this.processAttachmentAndCreateIndex(file, attachment, issue, 0);
    }

    protected Option<AttachmentArchive> processAttachmentAndCreateIndex(@Nonnull File file, @Nonnull Attachment attachment, @Nonnull Issue issue, int maxEntries) {
        Option<String> index = this.generateArchiveFileIndex(file, attachment);
        this.processAttachment((String)index.getOrElse((Object)NO_INDEX), attachment, issue);
        return index.map(input -> AttachmentArchiveImpl.fromJSONArrayQuiet(input, maxEntries));
    }

    private Option<String> generateArchiveFileIndex(@Nonnull File file, @Nonnull Attachment attachment) {
        Iterable<AttachmentProcessorModuleDescriptor> filteredProcessors = this.filterProcessors(attachment);
        if (Iterables.isEmpty(filteredProcessors)) {
            return Option.none();
        }
        AttachmentProcessorModuleDescriptor firstDescriptor = filteredProcessors.iterator().next();
        List<AttachmentArchiveEntry> entries = ((AttachmentProcessor)firstDescriptor.getModule()).processAttachment(file);
        Iterable<JSONObject> jsons = AttachmentArchiveImpl.serialize(entries);
        JSONArray array = new JSONArray((Collection)Lists.newArrayList((Iterable)Iterables.filter(jsons, (Predicate)new TotalLengthPredicate(32768L))));
        return Option.some((Object)array.toString());
    }

    private Iterable<AttachmentProcessorModuleDescriptor> filterProcessors(@Nonnull Attachment attachment) {
        String fileExtension = FilenameUtils.getExtension((String)attachment.getFilename());
        return Iterables.filter((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(AttachmentProcessorModuleDescriptor.class), attachmentProcessorModuleDescriptor -> Iterables.any(attachmentProcessorModuleDescriptor.getFileExtensions(), s -> fileExtension.equalsIgnoreCase((String)s)));
    }

    private void processAttachment(@Nonnull String index, @Nonnull Attachment attachment, @Nonnull Issue issue) {
        this.jsonEntityPropertyManager.put(null, this.entityDbName, issue.getId(), attachment.getId().toString(), index, this.issuePropertyHelper.createSetPropertyEventFunction(), true);
    }

    @Override
    public Option<AttachmentArchive> getAttachmentContents(@Nonnull Attachment attachment, @Nonnull Issue issue, int maxEntries) {
        Option property = Option.option((Object)this.jsonEntityPropertyManager.get(this.entityDbName, issue.getId(), attachment.getId().toString()));
        return property.map(EntityProperty::getValue).map(input -> AttachmentArchiveImpl.fromJSONArrayQuiet(input, maxEntries)).orElse(() -> {
            File tempFile = null;
            try {
                tempFile = File.createTempFile("attachment-toc-", "attachment-toc-");
                Option<AttachmentArchive> option = this.generateIndex(attachment, issue, maxEntries, tempFile);
                return option;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (tempFile != null && !tempFile.delete()) {
                    log.warn("Failed to delete temporary file: " + tempFile);
                }
            }
        });
    }

    private Option<AttachmentArchive> generateIndex(Attachment attachment, Issue issue, int maxEntries, File temporaryFile) {
        Preconditions.checkNotNull((Object)temporaryFile, (Object)"temporaryFile");
        AttachmentKey attachmentKey = this.attachmentKeyMapper.fromAttachment(attachment);
        Function<InputStream, Unit> saveStream = this.inputStreamFunctionFactory.saveStream(temporaryFile);
        return (Option)this.attachmentStore.getAttachment(attachmentKey, saveStream).fold(throwable -> {
            String message = String.format("Failed to retrieve attachment with %s while generating attachment index.", attachmentKey);
            log.debug(message, throwable);
            return Option.none();
        }, unit -> this.processAttachmentAndCreateIndex(temporaryFile, attachment, issue, maxEntries)).claim();
    }

    @Override
    public void removeAttachmentIndex(@Nonnull Attachment attachment, @Nonnull Issue issue) {
        this.jsonEntityPropertyManager.delete(this.entityDbName, issue.getId(), attachment.getId().toString());
    }

    @Override
    public boolean isExpandable(Attachment attachment) {
        Iterable<AttachmentProcessorModuleDescriptor> processors = this.filterProcessors(attachment);
        return processors.iterator().hasNext();
    }

    @NotThreadSafe
    protected static class TotalLengthPredicate
    implements Predicate<JSONObject> {
        private static final int ADDITIONAL_CHARS_NEEDED = 6;
        private static final int ADDITIONAL_CHARS_PER_ENTRY = 2;
        private final long maxLength;
        private long currentLength;

        protected TotalLengthPredicate(long maxLength) {
            this.maxLength = maxLength;
            this.currentLength = 6L;
        }

        public boolean apply(JSONObject json) {
            long jsonLength = json.toString().length();
            if (this.currentLength + jsonLength + 2L < this.maxLength) {
                this.currentLength += jsonLength + 2L;
                return true;
            }
            return false;
        }
    }
}

