/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.TextAnalyzer;
import com.google.common.base.Function;
import java.io.Reader;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.th.ThaiWordFilter;
import org.apache.lucene.util.Version;

public class ThaiAnalyzer
extends TextAnalyzer {
    private final Version matchVersion;
    private final Function<TokenStream, TokenStream> stopWordFilter;

    public ThaiAnalyzer(Version matchVersion, boolean indexing, Function<TokenStream, TokenStream> stopWordFilter) {
        super(indexing);
        this.matchVersion = matchVersion;
        this.stopWordFilter = stopWordFilter;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        ClassicTokenizer result = new ClassicTokenizer(this.matchVersion, reader);
        result = new StandardFilter(this.matchVersion, (TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = (TokenStream)this.stopWordFilter.apply((Object)result);
        result = new ThaiWordFilter(this.matchVersion, (TokenStream)result);
        return result;
    }
}

