/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureDisabledEvent;
import com.atlassian.jira.config.FeatureEnabledEvent;
import com.atlassian.jira.config.FeatureEvent;
import com.atlassian.jira.issue.fields.renderer.wiki.TokenRendererAwareRendererComparator;
import com.atlassian.jira.plugin.renderercomponent.RendererComponentFactoryDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.renderer.RendererConfiguration;
import com.atlassian.renderer.embedded.EmbeddedResourceRenderer;
import com.atlassian.renderer.links.LinkRenderer;
import com.atlassian.renderer.v2.MutableRenderer;
import com.atlassian.renderer.v2.Renderer;
import com.atlassian.renderer.v2.V2RendererFacade;
import com.atlassian.renderer.v2.components.PluggableRendererComponentFactory;
import com.atlassian.renderer.v2.components.RendererComponent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiRendererFactory {
    private static final Logger logger = LoggerFactory.getLogger(WikiRendererFactory.class);
    private final ResettableLazyReference<V2RendererFacade> wikiRendererRef = new ResettableLazyReference<V2RendererFacade>(){

        protected V2RendererFacade create() throws Exception {
            this.initializeComponents();
            return new V2RendererFacade((RendererConfiguration)ComponentAccessor.getComponent(RendererConfiguration.class), (LinkRenderer)ComponentAccessor.getComponent(LinkRenderer.class), (EmbeddedResourceRenderer)ComponentAccessor.getComponent(EmbeddedResourceRenderer.class), (Renderer)ComponentAccessor.getComponent(Renderer.class));
        }

        private void initializeComponents() {
            ArrayList<RendererComponent> components = new ArrayList<RendererComponent>();
            MutableRenderer renderer = (MutableRenderer)ComponentAccessor.getComponent(Renderer.class);
            PluginAccessor pluginAccessor = (PluginAccessor)ComponentAccessor.getComponentOfType(PluginAccessor.class);
            ArrayList descriptors = new ArrayList(pluginAccessor.getEnabledModuleDescriptorsByClass(RendererComponentFactoryDescriptor.class));
            Collections.sort(descriptors, ModuleDescriptorComparator.COMPARATOR);
            for (RendererComponentFactoryDescriptor descriptor : descriptors) {
                PluggableRendererComponentFactory rendererComponentFactory = (PluggableRendererComponentFactory)descriptor.getModule();
                if (rendererComponentFactory != null) {
                    RendererComponent rendererComponent = rendererComponentFactory.getRendererComponent();
                    if (rendererComponent != null) {
                        components.add(rendererComponent);
                        continue;
                    }
                    logger.warn("Renderer component factory " + rendererComponentFactory + " returned null renderer component");
                    continue;
                }
                logger.warn("Got null renderer component factory module from descriptor " + (Object)((Object)descriptor));
            }
            Collections.sort(components, TokenRendererAwareRendererComparator.COMPARATOR);
            renderer.setComponents(components);
        }
    };

    public V2RendererFacade getWikiRenderer() {
        return (V2RendererFacade)this.wikiRendererRef.get();
    }

    @EventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.onPluginModuleEvent(event.getModule());
    }

    @EventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        this.onPluginModuleEvent(event.getModule());
    }

    @EventListener
    public void onFeatureEnabled(FeatureEnabledEvent event) {
        this.resetOnFeatureChange((FeatureEvent)event);
    }

    @EventListener
    public void onFeatureDisabled(FeatureDisabledEvent event) {
        this.resetOnFeatureChange((FeatureEvent)event);
    }

    private void resetOnFeatureChange(FeatureEvent event) {
        if ("jira.wiki.use.old.image.renderer.order".equals(event.feature())) {
            this.wikiRendererRef.reset();
        }
    }

    private void onPluginModuleEvent(ModuleDescriptor<?> descriptor) {
        if (descriptor instanceof RendererComponentFactoryDescriptor) {
            this.wikiRendererRef.reset();
        }
    }
}

