/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.persistence;

import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.CacheAdapter;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersister;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersisterImpl;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class CachedFieldConfigSchemePersister
extends FieldConfigSchemePersisterImpl {
    protected static final String DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY = "jira.jvc.CachedFieldConfigSchemePersister.caches.request";
    private final CacheAdapter<Long, Optional<FieldConfigScheme>> cacheById;
    private final CacheAdapter<String, List<FieldConfigScheme>> cacheByCustomField;
    private final CacheAdapter<Long, FieldConfigScheme> cacheByFieldConfig;

    public CachedFieldConfigSchemePersister(OfBizDelegator delegator, QueryDslAccessor queryDslAccessor, ConstantsManager constantsManager, FieldConfigPersister fieldConfigPersister, FieldConfigContextPersister fieldContextPersister, SwitchingCacheFactory cacheFactory) {
        super(delegator, queryDslAccessor, constantsManager, fieldConfigPersister, fieldContextPersister, cacheFactory);
        this.cacheById = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".cacheById", Optional.of(new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build()), DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
        this.cacheByCustomField = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".cacheByCustomField", Optional.of(new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build()), DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
        this.cacheByFieldConfig = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".cacheByFieldConfig", Optional.of(new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build()), DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
    }

    @Override
    public void init() {
        super.init();
        this.cacheById.removeAll();
        this.cacheByCustomField.removeAll();
        this.cacheByFieldConfig.removeAll();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.invalidateAll();
        this.cacheById.removeAll();
        this.cacheByCustomField.removeAll();
        this.cacheByFieldConfig.removeAll();
    }

    @Override
    @Nullable
    public FieldConfigScheme getFieldConfigScheme(Long configSchemeId) {
        if (configSchemeId == null) {
            return null;
        }
        return ((Optional)this.cacheById.get(configSchemeId, () -> Optional.ofNullable(super.getFieldConfigScheme(configSchemeId)))).orElse(null);
    }

    @Override
    @Nullable
    public List<FieldConfigScheme> getConfigSchemesForCustomField(ConfigurableField field) {
        if (field == null) {
            return null;
        }
        return (List)this.cacheByCustomField.get(field.getId(), () -> ImmutableList.copyOf(super.getConfigSchemesForCustomField(field)));
    }

    @Override
    @Nullable
    public FieldConfigScheme getConfigSchemeForFieldConfig(FieldConfig fieldConfig) {
        if (fieldConfig == null) {
            return null;
        }
        return (FieldConfigScheme)this.cacheByFieldConfig.get(fieldConfig.getId(), () -> super.getConfigSchemeForFieldConfig(fieldConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldConfigScheme update(FieldConfigScheme configScheme) {
        FieldConfigScheme updatedConfigScheme = null;
        try {
            updatedConfigScheme = super.update(configScheme);
        }
        finally {
            if (updatedConfigScheme != null) {
                this.cacheById.remove(updatedConfigScheme.getId());
                ConfigurableField field = updatedConfigScheme.getField();
                if (field != null) {
                    this.cacheByCustomField.remove(field.getId());
                }
                this.removeFieldConfigsFromCache(updatedConfigScheme);
            }
        }
        return updatedConfigScheme;
    }

    @Override
    protected void removeRelatedConfigsForUpdate(@Nonnull FieldConfigScheme configScheme, @Nonnull GenericValue gv) throws GenericEntityException {
        try {
            super.removeRelatedConfigsForUpdate(configScheme, gv);
        }
        finally {
            this.removeFieldConfigsFromCache(configScheme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Long fieldConfigSchemeId) {
        FieldConfigScheme deletedFieldConfigScheme = null;
        try {
            deletedFieldConfigScheme = super.removeIfExist(fieldConfigSchemeId);
        }
        finally {
            this.cacheById.remove(fieldConfigSchemeId);
            if (deletedFieldConfigScheme != null) {
                ConfigurableField field = deletedFieldConfigScheme.getField();
                if (field != null) {
                    this.cacheByCustomField.remove(field.getId());
                }
                this.removeFieldConfigsFromCache(deletedFieldConfigScheme);
            }
        }
    }

    private void removeFieldConfigsFromCache(FieldConfigScheme fieldConfigScheme) {
        fieldConfigScheme.getConfigs().values().stream().map(FieldConfig::getId).forEach(arg_0 -> this.cacheByFieldConfig.remove(arg_0));
    }
}

