/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.parameters.lucene.sort.StringSortComparator;
import com.atlassian.jira.issue.statistics.IssueKeyStatisticsMapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;

public class KeySystemField
extends NavigableFieldImpl
implements ExportableSystemField {
    public KeySystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext) {
        super("issuekey", "issue.field.issuekey", "issue.column.heading.issuekey", "ASC", templatingEngine, applicationProperties, authenticationContext);
    }

    public LuceneFieldSorter getSorter() {
        return IssueKeyStatisticsMapper.MAPPER;
    }

    @Override
    public List<SortField> getSortFields(boolean sortOrder) {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        sortFields.add(new SortField("projkey", (FieldComparatorSource)new StringSortComparator(), sortOrder));
        sortFields.add(new SortField("keynumpart_range", (FieldComparatorSource)new StringSortComparator(), sortOrder));
        return sortFields;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map<String, Object> displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put("applicationProperties", this.getApplicationProperties());
        return this.renderTemplate("key-columnview.vm", velocityParams);
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        FieldExportPartsBuilder builder = new FieldExportPartsBuilder();
        builder.addItem("key", i18nHelper.getText("admin.issue.export.field.name.issue.key"), issue.getKey());
        builder.addItem("issueId", i18nHelper.getText("admin.issue.export.field.name.issue.id"), String.valueOf(issue.getId()));
        if (issue.getParentId() != null) {
            builder.addItem("parentId", i18nHelper.getText("admin.issue.export.field.name.issue.parent.id"), String.valueOf(issue.getParentId()));
        }
        return builder.build();
    }
}

