/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.DueDateRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.DateTimeFieldChangeLogHelper;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.DueDateSearchHandlerFactory;
import com.atlassian.jira.issue.search.parameters.lucene.sort.StringSortComparator;
import com.atlassian.jira.issue.statistics.DateFieldSorter;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.views.util.csv.CsvDateFormatter;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.opensymphony.util.TextUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;

public class DueDateSystemField
extends AbstractOrderableNavigableFieldImpl<Date>
implements HideableField,
RequirableField,
DateField,
RestAwareField,
RestFieldOperations,
ExportableSystemField {
    private static final Logger log = LoggerFactory.getLogger(DueDateSystemField.class);
    private static final String DUE_DATE_NAME_KEY = "issue.field.duedate";
    private final DateFieldFormat dateFieldFormat;
    private final DateTimeFieldChangeLogHelper dateTimeFieldChangeLogHelper;
    private final CsvDateFormatter csvDateFormatter;

    public DueDateSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, DueDateSearchHandlerFactory factory, DateFieldFormat dateFieldFormat, DateTimeFieldChangeLogHelper dateTimeFieldChangeLogHelper, CsvDateFormatter csvDateFormatter) {
        super("duedate", DUE_DATE_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, factory);
        this.dateTimeFieldChangeLogHelper = dateTimeFieldChangeLogHelper;
        this.dateFieldFormat = dateFieldFormat;
        this.csvDateFormatter = csvDateFormatter;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map dispayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, dispayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put(this.getId(), operationContext.getFieldValuesHolder().get(this.getId()));
        velocityParams.put("dateFormat", CustomFieldUtils.getDateFormat());
        velocityParams.put("dateTimeFormat", CustomFieldUtils.getDateTimeFormat());
        velocityParams.put("timeFormat", CustomFieldUtils.getTimeFormat());
        return this.renderTemplate("duedate-edit.vm", velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        if (issue.getDueDate() != null) {
            velocityParams.put("duedate", this.dateFieldFormat.formatDatePicker((Date)issue.getDueDate()));
        }
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Date value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        if (value != null) {
            velocityParams.put("duedate", this.dateFieldFormat.formatDatePicker(value));
        }
        return this.getViewHtml(velocityParams);
    }

    private String getViewHtml(Map velocityParams) {
        return this.renderTemplate("duedate-view.vm", velocityParams);
    }

    public boolean isShown(Issue issue) {
        return this.hasPermission(issue, 28);
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollection, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String dueDate = (String)fieldValuesHolder.get(this.getId());
        if (TextUtils.stringSet((String)dueDate)) {
            try {
                Date date = this.dateFieldFormat.parseDatePicker(dueDate);
                LocalDateFactory.toIsoBasic((LocalDate)LocalDateFactory.from((Date)date));
            }
            catch (IllegalArgumentException e) {
                errorCollection.addError(this.getId(), i18n.getText("createissue.error.invalid.due.date", this.getApplicationProperties().getDefaultBackedString("jira.date.picker.java.format"), this.dateFieldFormat.formatDatePicker(new Date())));
                return;
            }
        }
        if (fieldScreenRenderLayoutItem.isRequired() && !TextUtils.stringSet((String)dueDate)) {
            if (this.isShown(issue)) {
                errorCollection.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
            } else {
                errorCollection.addErrorMessage(i18n.getText("createissue.error.due.date.required", i18n.getText(this.getNameKey()), issue.getProjectObject().getName()));
            }
        }
    }

    public void createValue(Issue issue, Date value) {
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Object currentValue = modifiedValue.getOldValue();
        Object value = modifiedValue.getNewValue();
        ChangeItemBean cib = null;
        if (currentValue == null) {
            if (value != null) {
                cib = new ChangeItemBean("jira", this.getId(), null, null, this.getChangelogValue(value), this.getChangelogString(value));
            }
        } else if (!this.valuesEqual(value, currentValue)) {
            cib = new ChangeItemBean("jira", this.getId(), this.getChangelogValue(currentValue), this.getChangelogString(currentValue), this.getChangelogValue(value), this.getChangelogString(value));
        }
        if (cib != null) {
            issueChangeHolder.addChangeItem(cib);
        }
    }

    private String getChangelogString(Object value) {
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private String getChangelogValue(Object value) {
        if (value != null && value instanceof Date) {
            Date date = (Date)value;
            return this.dateTimeFieldChangeLogHelper.createChangelogValueForDateField(date);
        }
        return null;
    }

    public Date getValueFromParams(Map params) {
        if (params.containsKey(this.getId())) {
            String dueDate = (String)params.get(this.getId());
            if (TextUtils.stringSet((String)dueDate)) {
                return new Timestamp(this.dateFieldFormat.parseDatePicker(dueDate).getTime());
            }
            return null;
        }
        return null;
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        fieldValuesHolder.put(this.getId(), stringValue);
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (this.isHidden(bulkEditBean.getFieldLayouts())) {
            return "bulk.edit.unavailable.hidden";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.multiproject.unavailable.permission";
        }
        return null;
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> params) {
        String[] value = params.get(this.getId());
        if (value != null && value.length > 0) {
            return value[0];
        }
        return null;
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
        Timestamp duedate = issue.getDueDate();
        if (duedate != null) {
            fieldValuesHolder.put(this.getId(), this.dateFieldFormat.formatDatePicker((Date)duedate));
        } else {
            fieldValuesHolder.put(this.getId(), null);
        }
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
    }

    public Date getDefaultValue(Issue issue) {
        return null;
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            issue.setDueDate((Timestamp)this.getValueFromParams(fieldValueHolder));
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Object originalIssue1 : originalIssues) {
            Issue originalIssue = (Issue)originalIssue1;
            if (originalIssue.getDueDate() != null || !targetFieldLayoutItem.isRequired()) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        this.populateDefaults(fieldValuesHolder, targetIssue);
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setDueDate(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        return issue.getDueDate() != null;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.duedate";
    }

    public String getDefaultSortOrder() {
        return "DESC";
    }

    public LuceneFieldSorter getSorter() {
        return DateFieldSorter.ISSUE_DUEDATE_STATSMAPPER;
    }

    @Override
    public List<SortField> getSortFields(boolean sortOrder) {
        return Collections.singletonList(new SortField("sort_duedate", (FieldComparatorSource)new StringSortComparator(), sortOrder));
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put("dueDateFormatter", this.dateFieldFormat);
        Timestamp dueDate = issue.getDueDate();
        if (dueDate != null) {
            velocityParams.put(this.getId(), dueDate);
        }
        return this.renderTemplate("duedate-columnview.vm", velocityParams);
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory) {
        if (StringUtils.isNotBlank((String)changeHistory)) {
            try {
                Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S").parse(changeHistory);
                return this.dateFieldFormat.format(date);
            }
            catch (ParseException e) {
                log.warn("unable to parse duedate change history, falling back to unparsed date.");
            }
        }
        return super.prettyPrintChangeHistory(changeHistory);
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        if (StringUtils.isNotBlank((String)changeHistory)) {
            try {
                Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S").parse(changeHistory);
                return this.dateFieldFormat.formatDatePicker(date);
            }
            catch (ParseException e) {
                log.warn("unable to parse duedate change history, falling back to unparsed date.");
            }
        }
        return super.prettyPrintChangeHistory(changeHistory);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"date", (String)this.getId());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        Timestamp dueDate = issue.getDueDate();
        FieldJsonRepresentation fieldJsonRepresentation = new FieldJsonRepresentation(new JsonData((Object)Dates.asDateString((Timestamp)dueDate)));
        if (renderedVersionRequired && dueDate != null) {
            fieldJsonRepresentation.setRenderedData(new JsonData((Object)this.dateFieldFormat.format((Date)dueDate)));
        }
        return fieldJsonRepresentation;
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new DueDateRestFieldOperationsHandler(this.dateFieldFormat, this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        Timestamp dueDate = issue.getDueDate();
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), (String)this.csvDateFormatter.formatDate(dueDate));
    }
}

