/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.AbstractVersionsSystemField;
import com.atlassian.jira.issue.fields.AffectedVersionsField;
import com.atlassian.jira.issue.fields.LongIdsValueHolder;
import com.atlassian.jira.issue.fields.event.AffectedVersionCreatedInlineEvent;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.AffectedVersionsRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.util.VersionHelperBean;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.AffectedVersionSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.RaisedInVersionStatisticsMapper;
import com.atlassian.jira.issue.views.SearchLinkGenerator;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AffectedVersionsSystemField
extends AbstractVersionsSystemField
implements AffectedVersionsField,
RestFieldOperations {
    private static final String AFFECTED_VERSIONS_NAME_KEY = "issue.field.affectsversions";
    public static final String CHANGE_ITEM_FIELD = "Version";
    private final RaisedInVersionStatisticsMapper raisedInVersionStatsMapper;
    private final EventPublisher eventPublisher;

    public AffectedVersionsSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, VersionManager versionManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, RaisedInVersionStatisticsMapper raisedInVersionStatsMapper, VersionHelperBean versionHelperBean, AffectedVersionSearchHandlerFactory searchHandlerFactory, JiraBaseUrls jiraBaseUrls, SearchLinkGenerator searchLinkGenerator, EventPublisher eventPublisher) {
        super("versions", AFFECTED_VERSIONS_NAME_KEY, templatingEngine, applicationProperties, versionManager, permissionManager, authenticationContext, versionHelperBean, searchHandlerFactory, searchLinkGenerator, jiraBaseUrls);
        this.raisedInVersionStatsMapper = raisedInVersionStatsMapper;
        this.eventPublisher = eventPublisher;
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    @Override
    protected Collection<Version> getCurrentVersions(Issue issue) {
        return issue.getAffectedVersions();
    }

    @Override
    protected String getArchivedVersionsFieldTitle() {
        return "issue.field.archived.affectsversions";
    }

    @Override
    protected String getArchivedVersionsFieldSearchParam() {
        return "affectedVersion";
    }

    @Override
    protected boolean getUnreleasedVersionsFirst() {
        return false;
    }

    @Override
    protected void addFieldRequiredErrorMessage(Issue issue, ErrorCollection errorCollection, I18nHelper i18n) {
        if (this.getPossibleVersions(issue.getProjectObject(), false).isEmpty()) {
            errorCollection.addErrorMessage(i18n.getText("createissue.error.versions.required", i18n.getText(this.getNameKey()), issue.getProjectObject().getName()), ErrorCollection.Reason.VALIDATION_FAILED);
        } else {
            errorCollection.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.affectsversions";
    }

    public LuceneFieldSorter getSorter() {
        return this.raisedInVersionStatsMapper;
    }

    @Override
    protected String getIssueRelationName() {
        return "IssueVersion";
    }

    @Override
    protected String getChangeItemFieldName() {
        return CHANGE_ITEM_FIELD;
    }

    @Override
    protected List<ChangeItemBean> updateIssueValue(Issue issue, Collection<Version> newValue) {
        return this.versionManager.updateIssueAffectsVersions(issue, newValue);
    }

    @Override
    protected String getModifiedWithoutPermissionErrorMessage(I18nHelper i18n) {
        throw new UnsupportedOperationException("Affected Versions field is not protected by permission.");
    }

    @Override
    public Collection<Version> getDefaultValue(Issue issue) {
        return Collections.emptyList();
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        LongIdsValueHolder versions = LongIdsValueHolder.fromFieldValuesHolder(this.getId(), fieldValueHolder);
        if (versions != null) {
            List affectedVersions = this.versionHelperBean.createNewVersions(issue.getProjectId(), versions.getValuesToAdd());
            for (Version affectedVersion : affectedVersions) {
                this.eventPublisher.publish((Object)new AffectedVersionCreatedInlineEvent(affectedVersion));
            }
            affectedVersions.addAll(this.getValueFromParams(fieldValueHolder));
            if (!versions.getValuesToAdd().isEmpty()) {
                Iterable ids = Iterables.transform((Iterable)affectedVersions, (Function)new Function<Version, Long>(){

                    public Long apply(Version input) {
                        return input.getId();
                    }
                });
                fieldValueHolder.put(this.getId(), new LongIdsValueHolder(Lists.newArrayList((Iterable)ids)));
            }
            issue.setAffectedVersions((Collection)affectedVersions);
        }
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setAffectedVersions(Collections.emptyList());
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new AffectedVersionsRestFieldOperationsHandler(this.versionManager, this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }
}

