/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDurationSystemField
extends NavigableFieldImpl
implements RestAwareField,
ExportableSystemField {
    public AbstractDurationSystemField(String id, String nameKey, String columnHeadingKey, String defaultSortOrder, Comparator comparator, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext) {
        super(id, nameKey, columnHeadingKey, defaultSortOrder, templatingEngine, applicationProperties, authenticationContext);
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        Long duration = this.getDuration(issue);
        if (duration != null) {
            String durationString = Boolean.TRUE.equals(displayParams.get("excel_view")) ? duration.toString() : this.durationUtils().getFormattedDuration(duration);
            velocityParams.put("duration", durationString);
        }
        return this.renderTemplate("duration-columnview.vm", velocityParams);
    }

    protected abstract Long getDuration(Issue var1);

    @Override
    public String prettyPrintChangeHistory(String changeHistory) {
        if (StringUtils.isNotBlank((String)changeHistory)) {
            return this.durationUtils().getFormattedDuration(new Long(changeHistory));
        }
        return super.prettyPrintChangeHistory(changeHistory);
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        if (StringUtils.isNotBlank((String)changeHistory)) {
            return this.durationUtils().getFormattedDuration(new Long(changeHistory), i18nHelper.getLocale());
        }
        return super.prettyPrintChangeHistory(changeHistory);
    }

    private JiraDurationUtils durationUtils() {
        return (JiraDurationUtils)ComponentAccessor.getComponent(JiraDurationUtils.class);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"number", (String)this.getId());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Long duration = this.getDuration(issue);
        if (renderedVersionRequested) {
            JiraDurationUtils jiraDurationUtils = this.durationUtils();
            String durationString = duration == null ? null : jiraDurationUtils.getFormattedDuration(duration);
            return new FieldJsonRepresentation(new JsonData((Object)duration), new JsonData((Object)durationString));
        }
        return new FieldJsonRepresentation(new JsonData((Object)duration));
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        Long duration = this.getDuration(issue);
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), (String)(duration != null ? String.valueOf(duration) : null));
    }
}

