/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.imports.project.customfield.NoTransformationCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.DatePickerConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.DateTimeCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.export.customfield.CustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.ExportableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.history.DateTimeFieldChangeLogHelper;
import com.atlassian.jira.issue.views.util.csv.CsvDateFormatter;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DateTimeCFType
extends AbstractSingleFieldType<Date>
implements SortableCustomField<Date>,
ProjectImportableCustomField,
DateField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations,
ExportableCustomFieldType {
    private final ProjectCustomFieldImporter projectCustomFieldImporter;
    private final DateTimeFormatter datePickerFormatter;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ApplicationProperties applicationProperties;
    private final DateTimeFieldChangeLogHelper dateTimeFieldChangeLogHelper;
    private final CsvDateFormatter csvDateFormatter;

    public DateTimeCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, DateTimeFormatterFactory dateTimeFormatterFactory, JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties, DateTimeFieldChangeLogHelper dateTimeFieldChangeLogHelper, CsvDateFormatter csvDateFormatter) {
        super(customFieldValuePersister, genericConfigManager);
        this.applicationProperties = applicationProperties;
        this.dateTimeFieldChangeLogHelper = dateTimeFieldChangeLogHelper;
        this.projectCustomFieldImporter = new NoTransformationCustomFieldImporter();
        this.datePickerFormatter = dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE_TIME_PICKER);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.csvDateFormatter = csvDateFormatter;
    }

    public DateTimeCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, DateTimeFormatterFactory dateTimeFormatterFactory, JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties, DateTimeFieldChangeLogHelper dateTimeFieldChangeLogHelper) {
        this(customFieldValuePersister, genericConfigManager, dateTimeFormatterFactory, jiraAuthenticationContext, applicationProperties, dateTimeFieldChangeLogHelper, (CsvDateFormatter)ComponentAccessor.getComponentOfType(CsvDateFormatter.class));
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_DATE;
    }

    protected Object getDbValueFromObject(Date customFieldObject) {
        return customFieldObject;
    }

    protected Date getObjectFromDbValue(@Nonnull Object databaseValue) throws FieldValidationException {
        return (Date)databaseValue;
    }

    public String getStringFromSingularObject(Date customFieldObject) {
        return this.datePickerFormatter.format(customFieldObject);
    }

    public String getChangelogString(CustomField field, Date value) {
        if (value == null) {
            return "";
        }
        return this.getStringFromSingularObject(value);
    }

    public String getChangelogValue(CustomField field, Date value) {
        if (value == null) {
            return "";
        }
        return this.dateTimeFieldChangeLogHelper.createChangelogValueForDateTimeField(value);
    }

    public Date getSingularObjectFromString(String string) throws FieldValidationException {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try {
            Date date = this.datePickerFormatter.parse(string);
            return new Timestamp(date.getTime());
        }
        catch (IllegalArgumentException e) {
            I18nHelper i18nBean = this.jiraAuthenticationContext.getI18nHelper();
            throw new FieldValidationException(i18nBean.getText("fields.validation.data.format", this.applicationProperties.getDefaultBackedString("jira.date.time.picker.java.format")));
        }
    }

    public int compare(@Nonnull Date v1, @Nonnull Date v2, FieldConfig fieldConfig) {
        return v1.compareTo(v2);
    }

    public Date getDefaultValue(FieldConfig fieldConfig) {
        Date defaultValue = (Date)this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (this.isUseNow(defaultValue)) {
            defaultValue = new Timestamp(new Date().getTime());
        }
        return defaultValue;
    }

    public boolean isUseNow(Date date) {
        return DatePickerConverter.USE_NOW_DATE.equals(date);
    }

    public boolean isUseNow(FieldConfig fieldConfig) {
        Date defaultValue = (Date)this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        return this.isUseNow(defaultValue);
    }

    public String getNow() {
        return this.datePickerFormatter.format(new Date());
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map map = super.getVelocityParameters(issue, field, fieldLayoutItem);
        map.put("dateTimePicker", Boolean.TRUE);
        map.put("datePickerFormatter", this.datePickerFormatter);
        map.put("titleFormatter", this.datePickerFormatter.withStyle(DateTimeStyle.COMPLETE));
        map.put("iso8601Formatter", this.datePickerFormatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME));
        return map;
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitDateTime(this);
        }
        return super.accept(visitor);
    }

    public FieldExportParts getRepresentationFromIssue(Issue issue, CustomFieldExportContext context) {
        Date value = (Date)this.getValueFromIssue(context.getCustomField(), issue);
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)context.getCustomField().getId(), (String)context.getDefaultColumnHeader(), (String)this.csvDateFormatter.formatDateTime(value));
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom((String)"datetime", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Date date = (Date)this.getValueFromIssue(field, issue);
        if (date == null) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        FieldJsonRepresentation pair = new FieldJsonRepresentation(new JsonData((Object)Dates.asTimeString((Date)date)));
        if (renderedVersionRequested) {
            pair.setRenderedData(new JsonData((Object)((DateTimeFormatterFactory)ComponentAccessor.getComponent(DateTimeFormatterFactory.class)).formatter().forLoggedInUser().format(date)));
        }
        return pair;
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new DateTimeCustomFieldOperationsHandler(field, this.datePickerFormatter, this.getI18nBean());
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitDateTime(DateTimeCFType var1);
    }
}

