/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.imports.project.customfield.NoTransformationCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.DatePickerConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.DateCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.export.customfield.CustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.ExportableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.history.DateTimeFieldChangeLogHelper;
import com.atlassian.jira.issue.views.util.csv.CsvDateFormatter;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.util.concurrent.LazyReference;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DateCFType
extends AbstractSingleFieldType<Date>
implements SortableCustomField<Date>,
ProjectImportableCustomField,
DateField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations,
ExportableCustomFieldType {
    protected final DatePickerConverter dateConverter;
    private final DateTimeFieldChangeLogHelper dateTimeFieldChangeLogHelper;
    private final ProjectCustomFieldImporter projectCustomFieldImporter;
    private final DateFieldFormat dateFieldFormat;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final CsvDateFormatter csvDateFormatter;
    @ClusterSafe
    private final LazyReference<DateTimeFormatter> iso8601Formatter = new LazyIso8601DateFormatter();

    public DateCFType(CustomFieldValuePersister customFieldValuePersister, DatePickerConverter dateConverter, GenericConfigManager genericConfigManager, DateTimeFieldChangeLogHelper dateTimeFieldChangeLogHelper, DateFieldFormat dateFieldFormat, DateTimeFormatterFactory dateTimeFormatterFactory, CsvDateFormatter csvDateFormatter) {
        super(customFieldValuePersister, genericConfigManager);
        this.dateConverter = dateConverter;
        this.dateTimeFieldChangeLogHelper = dateTimeFieldChangeLogHelper;
        this.projectCustomFieldImporter = new NoTransformationCustomFieldImporter();
        this.dateFieldFormat = dateFieldFormat;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.csvDateFormatter = csvDateFormatter;
    }

    @Deprecated
    public DateCFType(CustomFieldValuePersister customFieldValuePersister, DatePickerConverter dateConverter, GenericConfigManager genericConfigManager, DateTimeFieldChangeLogHelper dateTimeFieldChangeLogHelper, DateFieldFormat dateFieldFormat, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this(customFieldValuePersister, dateConverter, genericConfigManager, dateTimeFieldChangeLogHelper, dateFieldFormat, dateTimeFormatterFactory, (CsvDateFormatter)ComponentAccessor.getComponentOfType(CsvDateFormatter.class));
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_DATE;
    }

    protected Object getDbValueFromObject(Date customFieldObject) {
        return customFieldObject;
    }

    protected Date getObjectFromDbValue(@Nonnull Object databaseValue) throws FieldValidationException {
        return (Timestamp)databaseValue;
    }

    public String getChangelogString(CustomField field, Date value) {
        if (value == null) {
            return "";
        }
        return this.getStringFromSingularObject(value);
    }

    public String getChangelogValue(CustomField field, Date value) {
        if (value == null) {
            return "";
        }
        return this.dateTimeFieldChangeLogHelper.createChangelogValueForDateField(value);
    }

    public String getStringFromSingularObject(Date customFieldObject) {
        return this.dateConverter.getString(customFieldObject);
    }

    public Date getSingularObjectFromString(String string) throws FieldValidationException {
        return this.dateConverter.getTimestamp(string);
    }

    public int compare(@Nonnull Date v1, @Nonnull Date v2, FieldConfig fieldConfig) {
        return v1.compareTo(v2);
    }

    public Date getDefaultValue(FieldConfig fieldConfig) {
        Date defaultValue = (Date)this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (this.isUseNow(defaultValue)) {
            defaultValue = new Timestamp(new Date().getTime());
        }
        return defaultValue;
    }

    public boolean isUseNow(Date date) {
        return DatePickerConverter.USE_NOW_DATE.equals(date);
    }

    public boolean isUseNow(FieldConfig fieldConfig) {
        Date defaultValue = (Date)this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        return this.isUseNow(defaultValue);
    }

    public String getNow() {
        return this.dateConverter.getString(new Date());
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map velocityParameters = super.getVelocityParameters(issue, field, fieldLayoutItem);
        velocityParameters.put("dateFieldFormat", this.dateFieldFormat);
        velocityParameters.put("iso8601Formatter", this.iso8601Formatter.get());
        return velocityParameters;
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitDate(this);
        }
        return super.accept(visitor);
    }

    public FieldExportParts getRepresentationFromIssue(Issue issue, CustomFieldExportContext context) {
        CustomField customField = context.getCustomField();
        Date value = (Date)this.getValueFromIssue(customField, issue);
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)customField.getId(), (String)context.getDefaultColumnHeader(), (String)this.csvDateFormatter.formatDate(value));
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom((String)"date", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Date date = (Date)this.getValueFromIssue(field, issue);
        if (date == null) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        FieldJsonRepresentation pair = new FieldJsonRepresentation(new JsonData((Object)Dates.asDateString((Date)date)));
        if (renderedVersionRequested) {
            pair.setRenderedData(new JsonData((Object)this.dateFieldFormat.format(date)));
        }
        return pair;
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new DateCustomFieldOperationsHandler(field, this.dateFieldFormat, this.getI18nBean());
    }

    private class LazyIso8601DateFormatter
    extends LazyReference<DateTimeFormatter> {
        private LazyIso8601DateFormatter() {
        }

        protected DateTimeFormatter create() {
            return DateCFType.this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE).withSystemZone();
        }
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitDate(DateCFType var1);
    }
}

