/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context.persistence;

import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TenantInfo(value=TenantAware.UNRESOLVED)
public class FieldConfigContextPersisterWorker {
    protected static final String DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY = "jira.jvc.FieldConfigContextPersisterWorker.configContextsBySchemeId.request";
    public static final String ENTITY_TABLE_NAME = "ConfigurationContext";
    public static final String ENTITY_PROJECT = "project";
    public static final String ENTITY_KEY = "key";
    public static final String ENTITY_SCHEME_ID = "fieldconfigscheme";
    private final OfBizDelegator delegator;
    private final ProjectManager projectManager;
    private static final Logger log = LoggerFactory.getLogger(FieldConfigContextPersisterWorker.class);
    @TenantInfo(value=TenantAware.TENANTED)
    private final SingleValueLocalCache<Multimap<Long, GenericValue>> configContextsBySchemeId;

    public FieldConfigContextPersisterWorker(OfBizDelegator delegator, ProjectManager projectManager, SwitchingCacheFactory cacheFactory) {
        this.delegator = delegator;
        this.projectManager = projectManager;
        this.configContextsBySchemeId = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".configContextsBySchemeId", this::loadConfigContext, DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
    }

    @Nonnull
    public List<JiraContextNode> getAllContextsForConfigScheme(@Nonnull FieldConfigScheme fieldConfigScheme) {
        return this.configContextsBySchemeId.get().get((Object)fieldConfigScheme.getId()).stream().filter(this::filterGenericValues).map(this::transformToDomainObject).collect(Collectors.toList());
    }

    public void removeContextsForConfigScheme(@Nonnull FieldConfigScheme fieldConfigScheme) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_SCHEME_ID, (Object)fieldConfigScheme.getId()));
        this.invalidateAll();
        log.debug("{} contexts deleted for field config scheme with id '{}'", (Object)result, (Object)fieldConfigScheme.getId());
    }

    public void removeContextsForProject(@Nonnull Project project) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_PROJECT, (Object)project.getId()));
        this.invalidateAll();
        log.debug("{} contexts deleted for {}", (Object)result, (Object)project);
    }

    @Nullable
    public Object retrieve(@Nullable JiraContextNode context, String key) {
        List result;
        if (context != null && (result = this.delegator.findByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap(context).add((Object)ENTITY_KEY, (Object)key).toMap())) != null && !result.isEmpty()) {
            Long schemeId = ((GenericValue)result.iterator().next()).getLong(ENTITY_SCHEME_ID);
            if (result.size() > 1) {
                log.warn("More than one FieldConfigScheme returned for a given context. Database may be corrupted.Returning first Long: {}. Context: {} with key: {} returned {}.", new Object[]{schemeId, context, key, result});
            }
            return schemeId;
        }
        return null;
    }

    public void store(String fieldId, JiraContextNode contextNode, FieldConfigScheme fieldConfigScheme) {
        if (this.retrieve(contextNode, fieldId) != null) {
            this.remove(contextNode, fieldId);
        }
        if (fieldConfigScheme != null) {
            MapBuilder<String, Object> props = this.transformToFieldsMap(contextNode);
            props.add((Object)ENTITY_KEY, (Object)fieldId);
            props.add((Object)ENTITY_SCHEME_ID, (Object)fieldConfigScheme.getId());
            this.delegator.createValue(ENTITY_TABLE_NAME, props.toMap());
        }
        this.invalidateAll();
    }

    public void remove(@Nullable JiraContextNode context, @Nullable String key) {
        if (context != null && key != null) {
            this.delegator.removeByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap(context).add((Object)ENTITY_KEY, (Object)key).toMap());
            this.invalidateAll();
        } else {
            log.warn("Context or key was null. Nothing was removed");
        }
    }

    void invalidateAll() {
        this.configContextsBySchemeId.reset();
    }

    private MapBuilder<String, Object> transformToFieldsMap(JiraContextNode contextNode) {
        return MapBuilder.newBuilder((Map)contextNode.appendToParamsMap(Collections.emptyMap()));
    }

    private JiraContextNode transformToDomainObject(GenericValue contextAsGv) {
        return new ProjectContext(contextAsGv.getLong(ENTITY_PROJECT), this.projectManager);
    }

    private boolean filterGenericValues(@Nonnull GenericValue contextAsGv) {
        Long projectId = contextAsGv.getLong(ENTITY_PROJECT);
        return projectId == null || this.projectManager.getProjectObj(projectId) != null;
    }

    private Multimap<Long, GenericValue> loadConfigContext() {
        List genericValues = this.delegator.findAll(ENTITY_TABLE_NAME);
        ArrayListMultimap cacheValues = ArrayListMultimap.create();
        for (GenericValue genericValue : genericValues) {
            cacheValues.put((Object)genericValue.getLong(ENTITY_SCHEME_ID), (Object)genericValue);
        }
        return cacheValues;
    }
}

