/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.admin.ApplicationProperty;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentComparator;
import com.atlassian.jira.issue.comments.CommentImpl;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.CommentSummary;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.comments.StreamingCommentsRetriever;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraDateUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class CommentSearchManager {
    public static final int NUMBER_OF_NEW_COMMENTS_TO_SHOW = 5;
    private final UserManager userManager;
    private final OfBizDelegator delegator;
    private final IssueManager issueManager;
    private final ProjectRoleManager projectRoleManager;
    private final CommentPermissionManager commentPermissionManager;
    private final FeatureManager featureManager;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final StreamingCommentsRetriever streamingCommentsRetriever;
    private static final String COMMENT_ID = "id";
    private static final int DEFAULT_MINIMUM_NUMBER_OF_HIDDEN_COMMENTS = 4;
    private static final int MAX_COMMENTS_TO_LOAD_BY_ID = 100;

    public CommentSearchManager(UserManager userManager, OfBizDelegator delegator, IssueManager issueManager, ProjectRoleManager projectRoleManager, CommentPermissionManager commentPermissionManager, FeatureManager featureManager, ApplicationPropertiesService applicationPropertiesService, StreamingCommentsRetriever streamingCommentsRetriever) {
        this.userManager = userManager;
        this.delegator = delegator;
        this.issueManager = issueManager;
        this.projectRoleManager = projectRoleManager;
        this.commentPermissionManager = commentPermissionManager;
        this.featureManager = featureManager;
        this.applicationPropertiesService = applicationPropertiesService;
        this.streamingCommentsRetriever = streamingCommentsRetriever;
    }

    public Comment convertToComment(GenericValue gv) {
        return this.convertToComment(gv, (Issue)this.issueManager.getIssueObject(gv.getLong("issue")));
    }

    public Comment getCommentById(Long commentId) {
        return this.getMutableComment(commentId);
    }

    public MutableComment getMutableComment(Long commentId) {
        if (commentId == null) {
            throw new IllegalArgumentException("The comment id must not be null.");
        }
        GenericValue gv = this.delegator.findById("Action", commentId);
        if (gv != null) {
            return this.convertToComment(gv, (Issue)this.issueManager.getIssueObject(gv.getLong("issue")));
        }
        return null;
    }

    public List<Comment> getComments(Issue issue) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        try {
            List allComments = this.issueManager.getEntitiesByIssueObject("IssueComments", issue);
            for (Object allComment : allComments) {
                MutableComment comment = this.convertToComment((GenericValue)allComment, issue);
                comments.add((Comment)comment);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        Collections.sort(comments, CommentComparator.COMPARATOR);
        return comments;
    }

    @Nonnull
    public List<Comment> getCommentsForUserSince(@Nonnull Issue issue, @Nullable ApplicationUser user, @Nonnull Date since) {
        EntityFieldMap issueCommentsCondition = new EntityFieldMap((Map)FieldMap.build((String)"issue", (Object)issue.getId(), (String)"type", (Object)"comment"), EntityOperator.AND);
        EntityExpr dateCondition = new EntityExpr("updated", EntityOperator.GREATER_THAN, (Object)new Timestamp(since.getTime()));
        EntityConditionList finalCondition = new EntityConditionList(Arrays.asList(issueCommentsCondition, dateCondition), EntityOperator.AND);
        List commentsSinceDate = this.delegator.findByCondition("Action", (EntityCondition)finalCondition, null, (List)ImmutableList.of((Object)"updated DESC", (Object)"id ASC"));
        return this.getVisibleComments(issue, user, commentsSinceDate);
    }

    public List<Comment> getCommentsForUser(Issue issue, ApplicationUser user) {
        List<Comment> visibleComments;
        try {
            List allComments = this.issueManager.getEntitiesByIssueObject("IssueComments", issue);
            visibleComments = this.getVisibleComments(issue, user, allComments);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        Collections.sort(visibleComments, CommentComparator.COMPARATOR);
        return visibleComments;
    }

    public Stream<Comment> streamComments(@Nullable ApplicationUser user, @Nonnull Issue issue) {
        return this.streamingCommentsRetriever.stream(user, issue);
    }

    private List<Comment> getVisibleComments(Issue issue, ApplicationUser user, List<GenericValue> commentValues) {
        ArrayList<Comment> visibleComments = new ArrayList<Comment>();
        for (GenericValue commentGV : commentValues) {
            MutableComment comment = this.convertToComment(commentGV, issue);
            if (!this.commentPermissionManager.hasBrowsePermission(user, (Comment)comment)) continue;
            visibleComments.add((Comment)comment);
        }
        return visibleComments;
    }

    private MutableComment convertToComment(GenericValue gv, Issue issue) {
        Timestamp createdTS = gv.getTimestamp("created");
        Timestamp updatedTS = gv.getTimestamp("updated");
        CommentImpl comment = new CommentImpl(this.projectRoleManager, this.userManager.getUserByKeyEvenWhenUnknown(gv.getString("author")), this.userManager.getUserByKeyEvenWhenUnknown(gv.getString("updateauthor")), gv.getString("body"), gv.getString("level"), gv.getLong("rolelevel"), JiraDateUtils.copyDateNullsafe((Date)createdTS), JiraDateUtils.copyDateNullsafe((Date)updatedTS), issue);
        comment.setId(gv.getLong(COMMENT_ID));
        return comment;
    }

    public CommentSummary getCommentSummary(@Nullable ApplicationUser user, @Nonnull Issue issue, @Nonnull Optional<Long> focusedCommentId) {
        List<Long> visibleCommentIds;
        List<Long> commentIdsToLoad = visibleCommentIds = this.getVisibleCommentIds(issue, user);
        if (this.shouldCommentsBeLimited(visibleCommentIds)) {
            commentIdsToLoad = visibleCommentIds.subList(0, Math.min(5, visibleCommentIds.size()));
            if (focusedCommentId.isPresent() && !commentIdsToLoad.contains(focusedCommentId.get())) {
                commentIdsToLoad = visibleCommentIds;
            }
        }
        ArrayList finalComments = Lists.newArrayList();
        if (commentIdsToLoad.size() > 100) {
            finalComments.addAll(this.getCommentsForUser(issue, user));
            return new CommentSummary(finalComments.size(), (List)finalComments);
        }
        finalComments.addAll(this.getCommentsForIds(commentIdsToLoad, issue));
        return new CommentSummary(visibleCommentIds.size(), (List)finalComments);
    }

    private boolean shouldCommentsBeLimited(List<Long> visibleCommentIds) {
        ApplicationProperty applicationProperty = this.applicationPropertiesService.getApplicationProperty("jira.comment.collapsing.minimum.hidden");
        int minimumCommentsToHide = applicationProperty != null ? Integer.parseInt(applicationProperty.getCurrentValue()) : 4;
        boolean limitComments = true;
        if (this.featureManager.isEnabled(CoreFeatures.PREVENT_COMMENTS_LIMITING) || minimumCommentsToHide == 0 || visibleCommentIds.size() - 5 < minimumCommentsToHide) {
            limitComments = false;
        }
        return limitComments;
    }

    private List<Comment> getCommentsForIds(List<Long> commentIds, Issue issue) {
        if (commentIds.isEmpty()) {
            return Collections.emptyList();
        }
        EntityExpr commentIdCondition = new EntityExpr(COMMENT_ID, EntityOperator.IN, commentIds);
        List commentsToReturn = this.delegator.findByCondition("Action", (EntityCondition)commentIdCondition, null, null);
        return commentsToReturn.stream().map(comment -> this.convertToComment((GenericValue)comment, issue)).collect(Collectors.toList());
    }

    private List<Long> getVisibleCommentIds(@Nonnull Issue issue, @Nullable ApplicationUser user) {
        EntityFieldMap issueCommentsCondition = new EntityFieldMap((Map)FieldMap.build((String)"issue", (Object)issue.getId(), (String)"type", (Object)"comment"), EntityOperator.AND);
        List allComments = this.delegator.findByCondition("Action", (EntityCondition)issueCommentsCondition, (Collection)ImmutableList.of((Object)COMMENT_ID, (Object)"level", (Object)"rolelevel"), (List)ImmutableList.of((Object)"created DESC"));
        return allComments.stream().map(commentGv -> CommentForPermissionCheck.toComment(issue, commentGv)).filter(comment -> this.commentPermissionManager.hasBrowsePermission(user, comment)).map(Comment::getId).collect(Collectors.toList());
    }

    private static final class CommentForPermissionCheck
    implements Comment {
        private Issue issue;
        private String level;
        private Long id;
        private Long rolelevel;

        private CommentForPermissionCheck(Issue issue, String level, Long id, Long rolelevel) {
            this.issue = issue;
            this.level = level;
            this.id = id;
            this.rolelevel = rolelevel;
        }

        public static Comment toComment(Issue issue, GenericValue commentGv) {
            return new CommentForPermissionCheck(issue, commentGv.getString("level"), commentGv.getLong(CommentSearchManager.COMMENT_ID), commentGv.getLong("rolelevel"));
        }

        public String getAuthor() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getAuthorKey() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public ApplicationUser getAuthorUser() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public ApplicationUser getAuthorApplicationUser() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getAuthorFullName() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getBody() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Date getCreated() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getGroupLevel() {
            return this.level;
        }

        public Long getId() {
            return this.id;
        }

        public Long getRoleLevelId() {
            return this.rolelevel;
        }

        public ProjectRole getRoleLevel() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Issue getIssue() {
            return this.issue;
        }

        public String getUpdateAuthor() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public ApplicationUser getUpdateAuthorUser() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public ApplicationUser getUpdateAuthorApplicationUser() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getUpdateAuthorFullName() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Date getUpdated() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

