/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.httpsession;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.log4j.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TenantInfo(value=TenantAware.UNRESOLVED)
public class HttpSessionUsageListener
implements HttpSessionAttributeListener {
    private static final Logger log = LoggerFactory.getLogger(HttpSessionUsageListener.class);
    private static final boolean LISTENER_ENABLED = JiraSystemProperties.getInstance().getBoolean("httpsession.logger.enabled");
    private static final String SESSION_ATTRIBUTE_CLASS = "session_attribute_class";
    private static final String SESSION_KEY_NAME = "session_key_name";
    private Set<String> nameCache = Collections.newSetFromMap(CacheBuilder.newBuilder().maximumSize(100L).build().asMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeAdded(HttpSessionBindingEvent event) {
        if (LISTENER_ENABLED && this.nameCache.add(event.getName())) {
            try {
                StringBuilder message = new StringBuilder();
                MDC.put((String)SESSION_KEY_NAME, (Object)event.getName());
                message.append("New http session key: ").append(event.getName());
                if (event.getValue() != null) {
                    String clazzName = event.getValue().getClass().getName();
                    MDC.put((String)SESSION_ATTRIBUTE_CLASS, (Object)clazzName);
                    message.append(", class: ").append(clazzName);
                }
                log.info(message.toString());
            }
            finally {
                MDC.remove((String)SESSION_KEY_NAME);
                MDC.remove((String)SESSION_ATTRIBUTE_CLASS);
            }
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
    }
}

