/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.instrumentation.AtomicCounter;
import com.atlassian.instrumentation.Counter;
import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.bc.project.index.ProjectReindexService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.index.ha.OfBizNodeIndexCounterStore;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.SharedEntityResolver;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.task.AlreadyExecutingException;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeReindexService
implements NodeReindexService {
    private static final Logger log = LoggerFactory.getLogger(DefaultNodeReindexService.class);
    private final ClusterManager clusterManager;
    private final OfBizNodeIndexCounterStore ofBizNodeIndexCounterStore;
    private final OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore;
    private final IssueIndexManager indexManager;
    private final SharedEntityIndexer sharedEntityIndexer;
    private final ProjectManager projectManager;
    private final ProjectReindexService projectReindexService;
    private final IssueManager issueManager;
    private final CommentManager commentManager;
    private final WorklogManager worklogManager;
    private final OfBizDelegator ofBizDelegator;
    private final SharedEntityResolver sharedEntityResolver;
    private final IndexCopyService indexCopyService;
    private final IssueIndexingService indexingService;
    private final IssueFactory issueFactory;
    public static final String ISSUE_ENTITY = "Issue";
    private final Runnable indexer = this::reIndex;
    @Nullable
    private final ScheduledExecutorService scheduler;
    private final LatestGaugeValue latestGaugeValue = new LatestGaugeValue();
    private final Counter totalOperationCountInstrument;
    @Nullable
    private ScheduledFuture<?> indexerService;
    private static final int INITIAL_DELAY = 10;
    private static final int PERIOD = 5;

    public DefaultNodeReindexService(ClusterManager clusterManager, OfBizNodeIndexCounterStore ofBizNodeIndexCounterStore, OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore, IssueIndexManager indexManager, SharedEntityIndexer sharedEntityIndexer, ProjectManager projectManager, ProjectReindexService projectReindexService, IssueManager issueManager, CommentManager commentManager, WorklogManager worklogManager, OfBizDelegator ofBizDelegator, SharedEntityResolver sharedEntityResolver, IndexCopyService indexCopyService, IssueIndexingService indexingService, IssueFactory issueFactory) {
        this.clusterManager = clusterManager;
        this.ofBizNodeIndexCounterStore = ofBizNodeIndexCounterStore;
        this.ofBizNodeIndexOperationStore = ofBizNodeIndexOperationStore;
        this.indexManager = indexManager;
        this.sharedEntityIndexer = sharedEntityIndexer;
        this.projectManager = projectManager;
        this.projectReindexService = projectReindexService;
        this.issueManager = issueManager;
        this.commentManager = commentManager;
        this.worklogManager = worklogManager;
        this.ofBizDelegator = ofBizDelegator;
        this.sharedEntityResolver = sharedEntityResolver;
        this.indexCopyService = indexCopyService;
        this.indexingService = indexingService;
        this.issueFactory = issueFactory;
        if (clusterManager.isClustered()) {
            this.scheduler = Executors.newScheduledThreadPool(1, ThreadFactories.namedThreadFactory("NodeReindexServiceThread"));
            this.totalOperationCountInstrument = new AtomicCounter(InstrumentationName.CLUSTER_REPLICATED_INDEX_OPERATIONS_TOTAL.getInstrumentName());
            ExternalGauge operationCountInstrument = new ExternalGauge(InstrumentationName.CLUSTER_REPLICATED_INDEX_OPERATIONS_LATEST.getInstrumentName(), (ExternalValue)this.latestGaugeValue);
            Instrumentation.putInstrument((Instrument)this.totalOperationCountInstrument);
            Instrumentation.putInstrument((Instrument)operationCountInstrument);
        } else {
            this.scheduler = null;
            this.totalOperationCountInstrument = null;
        }
    }

    @Override
    public void cancel() {
        this.pause();
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    @Override
    public synchronized void start() {
        if (this.scheduler != null) {
            if (this.indexerService == null) {
                this.indexerService = this.scheduler.scheduleWithFixedDelay(this.indexer, 10L, 5L, TimeUnit.SECONDS);
            } else if (log.isDebugEnabled()) {
                log.debug("Start called on NodeReindexService when already running", (Throwable)new IllegalStateException());
            }
        }
    }

    @Override
    public synchronized void pause() {
        if (this.indexerService != null) {
            this.indexerService.cancel(true);
            this.indexerService = null;
        }
    }

    @Override
    public void restart() {
        this.pause();
        this.start();
    }

    @Override
    public void resetIndexCount() {
        String currentNodeId = this.getCurrentNodeId();
        for (Node node : this.clusterManager.getAllNodes()) {
            Long lastId = this.ofBizNodeIndexOperationStore.getLatestOperation(node.getNodeId());
            if (lastId == null) continue;
            this.ofBizNodeIndexCounterStore.storeHighestIdForNode(currentNodeId, node.getNodeId(), lastId);
        }
    }

    @Override
    public boolean canIndexBeRebuilt() {
        String currentNodeId = this.getCurrentNodeId();
        for (Node node : this.clusterManager.getAllNodes()) {
            Long latestOperation;
            long lastIndexed;
            String nodeId = node.getNodeId();
            if (!node.isClustered() || nodeId == null || nodeId.equals(currentNodeId) || this.ofBizNodeIndexOperationStore.contains(lastIndexed = this.getCurrentIndexCount(currentNodeId, nodeId)) || (latestOperation = this.ofBizNodeIndexOperationStore.getLatestOperation(nodeId)) == null) continue;
            return false;
        }
        return this.indexManager.isIndexConsistent();
    }

    @Override
    public void replayLocalOperations() {
        if (this.scheduler != null) {
            this.scheduler.submit(() -> {
                block5: {
                    try {
                        String nodeId = this.getCurrentNodeId();
                        Set<ReplicatedIndexOperation> indexOps = this.ofBizNodeIndexOperationStore.getIndexOperationsAfter(nodeId, this.getCurrentIndexCount(nodeId, nodeId));
                        if (indexOps.isEmpty()) break block5;
                        try {
                            this.updateAffectedIndexes(indexOps);
                        }
                        finally {
                            this.updateIndexCount(indexOps);
                        }
                    }
                    catch (Exception e) {
                        log.error("Error re-indexing node changes", (Throwable)e);
                    }
                }
            });
        }
    }

    @Nullable
    @VisibleForTesting
    ScheduledFuture<?> getIndexerService() {
        return this.indexerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reIndex() {
        String currentNodeId = this.getCurrentNodeId();
        if (currentNodeId == null) {
            return;
        }
        try {
            HashSet allIndexOps = Sets.newHashSet();
            Set<Node> allNodes = this.clusterManager.getAllNodes();
            for (Node node : allNodes) {
                if (currentNodeId.equals(node.getNodeId())) continue;
                Set<ReplicatedIndexOperation> indexOps = this.ofBizNodeIndexOperationStore.getIndexOperationsAfter(node.getNodeId(), this.getCurrentIndexCount(currentNodeId, node.getNodeId()));
                allIndexOps.addAll(indexOps);
            }
            if (!allIndexOps.isEmpty()) {
                try {
                    this.updateAffectedIndexes(allIndexOps);
                }
                finally {
                    this.updateIndexCount(allIndexOps);
                }
            }
            this.totalOperationCountInstrument.addAndGet((long)allIndexOps.size());
            this.latestGaugeValue.setValue(allIndexOps.size());
        }
        catch (Throwable e) {
            log.error("Error re-indexing node changes", e);
        }
    }

    private void updateIndexCount(Set<ReplicatedIndexOperation> indexOps) {
        String currentNodeId = this.getCurrentNodeId();
        Map<String, Long> highestNodeCounts = this.getHighestNodeCounts(indexOps);
        for (Map.Entry<String, Long> countEntry : highestNodeCounts.entrySet()) {
            this.ofBizNodeIndexCounterStore.storeHighestIdForNode(currentNodeId, countEntry.getKey(), countEntry.getValue());
        }
    }

    private String getCurrentNodeId() {
        return this.clusterManager.getNodeId();
    }

    private long getCurrentIndexCount(String receivingNodeId, String sendingNodeId) {
        return this.ofBizNodeIndexCounterStore.getIndexOperationCounterForNodeId(receivingNodeId, sendingNodeId);
    }

    private void updateAffectedIndexes(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        ReplicatedIndexOperation latestReindex = null;
        for (ReplicatedIndexOperation indexOp : indexOps) {
            if (!indexOp.getOperation().isReindexEnd() || latestReindex != null && indexOp.getIndexTime().getTime() <= latestReindex.getIndexTime().getTime()) continue;
            latestReindex = indexOp;
        }
        if (latestReindex != null) {
            this.resetIndexCount();
            this.indexCopyService.restoreIndex(latestReindex.getBackupFilename());
            return;
        }
        Map<AffectedIndex, Set<ReplicatedIndexOperation>> partitionedOperations = this.partition(indexOps);
        this.updateIssueIndex(partitionedOperations.get(AffectedIndex.ISSUE));
        this.updateCommentsIndex(partitionedOperations.get(AffectedIndex.COMMENT));
        this.updateSharedEntityIndex(partitionedOperations.get(AffectedIndex.SHAREDENTITY));
        this.updateWorklogsIndex(partitionedOperations.get(AffectedIndex.WORKLOG));
    }

    private void updateSharedEntityIndex(Set<ReplicatedIndexOperation> indexOps) {
        HashSet entitiesToIndex = Sets.newHashSet();
        HashSet entitiesToDelete = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            ReplicatedIndexOperation.Operation action = operation.getOperation();
            switch (action) {
                case UPDATE: 
                case CREATE: {
                    entitiesToIndex.addAll(this.sharedEntityResolver.getSharedEntities(operation.getEntityType(), operation.getAffectedIds()));
                    break;
                }
                case DELETE: {
                    entitiesToDelete.addAll(this.sharedEntityResolver.getDummySharedEntities(operation.getEntityType(), operation.getAffectedIds()));
                }
            }
        }
        if (!entitiesToIndex.isEmpty()) {
            this.sharedEntityIndexer.index(entitiesToIndex, false).await();
        }
        if (!entitiesToDelete.isEmpty()) {
            this.sharedEntityIndexer.deIndex(entitiesToDelete, false).await();
        }
    }

    private void updateCommentsIndex(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        HashSet commentsToIndex = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            for (Long id : operation.getAffectedIds()) {
                Comment comment = this.commentManager.getCommentById(id);
                if (comment == null) continue;
                commentsToIndex.add(comment);
            }
        }
        if (!commentsToIndex.isEmpty()) {
            this.indexingService.reIndexComments((Collection)commentsToIndex, Contexts.nullContext(), false);
        }
    }

    private void updateWorklogsIndex(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        HashSet worklogsToIndex = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            for (Long id : operation.getAffectedIds()) {
                Worklog worklog = this.worklogManager.getById(id);
                if (worklog == null) continue;
                worklogsToIndex.add(worklog);
            }
        }
        if (!worklogsToIndex.isEmpty()) {
            this.indexingService.reIndexWorklogs((Collection)worklogsToIndex, Contexts.nullContext(), false);
        }
    }

    private void updateIssueIndex(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        HashSet projectsToUpdate = Sets.newHashSet();
        HashSet issuesToUpdate = Sets.newHashSet();
        HashSet issuesAndRelatedIndexesToUpdate = Sets.newHashSet();
        TreeSet issuesToDelete = Sets.newTreeSet((Comparator)new Comparator<Issue>(){

            @Override
            public int compare(Issue o1, Issue o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        block6: for (ReplicatedIndexOperation operation : indexOps) {
            ReplicatedIndexOperation.Operation action = operation.getOperation();
            switch (action) {
                case UPDATE: 
                case CREATE: {
                    issuesToUpdate.addAll(this.issueManager.getIssueObjects(operation.getAffectedIds()));
                    break;
                }
                case UPDATE_WITH_RELATED: {
                    issuesAndRelatedIndexesToUpdate.addAll(this.issueManager.getIssueObjects(operation.getAffectedIds()));
                    break;
                }
                case DELETE: {
                    for (long id : operation.getAffectedIds()) {
                        GenericValue gv = this.ofBizDelegator.makeValue(ISSUE_ENTITY, (Map)ImmutableMap.of((Object)"id", (Object)id));
                        issuesToDelete.add(this.issueFactory.getIssue(gv));
                    }
                    continue block6;
                }
                case PROJECT_REINDEX: {
                    for (long id : operation.getAffectedIds()) {
                        Project project = this.projectManager.getProjectObj(Long.valueOf(id));
                        if (project == null) continue;
                        projectsToUpdate.add(project);
                    }
                    break;
                }
            }
        }
        issuesToUpdate.removeAll(issuesAndRelatedIndexesToUpdate);
        if (!issuesToUpdate.isEmpty()) {
            this.indexingService.reIndexIssueObjects((Collection)issuesToUpdate, IssueIndexingParams.builder().withChangeHistory().build(), false);
        }
        if (!issuesAndRelatedIndexesToUpdate.isEmpty()) {
            this.indexingService.reIndexIssueObjects((Collection)issuesAndRelatedIndexesToUpdate, IssueIndexingParams.INDEX_ALL, false);
        }
        if (!issuesToDelete.isEmpty()) {
            this.indexingService.deIndexIssueObjects((Set)issuesToDelete, false);
        }
        projectsToUpdate.forEach(this::reindexProject);
    }

    private void reindexProject(Project project) {
        try {
            if (this.projectReindexService.isReindexPossible(project)) {
                this.projectReindexService.reindex(project, false);
            }
        }
        catch (AlreadyExecutingException aee) {
            log.debug("Lost race detecting that project reindex for '" + project.getKey() + "' is already in progress", (Throwable)aee);
        }
    }

    private Map<AffectedIndex, Set<ReplicatedIndexOperation>> partition(Set<ReplicatedIndexOperation> indexOps) {
        HashMap partitionedOperations = Maps.newHashMap();
        for (AffectedIndex affectedIndex : AffectedIndex.values()) {
            partitionedOperations.put(affectedIndex, Sets.newHashSet());
        }
        for (ReplicatedIndexOperation operation : indexOps) {
            ((Set)partitionedOperations.get(operation.getAffectedIndex())).add(operation);
        }
        return partitionedOperations;
    }

    private Map<String, Long> getHighestNodeCounts(Iterable<ReplicatedIndexOperation> indexOperations) {
        HashMap<String, Long> highestOperationIds = new HashMap<String, Long>();
        for (ReplicatedIndexOperation indexOperation : indexOperations) {
            String nodeId = indexOperation.getNodeId();
            Long currentHigh = (Long)highestOperationIds.get(nodeId);
            if (currentHigh != null && currentHigh >= indexOperation.getId()) continue;
            highestOperationIds.put(nodeId, indexOperation.getId());
        }
        return highestOperationIds;
    }

    private static class LatestGaugeValue
    implements ExternalValue {
        private long value = 0L;

        private LatestGaugeValue() {
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }
}

