/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.help.HelpUrlsLoader;
import com.atlassian.jira.i18n.ResourceBundleCacheCleaner;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachingHelpUrls
implements HelpUrls {
    private static final Logger LOG = LoggerFactory.getLogger(CachingHelpUrls.class);
    private final HelpUrlsLoader loader;
    private final AtomicBoolean jiraStarted = new AtomicBoolean(false);
    @ClusterSafe
    private final LoadingCache<HelpUrlsLoader.HelpUrlsLoaderKey, HelpUrls> cache;

    public CachingHelpUrls(final HelpUrlsLoader loader, final ResourceBundleCacheCleaner resourceBundleCacheCleaner) {
        this.loader = loader;
        HelpUrlsLoader wrappedLoader = new HelpUrlsLoader(){

            @Override
            @Nonnull
            public HelpUrlsLoader.HelpUrlsLoaderKey keyForCurrentUser() {
                return loader.keyForCurrentUser();
            }

            @Override
            @Nonnull
            public HelpUrlsLoader.HelpUrlsLoaderKey keyForApplication(@Nonnull ApplicationKey applicationKey) {
                return loader.keyForApplication(applicationKey);
            }

            @Override
            public HelpUrls apply(HelpUrlsLoader.HelpUrlsLoaderKey key) {
                HelpUrls helpUrls = loader.apply(key);
                if (CachingHelpUrls.this.jiraStarted.get()) {
                    resourceBundleCacheCleaner.cleanPluginBundlesFromResourceBundleCache();
                }
                return helpUrls;
            }
        };
        this.cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)wrappedLoader));
    }

    @Nonnull
    public HelpUrl getUrl(@Nonnull String key) {
        return this.getUrls().getUrl(key);
    }

    @Nonnull
    public HelpUrl getDefaultUrl() {
        return this.getUrls().getDefaultUrl();
    }

    public Iterator<HelpUrl> iterator() {
        return this.getUrls().iterator();
    }

    @Nonnull
    public Set<String> getUrlKeys() {
        return this.getUrls().getUrlKeys();
    }

    @Nonnull
    public HelpUrl getUrlForApplication(@Nonnull ApplicationKey applicationKey, @Nonnull String key) {
        return this.getUrlsForApplication(applicationKey).getUrl(key);
    }

    private HelpUrls getUrlsForApplication(@Nonnull ApplicationKey applicationKey) {
        return (HelpUrls)this.cache.getUnchecked((Object)this.loader.keyForApplication(applicationKey));
    }

    private HelpUrls getUrls() {
        return (HelpUrls)this.cache.getUnchecked((Object)this.loader.keyForCurrentUser());
    }

    @EventListener
    public void clearCache(ClearCacheEvent cacheEvent) {
        this.cache.invalidateAll();
        LOG.debug("Clearing HelpUrls on ClearCacheEvent.");
    }

    @EventListener
    public void pluginEnabled(PluginEnabledEvent event) {
        this.cache.invalidateAll();
        LOG.debug("Clearing HelpUrls cached as plugin '{}' enabled.", (Object)event.getPlugin().getKey());
    }

    @EventListener
    public void pluginDisabled(PluginDisabledEvent event) {
        this.cache.invalidateAll();
        LOG.debug("Clearing HelpUrls cached as plugin '{}' disabled.", (Object)event.getPlugin().getKey());
    }

    @EventListener
    public void pluginModuleDisabled(PluginModuleDisabledEvent event) {
        this.cache.invalidateAll();
        LOG.debug("Clearing HelpUrls cached as module '{}' disabled.", (Object)event.getModule().getCompleteKey());
    }

    @EventListener
    public void pluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.cache.invalidateAll();
        LOG.debug("Clearing HelpUrls cached as module '{}' enabled.", (Object)event.getModule().getCompleteKey());
    }

    @EventListener
    public void pluginRefreshed(PluginRefreshedEvent event) {
        this.cache.invalidateAll();
        LOG.debug("Clearing HelpUrls cached as plugin '{}' refreshed.", (Object)event.getPlugin().getKey());
    }

    @EventListener
    public void licenseChanged(LicenseChangedEvent event) {
        this.cache.invalidateAll();
        LOG.debug("Clearing HelpUrls cached as license '{}' changed.", (Object)event);
    }

    @EventListener
    public void jiraStarted(JiraStartedEvent event) {
        this.jiraStarted.set(true);
        this.cache.invalidateAll();
        LOG.debug("Clearing HelpUrls on JIRA start.");
    }
}

