/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.mail;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.event.issue.DelegatingJiraIssueEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.JiraIssueEvent;
import com.atlassian.jira.event.listeners.mail.IssueEventBundleMailHandler;
import com.atlassian.jira.event.listeners.mail.MailListener;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.mail.queue.MailQueue;

public class DebugMailListener
extends MailListener {
    public DebugMailListener(UserManager userManager, IssueEventBundleMailHandler issueEventBundleMailHandler, MailQueue mailQueueUserManager, IssueEventBundleFactory issueEventBundleFactory) {
        super(userManager, issueEventBundleMailHandler, mailQueueUserManager, issueEventBundleFactory);
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    protected void sendUserMail(UserEvent event, String subject, String subjectKey, String template) {
        this.logEvent((JiraEvent)event);
        this.log("Subject: " + subject);
        this.log("Subject Key: " + subjectKey);
        this.log("Template: " + template);
    }

    @Override
    @EventListener
    public void handleIssueEventBundle(IssueEventBundle bundle) {
        this.log("Issue Event Bundle received:");
        for (JiraIssueEvent event : bundle.getEvents()) {
            if (!(event instanceof DelegatingJiraIssueEvent)) continue;
            this.logEvent((JiraEvent)((DelegatingJiraIssueEvent)event).asIssueEvent());
        }
    }

    @Override
    protected void handleDefaultIssueEvent(IssueEvent event) {
        this.logEvent((JiraEvent)event);
    }

    private void logEvent(JiraEvent event) {
        try {
            if (event instanceof IssueEvent) {
                IssueEvent issueEvent = (IssueEvent)event;
                this.log("Issue: [#" + issueEvent.getIssue().getId() + "] " + issueEvent.getIssue().getSummary());
                this.log("Comment: " + issueEvent.getComment());
                this.log("Change Group: " + issueEvent.getChangeLog());
                this.log("EventTypeId: " + issueEvent.getEventTypeId());
            } else if (event instanceof UserEvent) {
                UserEvent userEvent = (UserEvent)event;
                this.log("User: " + userEvent.getUser().getName() + " (" + userEvent.getUser().getEmailAddress() + ")");
            }
            this.log(" Time: " + event.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void log(String msg) {
        System.err.println("[DebugMailListener]: " + msg);
    }
}

