/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.jira.event.issue.ChangeItemBeanKit;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class IssueChangedEventImpl
implements IssueChangedEvent {
    private final Collection<ChangeItemBean> changeItems;
    private final Optional<ApplicationUser> author;
    private final Optional<Comment> comment;
    private final Issue issue;
    private final Date eventTime;

    public IssueChangedEventImpl(@Nonnull Issue issue, @Nonnull Optional<ApplicationUser> author, @Nonnull Collection<ChangeItemBean> changeItems, @Nonnull Optional<Comment> comment, Date eventTime) {
        this.changeItems = changeItems;
        this.author = author;
        this.comment = comment;
        this.issue = issue;
        this.eventTime = eventTime;
    }

    @Nonnull
    public Collection<ChangeItemBean> getChangeItems() {
        return this.changeItems;
    }

    @Nonnull
    public Optional<ChangeItemBean> getChangeItemForField(@Nonnull String fieldName) {
        return ChangeItemBeanKit.getFieldChange(fieldName, this.changeItems);
    }

    @Nonnull
    public Optional<ApplicationUser> getAuthor() {
        return this.author;
    }

    @Nonnull
    public Optional<Comment> getComment() {
        return this.comment;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public Date getTime() {
        return this.eventTime;
    }

    public Map<String, Object> getParams() {
        return Collections.emptyMap();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("changeItems", this.changeItems).add("author", this.author).add("comment", this.comment).add("issue", (Object)this.issue).add("eventTime", (Object)this.eventTime).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueChangedEventImpl that = (IssueChangedEventImpl)o;
        return Objects.equal(this.changeItems, that.changeItems) && Objects.equal(this.author, that.author) && Objects.equal(this.comment, that.comment) && Objects.equal((Object)this.issue, (Object)that.issue) && Objects.equal((Object)this.eventTime, (Object)that.eventTime);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.changeItems, this.author, this.comment, this.issue, this.eventTime});
    }
}

