/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard.analytics;

import com.atlassian.analytics.api.annotations.EventName;

@EventName(value="jira.dashboard.gadget.hidden")
public class GadgetHiddenEvent {
    private final String gadgetName;
    private final String conditionClass;
    private final Reason reason;
    private final boolean isAnonymousUser;

    public GadgetHiddenEvent(String gadgetName, String conditionClass, Reason reason, boolean isAnonymousUser) {
        this.gadgetName = gadgetName;
        this.conditionClass = conditionClass;
        this.reason = reason;
        this.isAnonymousUser = isAnonymousUser;
    }

    public String getGadgetName() {
        return this.gadgetName;
    }

    public String getConditionClass() {
        return this.conditionClass;
    }

    public String getReason() {
        return this.reason.name();
    }

    public String getIsAnonymousUser() {
        return Boolean.toString(this.isAnonymousUser);
    }

    public static enum Reason {
        ENABLED_CONDITION_FAILED,
        LOCAL_CONDITION_FAILED,
        PERMISSIONS_FAILED;

    }
}

