/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz.db;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizTransaction;
import com.google.common.annotations.VisibleForTesting;
import java.util.function.Consumer;
import java.util.function.Function;
import org.ofbiz.core.entity.GenericTransactionException;

public class DefaultOfBizTransaction
implements OfBizTransaction {
    private final boolean inTransaction;
    private final OfBizTransactionUtil transactionUtil;
    private Status status = Status.UNPROCESSED;

    @VisibleForTesting
    DefaultOfBizTransaction(boolean inTransaction, OfBizTransactionUtil transactionUtil) {
        this.inTransaction = inTransaction;
        this.transactionUtil = transactionUtil;
    }

    @VisibleForTesting
    static <R> R withTransaction(OfBizTransactionUtil transactionUtil, Function<? super DefaultOfBizTransaction, R> transactionUsingFunction) {
        boolean inTransaction;
        try {
            inTransaction = transactionUtil.begin();
        }
        catch (GenericTransactionException e) {
            throw new OfBizTransaction.TransactionException("Error starting transaction: " + e.getMessage(), e);
        }
        DefaultOfBizTransaction transaction = new DefaultOfBizTransaction(inTransaction, transactionUtil);
        try {
            R result = transactionUsingFunction.apply(transaction);
            transaction.finish();
            return result;
        }
        catch (Throwable t) {
            try {
                transaction.rollback();
            }
            catch (Throwable rbt) {
                t.addSuppressed(rbt);
            }
            throw t;
        }
    }

    static <R> R withTransaction(Function<? super DefaultOfBizTransaction, R> transactionUsingFunction) {
        return DefaultOfBizTransaction.withTransaction(new OfBizTransactionUtil(), transactionUsingFunction);
    }

    static void withTransaction(Consumer<? super DefaultOfBizTransaction> transactionUsingFunction) {
        DefaultOfBizTransaction.withTransaction((? super DefaultOfBizTransaction t) -> {
            transactionUsingFunction.accept((DefaultOfBizTransaction)t);
            return null;
        });
    }

    @VisibleForTesting
    Status getStatus() {
        return this.status;
    }

    @Override
    public boolean isProcessed() {
        return this.status != Status.UNPROCESSED;
    }

    @Override
    public void commit() {
        try {
            this.transactionUtil.commit(this.inTransaction);
            this.status = Status.COMMITTED;
        }
        catch (GenericTransactionException e) {
            throw new OfBizTransaction.TransactionException("Error committing transaction: " + e.getMessage(), e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.transactionUtil.rollback(this.inTransaction);
            this.status = Status.ROLLED_BACK;
        }
        catch (GenericTransactionException e) {
            throw new OfBizTransaction.TransactionException("Error rolling back transaction: " + e.getMessage(), e);
        }
    }

    private void finish() {
        if (!this.isProcessed()) {
            this.commit();
        }
    }

    @VisibleForTesting
    static class OfBizTransactionUtil {
        OfBizTransactionUtil() {
        }

        public boolean begin() throws GenericTransactionException {
            return CoreTransactionUtil.begin();
        }

        public void rollback(boolean began) throws GenericTransactionException {
            CoreTransactionUtil.rollback(began);
        }

        public void commit(boolean began) throws GenericTransactionException {
            CoreTransactionUtil.commit(began);
        }
    }

    @VisibleForTesting
    static enum Status {
        UNPROCESSED,
        COMMITTED,
        ROLLED_BACK;

    }
}

