/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.user.search.UserId;
import com.atlassian.jira.bc.user.search.UserIndexer;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.crowd.embedded.EventuallyConsistentQuery;
import com.atlassian.jira.crowd.embedded.lucene.CrowdQueryTranslator;
import com.atlassian.jira.crowd.embedded.ofbiz.DelegatingUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizTransactionManager;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class IndexedUserDao
extends DelegatingUserDao {
    private static final Logger LOG = LoggerFactory.getLogger(IndexedUserDao.class);
    private static final String USER_INDEX_CHANNEL = "jira.UserIndex";
    private final ExtendedUserDao dao;
    private final UserIndexer indexer;
    private final CrowdQueryTranslator translator;
    private final ClusterMessagingService clusterMessagingService;
    private final OfBizTransactionManager ofBizTransactionManager;
    private final int maxBatchSize;
    private final InvalidationClusterMessageConsumer invalidationClusterMessageConsumer = new InvalidationClusterMessageConsumer();
    private final Object indexLock = new Object();

    public IndexedUserDao(ExtendedUserDao dao, UserIndexer indexer, CrowdQueryTranslator translator, ClusterMessagingService clusterMessagingService, OfBizTransactionManager ofBizTransactionManager, int maxBatchSize) {
        this.dao = dao;
        this.indexer = indexer;
        this.translator = translator;
        this.clusterMessagingService = clusterMessagingService;
        this.ofBizTransactionManager = ofBizTransactionManager;
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    protected final ExtendedUserDao delegate() {
        return this.dao;
    }

    @VisibleForTesting
    static <T> BatchResult<T> combineBatchResults(Collection<BatchResult<T>> individualResults) {
        int totalCount = individualResults.stream().mapToInt(BatchResult::getTotalAttempted).sum();
        BatchResult combinedResult = new BatchResult(totalCount);
        for (BatchResult<T> individualResult : individualResults) {
            combinedResult.addSuccesses((Collection)individualResult.getSuccessfulEntities());
            combinedResult.addFailures((Collection)individualResult.getFailedEntities());
        }
        return combinedResult;
    }

    @VisibleForTesting
    static <T> List<? extends Set<T>> partitionSet(Set<T> original, int size) {
        List partitionList = Lists.partition(new ArrayList<T>(original), (int)size);
        return partitionList.stream().map(LinkedHashSet::new).collect(Collectors.toList());
    }

    @Override
    public com.atlassian.crowd.model.user.User add(com.atlassian.crowd.model.user.User user, PasswordCredential credential) throws UserAlreadyExistsException, IllegalArgumentException, DirectoryNotFoundException {
        Object object = this.indexLock;
        synchronized (object) {
            try {
                com.atlassian.crowd.model.user.User addedUser = super.add(user, credential);
                OfBizUser addedOfBizUser = this.toOfBizUser((User)addedUser);
                this.indexer.index(addedOfBizUser);
                this.invalidateUsersOnOtherNodes(addedOfBizUser);
                return addedUser;
            }
            catch (Throwable t) {
                this.reindexFromScratch(user);
                throw t;
            }
        }
    }

    @Override
    public BatchResult<com.atlassian.crowd.model.user.User> addAll(Set<UserTemplateWithCredentialAndAttributes> users) {
        if (users.size() > this.maxBatchSize) {
            ArrayList results = new ArrayList();
            for (Set<UserTemplateWithCredentialAndAttributes> partition : IndexedUserDao.partitionSet(users, this.maxBatchSize)) {
                BatchResult<com.atlassian.crowd.model.user.User> curResult = this.addAll(partition);
                results.add(curResult);
            }
            return IndexedUserDao.combineBatchResults(results);
        }
        Object object = this.indexLock;
        synchronized (object) {
            try {
                BatchResult<com.atlassian.crowd.model.user.User> addResult = super.addAll(users);
                Collection addedUsers = addResult.getSuccessfulEntities().stream().map(this::toOfBizUser).collect(Collectors.toList());
                this.indexer.index(addedUsers.toArray(new OfBizUser[addedUsers.size()]));
                Set<Long> userIds = addedUsers.stream().map(OfBizUser::getId).collect(Collectors.toSet());
                this.invalidateUsersOnOtherNodes(userIds);
                return addResult;
            }
            catch (Throwable t) {
                for (UserTemplateWithCredentialAndAttributes user : users) {
                    this.reindexFromScratch((com.atlassian.crowd.model.user.User)user);
                }
                throw t;
            }
        }
    }

    private void invalidateUsersOnOtherNodes(OfBizUser ... users) {
        this.invalidateUsersOnOtherNodes((Long[])Stream.of(users).filter(Objects::nonNull).map(OfBizUser::getId).toArray(Long[]::new));
    }

    private void invalidateUsersOnOtherNodes(Long ... internalIds) {
        this.invalidateUsersOnOtherNodes(new LinkedHashSet<Long>(Arrays.asList(internalIds)));
    }

    private void invalidateUserOnOtherNodes(OfBizUser user) {
        this.invalidateUserOnOtherNodes(user.getId());
    }

    private void invalidateUserOnOtherNodes(Long internalId) {
        this.invalidateUsersOnOtherNodes(internalId);
    }

    private void invalidateUsersOnOtherNodes(Collection<Long> internalIds) {
        if (internalIds.size() > 10) {
            for (Set<Long> curPartition : IndexedUserDao.partitionSet(new HashSet<Long>(internalIds), 10)) {
                this.invalidateUsersOnOtherNodes(curPartition);
            }
            return;
        }
        StringJoiner joiner = new StringJoiner(" ");
        for (Long internalId : internalIds) {
            joiner.add(String.valueOf(internalId));
        }
        this.clusterMessagingService.sendRemote(USER_INDEX_CHANNEL, joiner.toString());
    }

    private void reindexFromScratch(com.atlassian.crowd.model.user.User user) {
        this.reindexFromScratch(user, user.getName());
    }

    private void reindexFromScratch(com.atlassian.crowd.model.user.User user, String actualName) {
        this.reindexFromScratch(user.getDirectoryId(), actualName);
    }

    private void reindexFromScratch(long directoryId, String name) {
        try {
            UserId id = new UserId(name, directoryId);
            this.indexer.deindex(id);
            OfBizUser dbUser = this.findByNameOrNull(directoryId, name);
            if (dbUser != null) {
                this.indexer.index(dbUser);
                this.invalidateUsersOnOtherNodes(dbUser);
            }
        }
        catch (Exception e) {
            LOG.error("Error reindexing user from scratch (" + directoryId + ", " + name + ").  User index may be inconsistent.", (Throwable)e);
        }
    }

    @Override
    public com.atlassian.crowd.model.user.User rename(com.atlassian.crowd.model.user.User user, String newName) throws UserNotFoundException, UserAlreadyExistsException, IllegalArgumentException {
        Object object = this.indexLock;
        synchronized (object) {
            try {
                OfBizUser renamedUser = this.toOfBizUser((User)super.rename(user, newName));
                this.indexer.deindex(this.extractId(user));
                this.indexer.index(renamedUser);
                this.invalidateUsersOnOtherNodes(renamedUser);
                return renamedUser;
            }
            catch (Throwable t) {
                this.reindexFromScratch(user);
                this.reindexFromScratch(user, newName);
                throw t;
            }
        }
    }

    @Override
    public com.atlassian.crowd.model.user.User update(com.atlassian.crowd.model.user.User user) throws UserNotFoundException, IllegalArgumentException {
        Object object = this.indexLock;
        synchronized (object) {
            try {
                OfBizUser updatedUser = this.toOfBizUser((User)super.update(user));
                this.indexer.deindex(this.extractId(user));
                this.indexer.index(updatedUser);
                this.invalidateUserOnOtherNodes(updatedUser);
                return updatedUser;
            }
            catch (Throwable t) {
                this.reindexFromScratch(user);
                throw t;
            }
        }
    }

    private UserId extractId(com.atlassian.crowd.model.user.User user) {
        return new UserId(user.getName(), user.getDirectoryId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(com.atlassian.crowd.model.user.User user) throws UserNotFoundException {
        Object object = this.indexLock;
        synchronized (object) {
            try {
                OfBizUser ofBizUser = this.toOfBizUser((User)user);
                super.remove(user);
                this.indexer.deindex(this.extractId(user));
                OfBizUser afterDeleteUser = super.findById(ofBizUser.getId());
                if (afterDeleteUser != null) {
                    this.indexer.index(afterDeleteUser);
                }
                this.invalidateUsersOnOtherNodes(ofBizUser);
            }
            catch (Throwable t) {
                this.reindexFromScratch(user);
                throw t;
            }
        }
    }

    @Override
    public BatchResult<String> removeAllUsers(long directoryId, Set<String> userNames) {
        if (userNames.size() > this.maxBatchSize) {
            ArrayList results = new ArrayList();
            for (Set<String> partition : IndexedUserDao.partitionSet(userNames, this.maxBatchSize)) {
                BatchResult<String> curResult = this.removeAllUsers(directoryId, partition);
                results.add(curResult);
            }
            return IndexedUserDao.combineBatchResults(results);
        }
        Object object = this.indexLock;
        synchronized (object) {
            try {
                List usersToDelete = userNames.stream().map(userName -> this.toOfBizUser((User)this.findByNameOrNull(directoryId, (String)userName))).filter(user -> user != null).collect(Collectors.toList());
                BatchResult<String> removeResult = super.removeAllUsers(directoryId, userNames);
                List removedUserNames = removeResult.getSuccessfulEntities();
                UserId[] userIds = (UserId[])removedUserNames.stream().map(userName -> new UserId((String)userName, directoryId)).toArray(UserId[]::new);
                this.indexer.deindex(userIds);
                ArrayList<OfBizUser> usersExistingAfterDelete = new ArrayList<OfBizUser>();
                for (OfBizUser userToDelete : usersToDelete) {
                    OfBizUser afterDeleteUser = super.findById(userToDelete.getId());
                    if (afterDeleteUser == null) continue;
                    usersExistingAfterDelete.add(afterDeleteUser);
                }
                if (!usersExistingAfterDelete.isEmpty()) {
                    this.indexer.index(usersExistingAfterDelete.toArray(new OfBizUser[usersExistingAfterDelete.size()]));
                }
                this.invalidateUsersOnOtherNodes((OfBizUser[])usersToDelete.stream().filter(user -> removedUserNames.contains(user.getName())).toArray(OfBizUser[]::new));
                return removeResult;
            }
            catch (Throwable t) {
                for (String userName2 : userNames) {
                    this.reindexFromScratch(directoryId, userName2);
                }
                throw t;
            }
        }
    }

    @Override
    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        if (query instanceof EventuallyConsistentQuery) {
            return this.trySearching(directoryId, query).orElseGet(() -> super.search(directoryId, query));
        }
        return super.search(directoryId, query);
    }

    private <T> Optional<List<T>> trySearching(long directoryId, EntityQuery<T> query) {
        return this.translator.tryQuerying(directoryId, query).flatMap(usersInDirectory -> {
            Sort sort = new Sort(new SortField(UserIndexer.USER_NAME, 3));
            Supplier<List<User>> users = () -> this.indexer.search((Query)usersInDirectory, query.getStartIndex(), query.getMaxResults(), sort);
            return this.tryMapping(users, query.getReturnType());
        });
    }

    private <T> Optional<List<T>> tryMapping(Supplier<List<User>> users, Class<T> returnType) {
        if (returnType.isAssignableFrom(User.class)) {
            return Optional.of(this.cast(users.get(), returnType));
        }
        if (returnType.isAssignableFrom(String.class)) {
            List userNames = users.get().stream().map(Principal::getName).collect(Collectors.toList());
            return Optional.of(this.cast(userNames, returnType));
        }
        LOG.debug("Unsupported returnType=" + returnType);
        return Optional.empty();
    }

    private <S, T> List<T> cast(List<S> source, Class<T> target) {
        return source.stream().map(target::cast).collect(Collectors.toList());
    }

    @Override
    public void flushCache() {
        super.flushCache();
        this.reindex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindex() {
        Stopwatch timer = Stopwatch.createStarted();
        Object object = this.indexLock;
        synchronized (object) {
            this.ofBizTransactionManager.withTransaction(t -> this.indexer.replaceAllUsers(userSource -> super.processUsers((? super com.atlassian.crowd.model.user.User user) -> userSource.accept((OfBizUser)user))));
        }
        LOG.info("Reindex all users took: " + timer);
    }

    private OfBizUser toOfBizUser(User user) {
        if (user == null) {
            return null;
        }
        if (user instanceof OfBizUser) {
            return (OfBizUser)user;
        }
        return super.findByNameOrNull(user.getDirectoryId(), user.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexUser(long userId) {
        Object object = this.indexLock;
        synchronized (object) {
            this.indexer.deindexById(userId);
            OfBizUser user = this.findById(userId);
            if (user != null) {
                this.indexer.index(user);
            }
        }
    }

    @EventListener
    public void onApplicationStarted(JiraStartedEvent event) {
        this.clusterMessagingService.registerListener(USER_INDEX_CHANNEL, (ClusterMessageConsumer)this.invalidationClusterMessageConsumer);
        this.reindex();
    }

    private class InvalidationClusterMessageConsumer
    implements ClusterMessageConsumer {
        private InvalidationClusterMessageConsumer() {
        }

        public void receive(String channel, String message, String senderId) {
            LOG.debug("Received clustered user invalidation message: " + message);
            try {
                String[] internalUserIdStrings;
                for (String internalUserIdString : internalUserIdStrings = message.split("\\s")) {
                    long userId = Long.parseLong(internalUserIdString);
                    IndexedUserDao.this.reindexUser(userId);
                }
            }
            catch (NumberFormatException e) {
                LOG.error("Received an invalid cluster message to invalidate user: " + message, (Throwable)e);
            }
        }
    }
}

