/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.BackingPropertySetManager;
import com.atlassian.jira.config.properties.MemorySwitchToDatabasePropertySet;
import com.atlassian.jira.config.properties.PropertySetUtils;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.atlassian.util.concurrent.Supplier;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.module.propertyset.memory.MemoryPropertySet;
import java.util.Collections;

public class MemorySwitchToDatabaseBackedPropertiesManager
implements BackingPropertySetManager {
    @ClusterSafe
    private final ResettableLazyReference<MemorySwitchToDatabasePropertySet> propertySetRef = new ResettableLazyReference<MemorySwitchToDatabasePropertySet>(){

        protected MemorySwitchToDatabasePropertySet create() throws Exception {
            LazyReference<PropertySet> dbBacked = new LazyReference<PropertySet>(){

                protected PropertySet create() throws Exception {
                    return PropertySetUtils.createDatabaseBackedPropertySet();
                }
            };
            MemoryPropertySet mem = new MemoryPropertySet();
            mem.init(Collections.emptyMap(), Collections.emptyMap());
            return new MemorySwitchToDatabasePropertySet((PropertySet)mem, (Supplier<PropertySet>)dbBacked);
        }
    };

    private void switchToDbMode() {
        MemorySwitchToDatabasePropertySet switchablePropertySet = (MemorySwitchToDatabasePropertySet)this.propertySetRef.get();
        PropertySetManager.clone((PropertySet)switchablePropertySet.getMemoryPropertySet(), (PropertySet)switchablePropertySet.getDatabasePropertySet());
        switchablePropertySet.switchToDatabaseMode();
    }

    public void refresh() {
        this.propertySetRef.reset();
        ((MemorySwitchToDatabasePropertySet)this.propertySetRef.get()).switchToDatabaseMode();
    }

    public void switchBackingStore() {
        this.switchToDbMode();
    }

    public Supplier<? extends PropertySet> getPropertySetSupplier() {
        return this.propertySetRef;
    }
}

