/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.cache.CacheAdapter;
import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureDisabledEvent;
import com.atlassian.jira.config.FeatureEnabledEvent;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.FeatureStore;
import com.atlassian.jira.config.InstanceFeatureManager;
import com.atlassian.jira.config.feature.FeatureFlagProviderAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.tenancy.api.event.TenantArrivedEvent;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@TenantInfo(value=TenantAware.UNRESOLVED)
public class DefaultFeatureManager
implements FeatureManager,
InitializingComponent {
    private static final String DARK_FEATURE_ENABLE_FEATURE_MANAGER_VCACHE = "jira.jvc.DefaultFeatureManager.useRequestCaches";
    private final FeatureFlagProviderAccessor featureFlagProviderAccessor;
    private final JiraAuthenticationContext authenticationContext;
    private final FeatureStore featureStore;
    private final JiraProperties jiraSystemProperties;
    private final TenantAccessor tenantAccessor;
    @TenantInfo(value=TenantAware.TENANTED)
    private final SingleValueLocalCache<Set<String>> siteFeatures;
    @TenantInfo(value=TenantAware.TENANTED)
    private final CacheAdapter<String, ImmutableSet<String>> userFeaturesCache;
    @TenantInfo(value=TenantAware.TENANTED)
    private final RequestCache<Boolean, DarkFeatures> darkFeatures;
    private final ComponentReference<EventPublisher> eventPublisherRef = ComponentAccessor.getComponentReference(EventPublisher.class);
    private final ComponentReference<GlobalPermissionManager> permissionManagerRef = ComponentAccessor.getComponentReference(GlobalPermissionManager.class);
    private final InstanceFeatureManager instanceFeatureManager;

    public DefaultFeatureManager(JiraAuthenticationContext authenticationContext, FeatureStore featureStore, JiraProperties jiraSystemProperties, TenantAccessor tenantAccessor, FeatureFlagProviderAccessor featureFlagProviderAccessor, SwitchingCacheFactory switchingCacheFactory, VCacheFactory vCacheFactory, InstanceFeatureManager instanceFeatureManager) {
        this.jiraSystemProperties = jiraSystemProperties;
        this.authenticationContext = authenticationContext;
        this.featureStore = featureStore;
        this.featureFlagProviderAccessor = featureFlagProviderAccessor;
        this.instanceFeatureManager = instanceFeatureManager;
        this.userFeaturesCache = this.initUserFeatureCache(switchingCacheFactory);
        this.siteFeatures = this.initSiteFeatureCache(switchingCacheFactory);
        this.tenantAccessor = tenantAccessor;
        this.darkFeatures = vCacheFactory.getRequestCache(DefaultFeatureManager.class.getName() + ".darkFeatures");
    }

    @Override
    public void afterInstantiation() throws Exception {
        EventPublisher eventPublisher = (EventPublisher)this.eventPublisherRef.get();
        eventPublisher.register((Object)this);
    }

    private CacheAdapter<String, ImmutableSet<String>> initUserFeatureCache(SwitchingCacheFactory cacheFactory) {
        return cacheFactory.buildSwitchingRequestCache(DefaultFeatureManager.class.getName() + ".userFeaturesCache", Optional.empty(), DARK_FEATURE_ENABLE_FEATURE_MANAGER_VCACHE);
    }

    private SingleValueLocalCache<Set<String>> initSiteFeatureCache(SwitchingCacheFactory cacheFactory) {
        return cacheFactory.buildSwitchingRequestCache(DefaultFeatureManager.class.getName() + ".siteFeatures", new SiteFeaturesSupplier(), DARK_FEATURE_ENABLE_FEATURE_MANAGER_VCACHE);
    }

    private boolean isEnabled(@Nonnull String featureKey, boolean isUserSettable) {
        return this.instanceFeatureManager.isInstanceFeatureEnabled(featureKey) || this.getDarkFeatures(isUserSettable).isFeatureEnabled(featureKey);
    }

    public boolean isEnabled(FeatureFlag featureFlag) {
        if (featureFlag.isOnByDefault()) {
            return !this.isEnabled(featureFlag.disabledFeatureKey(), true);
        }
        return this.isEnabled(featureFlag.enabledFeatureKey(), true);
    }

    public boolean isEnabled(String featureKey) {
        Option<FeatureFlag> featureFlagOption = this.featureFlagProviderAccessor.findFeatureFlag(featureKey);
        if (featureFlagOption.isDefined()) {
            return this.isEnabled((FeatureFlag)featureFlagOption.get());
        }
        return this.isEnabled(featureKey, true);
    }

    public Option<FeatureFlag> getFeatureFlag(String featureKey) {
        return this.featureFlagProviderAccessor.findFeatureFlag(featureKey);
    }

    public boolean isEnabled(Feature feature) {
        if (feature instanceof CoreFeatures) {
            return this.isEnabled((CoreFeatures)feature);
        }
        return this.isEnabled(feature.featureKey(), true);
    }

    public boolean isEnabledForUser(@Nullable ApplicationUser user, String featureKey) {
        return this.getDarkFeaturesForUser(user).isFeatureEnabled(featureKey);
    }

    public boolean isEnabled(CoreFeatures feature) {
        return this.isEnabled(feature.featureKey(), feature.isDevFeature());
    }

    public Set<FeatureFlag> getRegisteredFlags() {
        return Sets.newHashSet(this.featureFlagProviderAccessor.getFeatureFlags().values());
    }

    public Set<String> getEnabledFeatureKeys() {
        return this.instanceFeatureManager.getEnabledFeatureKeys();
    }

    public DarkFeatures getDarkFeatures() {
        return this.getDarkFeatures(true);
    }

    private DarkFeatures getDarkFeatures(boolean includeUserSettable) {
        boolean cacheKey = includeUserSettable && this.authenticationContext.isLoggedInUser();
        return (DarkFeatures)this.darkFeatures.get((Object)cacheKey, () -> this.fetchDarkFeatures(cacheKey));
    }

    private DarkFeatures fetchDarkFeatures(boolean includeUserSettable) {
        if (this.jiraSystemProperties.isDarkFeaturesDisabled()) {
            return new DarkFeatures(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        if (includeUserSettable) {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            return new DarkFeatures(this.getEnabledFeatureKeys(), this.getSiteEnabledFeatures(), this.getUserEnabledFeatures(user));
        }
        return new DarkFeatures(this.getEnabledFeatureKeys(), this.getSiteEnabledFeatures(), Collections.emptySet());
    }

    public DarkFeatures getDarkFeaturesForUser(@Nullable ApplicationUser user) {
        if (this.jiraSystemProperties.isDarkFeaturesDisabled()) {
            return new DarkFeatures(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        return new DarkFeatures(this.getEnabledFeatureKeys(), this.getSiteEnabledFeatures(), this.getUserEnabledFeatures(user));
    }

    public void enableUserDarkFeature(ApplicationUser user, String feature) {
        this.changeUserDarkFeature(user, feature, true);
    }

    public void disableUserDarkFeature(ApplicationUser user, String feature) {
        this.changeUserDarkFeature(user, feature, false);
    }

    public void enableSiteDarkFeature(String feature) {
        this.changeSiteDarkFeature(feature, true);
    }

    public void disableSiteDarkFeature(String feature) {
        this.changeSiteDarkFeature(feature, false);
    }

    public boolean hasSiteEditPermission() {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        return ((GlobalPermissionManager)this.permissionManagerRef.get()).hasPermission(GlobalPermissionKey.ADMINISTER, loggedInUser);
    }

    private void changeUserDarkFeature(ApplicationUser user, String feature, boolean enable) {
        CoreFeatures coreFeature = CoreFeatures.forFeatureKey((String)feature);
        if (coreFeature != null && !coreFeature.isDevFeature()) {
            throw new IllegalStateException("User cannot set feature '" + feature + "' at runtime. It must be set by an admin via properties.");
        }
        ImmutableSet<String> enabledFeatures = this.getUserEnabledFeatures(user);
        if (enable == enabledFeatures.contains(feature)) {
            return;
        }
        if (enable) {
            this.featureStore.create(feature, user.getKey());
        } else {
            this.featureStore.delete(feature, user.getKey());
        }
        this.darkFeatures.removeAll();
        this.userFeaturesCache.remove(user.getKey());
        ((EventPublisher)this.eventPublisherRef.get()).publish(enable ? new FeatureEnabledEvent(feature, user) : new FeatureDisabledEvent(feature, user));
    }

    private void changeSiteDarkFeature(String feature, boolean enable) {
        if (!this.hasSiteEditPermission()) {
            throw new IllegalStateException("User " + this.authenticationContext.getLoggedInUser() + " does not have permission to change site dark features");
        }
        Set<String> enabledFeatures = this.getSiteEnabledFeatures();
        if (enable == enabledFeatures.contains(feature)) {
            return;
        }
        if (enable) {
            this.featureStore.create(feature, null);
            enabledFeatures.add(feature);
        } else {
            this.featureStore.delete(feature, null);
            enabledFeatures.remove(feature);
        }
        this.siteFeatures.reset();
        this.darkFeatures.removeAll();
        ((EventPublisher)this.eventPublisherRef.get()).publish(enable ? new FeatureEnabledEvent(feature) : new FeatureDisabledEvent(feature));
    }

    private ImmutableSet<String> getUserEnabledFeatures(ApplicationUser user) {
        if (user != null) {
            return (ImmutableSet)this.userFeaturesCache.get(user.getKey(), this.userFeatureCacheSupplier(user.getKey()));
        }
        return ImmutableSet.of();
    }

    private Set<String> getUserEnabledFeaturesFromStore(String userKey) {
        return this.featureStore.getUserFeatures(userKey);
    }

    private Set<String> getSiteEnabledFeatures() {
        return this.siteFeatures.get();
    }

    private Set<String> getSiteEnabledFeaturesFromStore() {
        return this.featureStore.getSiteFeatures();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.invalidateCaches();
    }

    @EventListener
    public void onTenantArrived(TenantArrivedEvent event) {
        this.invalidateCaches();
    }

    private void invalidateCaches() {
        this.userFeaturesCache.removeAll();
        this.darkFeatures.removeAll();
        this.siteFeatures.reset();
    }

    private Supplier<ImmutableSet<String>> userFeatureCacheSupplier(String userKey) {
        return () -> this.isTenanted() ? ImmutableSet.copyOf(this.getUserEnabledFeaturesFromStore(userKey)) : ImmutableSet.of();
    }

    private boolean isTenanted() {
        return !Iterables.isEmpty((Iterable)this.tenantAccessor.getAvailableTenants());
    }

    private class SiteFeaturesSupplier
    implements Supplier<Set<String>> {
        private SiteFeaturesSupplier() {
        }

        @Override
        public Set<String> get() {
            if (DefaultFeatureManager.this.isTenanted()) {
                return DefaultFeatureManager.this.getSiteEnabledFeaturesFromStore();
            }
            return ImmutableSet.of();
        }
    }
}

