/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationLoader;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.database.JndiDatasource;
import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.startup.EmbeddedDatabaseServerLauncher;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.LazyReference;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConfigurationManagerImpl
implements DatabaseConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConfigurationManagerImpl.class);
    private static final int DEFAULT_POOL_SIZE = 20;
    private static final long DEFAULT_POOL_MAX_WAIT = 30000L;
    private static final String ACTIVATED = "post-database-activated";
    private static final String CONFIGURED_PRE_ACTIVATED = "post-database-configured-but-pre-database-activated";
    @ClusterSafe(value="The database configuration is in the local home directory")
    private final Lock setupLock = new ReentrantLock();
    private final Queue<Runnable> postDbSetupQueue = new LinkedBlockingQueue<Runnable>();
    private final Queue<Runnable> postDbConfiguredQueue = new LinkedBlockingQueue<Runnable>();
    private final AtomicReference<DatabaseConfig> configCache = new AtomicReference();
    private final AtomicBoolean possiblySetup = new AtomicBoolean(true);
    private final AtomicBoolean definitelySetup = new AtomicBoolean(false);
    private final DatabaseConfigurationLoader databaseConfigLoader;
    private final ComponentLocator componentLocator;
    @ClusterSafe
    private final LazyReference<DatabaseConfig> internalConfig;
    private volatile boolean ofBizConfigured = false;
    private static final String DATASOURCE_NAME = "defaultDS";
    private static final String DELEGATOR_NAME = "default";

    public DatabaseConfigurationManagerImpl(final JiraHome jiraHome, DatabaseConfigurationLoader databaseConfigLoader, ComponentLocator componentLocator) {
        this.databaseConfigLoader = databaseConfigLoader;
        this.componentLocator = componentLocator;
        this.internalConfig = new LazyReference<DatabaseConfig>(){

            protected DatabaseConfig create() throws Exception {
                return DatabaseConfigurationManagerImpl.this.createInternalConfig(jiraHome);
            }
        };
    }

    private DatabaseConfig createInternalConfig(JiraHome jiraHome) {
        String jdbcUrl = EmbeddedDatabaseServerLauncher.isEnabled() ? "jdbc:h2:tcp://localhost:" + EmbeddedDatabaseServerLauncher.getPort() + "/" + jiraHome.getHomePath() + "/database/h2db" : "jdbc:h2:file:" + jiraHome.getHomePath() + "/database/h2db";
        String driver = "org.h2.Driver";
        ConnectionPoolInfo.Builder connectionPoolInfoBuilder = ConnectionPoolInfo.builder();
        connectionPoolInfoBuilder.setPoolMaxSize(Integer.valueOf(20)).setPoolMinSize(Integer.valueOf(20)).setPoolMaxWait(Long.valueOf(30000L)).setRemoveAbandonedOnBorrow(Boolean.valueOf(true)).setRemoveAbandonedTimeout(Integer.valueOf(300)).setMinEvictableTimeMillis(Long.valueOf(4000L)).setTimeBetweenEvictionRunsMillis(Long.valueOf(5000L));
        JdbcDatasource.Builder builder = JdbcDatasource.builder().setJdbcUrl(jdbcUrl).setDriverClassName("org.h2.Driver").setDatabaseType(DatabaseType.H2).setUsername("sa").setPassword("").setConnectionPoolInfo(connectionPoolInfoBuilder.build());
        JdbcDatasource datasource = builder.build();
        return new DatabaseConfig("h2", "PUBLIC", datasource);
    }

    @Override
    public void setDatabaseConfiguration(DatabaseConfig databaseConfig) {
        this.setupLock.lock();
        try {
            this.databaseConfigLoader.saveDatabaseConfiguration(databaseConfig);
            this.configCache.set(databaseConfig);
            this.possiblySetup.set(true);
        }
        finally {
            this.setupLock.unlock();
        }
    }

    @Override
    public void createDbConfigFromEntityDefinition() {
        if (!this.databaseConfigLoader.configExists()) {
            DatasourceInfo info = EntityConfigUtil.getInstance().getDatasourceInfo(DATASOURCE_NAME);
            if (info != null) {
                Datasource datasource = null;
                if (info.getJndiDatasource() != null) {
                    datasource = new JndiDatasource(info.getJndiDatasource());
                } else if (info.getJdbcDatasource() != null) {
                    datasource = new JdbcDatasource(info.getJdbcDatasource());
                } else {
                    log.warn("The datasource defined in entityengine.xml is not a valid JNDI or JDBC datasource.");
                }
                if (datasource != null) {
                    log.info("Migrating from entityengine.xml specification of datasource to new dbconfig.xml form");
                    DatabaseConfig config = new DatabaseConfig(DATASOURCE_NAME, DELEGATOR_NAME, info.getFieldTypeName(), info.getSchemaName(), datasource);
                    this.databaseConfigLoader.saveDatabaseConfiguration(config);
                    this.setDatabaseConfiguration(config);
                }
            } else {
                log.debug("no defaultDS datasource");
            }
        }
    }

    @Override
    public DatabaseConfig getDatabaseConfiguration() {
        this.setupLock.lock();
        try {
            DatabaseConfig dbConfig = this.configCache.get();
            if (dbConfig == null) {
                try {
                    dbConfig = this.databaseConfigLoader.loadDatabaseConfiguration();
                    this.configCache.set(dbConfig);
                }
                catch (RuntimeException e) {
                    this.possiblySetup.set(false);
                    throw e;
                }
            }
            this.definitelySetup.set(true);
            DatabaseConfig databaseConfig = dbConfig;
            return databaseConfig;
        }
        finally {
            this.setupLock.unlock();
        }
    }

    @Override
    public void doNowOrWhenDatabaseActivated(Runnable runnable, String desc) {
        this.doNowOrEnqueue(ACTIVATED, this.postDbSetupQueue, runnable, desc);
    }

    @Override
    public void doNowOrWhenDatabaseConfigured(Runnable runnable, String desc) {
        this.doNowOrEnqueue(CONFIGURED_PRE_ACTIVATED, this.postDbConfiguredQueue, runnable, desc);
    }

    void configureOfbiz(DatabaseConfig databaseConfig) {
        log.debug("Configuring Ofbiz");
        DatasourceInfo datasourceInfo = databaseConfig.getDatasourceInfo();
        EntityConfigUtil.getInstance().addDatasourceInfo(datasourceInfo);
        String delegatorName = databaseConfig.getDelegatorName();
        log.debug("delegator name is " + delegatorName);
        EntityConfigUtil.DelegatorInfo delegatorInfo = new EntityConfigUtil.DelegatorInfo(delegatorName, "main", "main", MapBuilder.singletonMap((Object)DELEGATOR_NAME, (Object)databaseConfig.getDatasourceName()));
        EntityConfigUtil.getInstance().addDelegatorInfo(delegatorInfo);
        log.debug("Unlocking GenericDelegator");
        GenericDelegator.unlock();
        CoreFactory.getGenericDelegator().initialiseAndCheckDatabase();
        this.ofBizConfigured = true;
    }

    @Override
    public boolean isDatabaseSetup() {
        this.setupLock.lock();
        try {
            if (!this.possiblySetup.get()) {
                boolean bl = false;
                return bl;
            }
            this.getDatabaseConfiguration();
            boolean bl = this.definitelySetup.get();
            return bl;
        }
        catch (RuntimeException e) {
            log.debug("database is not setup");
            boolean bl = false;
            return bl;
        }
        finally {
            this.setupLock.unlock();
        }
    }

    @Override
    public void activateDatabase() {
        this.activateDatabase(true);
    }

    @Override
    public void activateDatabaseWithoutRunningPostDbSetupRunnables() {
        this.activateDatabase(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateDatabase(boolean runPostDbSetupRunnables) {
        log.debug("activating database");
        this.setupLock.lock();
        try {
            DatabaseConfig databaseConfiguration = this.getDatabaseConfiguration();
            this.configureOfbiz(databaseConfiguration);
        }
        finally {
            this.setupLock.unlock();
        }
        for (Runnable runnable : this.postDbConfiguredQueue) {
            runnable.run();
        }
        this.setupLock.lock();
        try {
            PropertiesManager propertiesManager = (PropertiesManager)this.componentLocator.getComponent(PropertiesManager.class);
            propertiesManager.onDatabaseConfigured();
            this.definitelySetup.set(true);
        }
        finally {
            this.setupLock.unlock();
        }
        if (runPostDbSetupRunnables) {
            this.runPostDbSetupRunnables();
        }
    }

    @Override
    public void runPostDbSetupRunnables() {
        for (Runnable runnable : this.postDbSetupQueue) {
            runnable.run();
        }
    }

    @Override
    public DatabaseConfig getInternalDatabaseConfiguration() {
        return (DatabaseConfig)this.internalConfig.get();
    }

    void doNowOrEnqueue(String queueDesc, Queue<Runnable> queue, Runnable runnable, String desc) {
        Assertions.notNull((String)"runnable", (Object)runnable);
        Assertions.notBlank((String)"desc", (String)desc);
        if (this.isDatabaseSetup()) {
            if (!this.ofBizConfigured) {
                this.configureOfbiz(this.getDatabaseConfiguration());
            }
            log.info("The database is configured. Now running {}", (Object)desc);
            runnable.run();
        } else {
            log.info("The database is not yet configured. Enqueuing {} on {} queue", (Object)desc, (Object)queueDesc);
            queue.add(runnable);
        }
    }
}

