/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.component;

import com.atlassian.jira.config.component.InvocationSwitcher;
import com.google.common.base.MoreObjects;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SwitchingInvocationHandler<T>
implements InvocationHandler {
    private final T enabled;
    private final T disabled;
    private final InvocationSwitcher invocationSwitcher;

    protected SwitchingInvocationHandler(T enabled, T disabled, InvocationSwitcher invocationSwitcher) {
        this.enabled = enabled;
        this.disabled = disabled;
        this.invocationSwitcher = invocationSwitcher;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.getImplementingObject(), args);
        }
        catch (InvocationTargetException ite) {
            throw (Throwable)MoreObjects.firstNonNull((Object)ite.getCause(), (Object)ite);
        }
    }

    public T getImplementingObject() {
        return this.isEnabled() ? this.enabled : this.disabled;
    }

    protected boolean isEnabled() {
        return this.invocationSwitcher.isEnabled();
    }
}

