/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.component;

import com.atlassian.jira.config.component.AbstractComponentAdaptor;
import com.atlassian.jira.config.component.InvocationSwitcher;
import com.atlassian.jira.config.component.SwitchingInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;

public abstract class AbstractSwitchingInvocationAdaptor<T>
extends AbstractComponentAdaptor<T> {
    private final Class<? extends T> enabledClass;
    private final Class<? extends T> disabledClass;

    protected AbstractSwitchingInvocationAdaptor(Class<T> interfaceClass, Class<? extends T> enabledClass, Class<? extends T> disabledClass) {
        super(interfaceClass);
        this.enabledClass = enabledClass;
        this.disabledClass = disabledClass;
    }

    protected boolean isEnabled() {
        return this.getInvocationSwitcher().isEnabled();
    }

    public Class<? extends T> getComponentImplementation() {
        return this.interfaceClass;
    }

    protected InvocationHandler getHandler(PicoContainer container) {
        Object enabled = container.getComponent(this.enabledClass);
        Object disabled = container.getComponent(this.disabledClass);
        return new SwitchingInvocationHandler<Object>(enabled, disabled, this.getInvocationSwitcher());
    }

    public T getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.interfaceClass}, this.getHandler(container));
    }

    protected abstract InvocationSwitcher getInvocationSwitcher();
}

