/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.config.IndexTask;
import com.atlassian.jira.config.ReindexMessage;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskMatcher;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.flag.FlagDismissalService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.Serializable;
import java.util.Date;

@TenantInfo(value=TenantAware.UNRESOLVED, comment="Tenanted data, will be marked as such when converted to a vcache request cache.")
@EventComponent
public class DefaultReindexMessageManager
implements ReindexMessageManager {
    private static final String MESAGE_LOCK_NAME = DefaultReindexMessageManager.class.getName() + ".messageLock";
    protected static final String DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY = "jira.jvc.DefaultReindexMessageManager.caches.request";
    static final String PS_KEY = "admin.message.manager";
    static final String PS_KEY_USER = "user";
    static final String PS_KEY_TASK = "task";
    static final String PS_KEY_TIME = "time";
    static final String PS_KEY_RAW = "rawmsg";
    private final UserKeyService userKeyService;
    private final UserFormats userFormats;
    private final I18nHelper.BeanFactory i18nFactory;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    @TenantInfo(value=TenantAware.TENANTED)
    private final SingleValueLocalCache<PropertySet> propertiesReference;
    private final GlobalPermissionManager globalPermissionManager;
    private final TaskManager taskManager;
    private final FlagDismissalService flagDismissalService;
    private final HelpUrls helpUrls;
    private final ClusterLock messageLock;

    public DefaultReindexMessageManager(JiraPropertySetFactory jiraPropertySetFactory, UserKeyService userKeyService, UserFormats userFormats, I18nHelper.BeanFactory i18nFactory, VelocityRequestContextFactory velocityRequestContextFactory, GlobalPermissionManager globalPermissionManager, TaskManager taskManager, SwitchingCacheFactory cacheFactory, ClusterLockService clusterLockService, FlagDismissalService flagDismissalService, DateTimeFormatterFactory dateTimeFormatterFactory, HelpUrls helpUrls) {
        this.helpUrls = (HelpUrls)Assertions.notNull((String)"helpUrls", (Object)helpUrls);
        this.dateTimeFormatterFactory = (DateTimeFormatterFactory)Assertions.notNull((String)"dateTimeFormatterFactory", (Object)dateTimeFormatterFactory);
        this.flagDismissalService = (FlagDismissalService)Assertions.notNull((String)"flagDismissalService", (Object)flagDismissalService);
        this.globalPermissionManager = (GlobalPermissionManager)Assertions.notNull((String)"globalPermissionManager", (Object)globalPermissionManager);
        this.velocityRequestContextFactory = (VelocityRequestContextFactory)Assertions.notNull((String)"velocityRequestContextFactory", (Object)velocityRequestContextFactory);
        this.userKeyService = (UserKeyService)Assertions.notNull((String)"userKeyService", (Object)userKeyService);
        this.userFormats = (UserFormats)Assertions.notNull((String)"userFormats", (Object)userFormats);
        this.i18nFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18nFactory", (Object)i18nFactory);
        this.taskManager = (TaskManager)Assertions.notNull((String)"taskManager", (Object)taskManager);
        this.propertiesReference = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".propertiesReference", () -> jiraPropertySetFactory.buildCachingDefaultPropertySet(PS_KEY), DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
        this.messageLock = clusterLockService.getLockForName(MESAGE_LOCK_NAME);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.messageLock.lock();
        try {
            this.propertiesReference.reset();
        }
        finally {
            this.messageLock.unlock();
        }
    }

    public void pushMessage(ApplicationUser user, String i18nTask) {
        this.messageLock.lock();
        try {
            this.pushMessage(user);
            this.flagDismissalService.resetFlagDismissals("com.atlassian.jira.reindex.required");
            this.propertiesReference.get().setString(PS_KEY_TASK, i18nTask);
            this.propertiesReference.reset();
        }
        finally {
            this.messageLock.unlock();
        }
    }

    public void pushRawMessage(ApplicationUser user, String i18nMessage) {
        this.messageLock.lock();
        try {
            this.pushMessage(user);
            this.flagDismissalService.resetFlagDismissals("com.atlassian.jira.reindex.required");
            this.propertiesReference.get().setString(PS_KEY_RAW, i18nMessage);
            this.propertiesReference.reset();
        }
        finally {
            this.messageLock.unlock();
        }
    }

    private void pushMessage(ApplicationUser user) {
        String key = user != null ? user.getKey() : null;
        this.propertiesReference.get().setString(PS_KEY_USER, key == null ? "" : key);
        this.propertiesReference.get().setDate(PS_KEY_TIME, this.getCurrentDate());
        this.propertiesReference.reset();
    }

    public void clear() {
        this.messageLock.lock();
        try {
            PropertySet propertySet = this.propertiesReference.get();
            if (propertySet.exists(PS_KEY_USER)) {
                propertySet.remove(PS_KEY_TIME);
                if (propertySet.exists(PS_KEY_TASK)) {
                    propertySet.remove(PS_KEY_TASK);
                }
                propertySet.remove(PS_KEY_USER);
                if (propertySet.exists(PS_KEY_RAW)) {
                    propertySet.remove(PS_KEY_RAW);
                }
            }
            this.propertiesReference.reset();
        }
        finally {
            this.messageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(ApplicationUser user) {
        this.messageLock.lock();
        try {
            TaskDescriptor<Serializable> task = this.findActiveIndexTasks();
            PropertySet propertySet = this.propertiesReference.get();
            if (propertySet.exists(PS_KEY_USER) && this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
                String userKey = propertySet.getString(PS_KEY_USER);
                String i18nTaskKey = propertySet.getString(PS_KEY_TASK);
                Date time = propertySet.getDate(PS_KEY_TIME);
                String rawMessageKey = propertySet.getString(PS_KEY_RAW);
                if (rawMessageKey != null && rawMessageKey.length() > 0) {
                    String string = this.getRawIndexRequiredMessage(user, rawMessageKey);
                    return string;
                }
                if (task == null || task.isFinished()) {
                    String string = this.getReindexRequiredMessage(user, userKey, i18nTaskKey, time);
                    return string;
                }
                Date startedTimestamp = task.getStartedTimestamp();
                if (startedTimestamp != null && startedTimestamp.getTime() < time.getTime()) {
                    String string = this.getReindexRestartRequiredMessage(user, userKey, i18nTaskKey, time);
                    return string;
                }
            }
            if (task != null && task.isStarted() && !task.isFinished()) {
                I18nHelper i18n = this.i18nFactory.getInstance(user);
                String string = ((IndexTask)task.getTaskContext()).getTaskInProgressMessage(i18n);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.messageLock.unlock();
        }
    }

    private String getRawIndexRequiredMessage(ApplicationUser user, String rawMessageKey) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        String rawMessage = i18n.getText(rawMessageKey);
        StringBuilder message = new StringBuilder();
        message.append(rawMessage).append("&nbsp;").append(this.getHelpHtml());
        message.append("<p>").append(i18n.getText("admin.notifications.reindex.now", "<a href='" + this.getContextPath() + "/secure/admin/jira/IndexAdmin.jspa'>", "</a>"));
        return message.toString();
    }

    private String getReindexRequiredMessage(ApplicationUser user, String userKey, String i18nTaskKey, Date time) {
        return this.getMessage(user, userKey, i18nTaskKey, time, false);
    }

    private String getMessage(ApplicationUser user, String userKey, String i18nTaskKey, Date time, boolean restartRequired) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        String timeString = this.getTimeString(time, user);
        String userFullName = this.userFormats.formatter("fullName").formatUserkey(userKey, "fullName");
        String i18nTask = i18n.getText(i18nTaskKey);
        String reindexLink = "<a href='" + this.getContextPath() + "/secure/admin/jira/IndexAdmin.jspa'>";
        StringBuilder message = new StringBuilder();
        if (userFullName == null) {
            message.append(i18n.getText("admin.notifications.task.requires.reindex.nouser", (Object)new Object[]{i18nTask, timeString, reindexLink, "</a>"}));
        } else {
            message.append(i18n.getText("admin.notifications.task.requires.reindex", (Object)new Object[]{userFullName, i18nTask, timeString, reindexLink, "</a>"}));
        }
        if (restartRequired) {
            message.append("&nbsp;").append(i18n.getText("admin.notifications.task.requires.reindex.restart.required"));
        }
        message.append("&nbsp;").append(this.getHelpHtml());
        message.append("<p>").append(i18n.getText("admin.notifications.complete.all.changes"));
        return message.toString();
    }

    private String getHelpHtml() {
        StringBuilder helpIcon = new StringBuilder();
        HelpUrl helpUrl = this.helpUrls.getUrl("reindex_after_configuration_changes");
        helpIcon.append("<a class=\"help-lnk\" target=\"_jirahelp\" data-helplink=\"online\" title=\"").append(helpUrl.getTitle()).append("\" href=\"").append(helpUrl.getUrl()).append("\"><span class=\"aui-icon aui-icon-small aui-iconfont-help\">" + helpUrl.getAlt() + "</span></a>");
        return helpIcon.toString();
    }

    private String getTimeString(Date time, ApplicationUser user) {
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().forUser(user).withStyle(DateTimeStyle.COMPLETE);
        return dateTimeFormatter.format(time);
    }

    private String getReindexRestartRequiredMessage(ApplicationUser user, String userKey, String i18nTaskKey, Date time) {
        return this.getMessage(user, userKey, i18nTaskKey, time, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReindexMessage getMessageObject() {
        this.messageLock.lock();
        try {
            PropertySet propertySet = this.propertiesReference.get();
            if (propertySet.exists(PS_KEY_USER)) {
                String userKey = propertySet.getString(PS_KEY_USER);
                String i18nTaskKey = propertySet.getString(PS_KEY_TASK);
                Date time = propertySet.getDate(PS_KEY_TIME);
                String userName = this.userKeyService.getUsernameForKey(userKey);
                if (userName == null) {
                    userName = userKey;
                }
                ReindexMessage reindexMessage = new ReindexMessage(userName, time, i18nTaskKey);
                return reindexMessage;
            }
            ReindexMessage reindexMessage = null;
            return reindexMessage;
        }
        finally {
            this.messageLock.unlock();
        }
    }

    public void clearMessageForTimestamp(Date time) {
        Date messageTime;
        if (this.propertiesReference.get().exists(PS_KEY_TIME) && (messageTime = this.propertiesReference.get().getDate(PS_KEY_TIME)) != null && !time.before(messageTime)) {
            this.clear();
        }
    }

    String getContextPath() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    Date getCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    private TaskDescriptor<Serializable> findActiveIndexTasks() {
        return this.taskManager.findFirstTask(new TaskMatcher(){

            @Override
            public boolean match(TaskDescriptor<?> descriptor) {
                return !descriptor.isFinished() && descriptor.getTaskContext() instanceof IndexTask;
            }
        });
    }
}

