/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentAccessorWorker
implements ComponentAccessor.Worker {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentAccessorWorker.class);

    public <T> Optional<T> getComponentSafely(Class<T> componentClass) {
        if (ComponentManager.getInstance().getState().isContainerInitialised()) {
            return Optional.ofNullable(this.getComponent(componentClass));
        }
        return Optional.empty();
    }

    public <T> T getComponent(Class<T> componentClass) {
        try {
            return ComponentManager.getComponent(componentClass);
        }
        catch (RuntimeException re) {
            throw new IllegalStateException("Unable to resolve component: " + componentClass, re);
        }
    }

    public <T> T getComponentOfType(Class<T> componentClass) {
        try {
            return ComponentManager.getComponentInstanceOfType(componentClass);
        }
        catch (RuntimeException re) {
            throw new IllegalStateException("Unable to resolve component: " + componentClass, re);
        }
    }

    public <T> T getOSGiComponentInstanceOfType(Class<T> componentClass) {
        try {
            return ComponentManager.getOSGiComponentInstanceOfType(componentClass);
        }
        catch (RuntimeException re) {
            throw new IllegalStateException("Unable to resolve component: " + componentClass, re);
        }
    }
}

