/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.jira.cluster.lock.NodeSharedHomeStatus;
import com.atlassian.jira.cluster.lock.SharedHomeNodeStatusReader;
import com.atlassian.jira.cluster.lock.SharedHomeNodeStatusWriter;
import com.atlassian.jira.config.util.JiraHome;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSharedHomeNodeIO
implements SharedHomeNodeStatusReader,
SharedHomeNodeStatusWriter {
    private static final Logger log = LoggerFactory.getLogger(DefaultSharedHomeNodeIO.class);
    private final JiraHome jiraHome;

    public DefaultSharedHomeNodeIO(JiraHome jiraHome) {
        this.jiraHome = jiraHome;
    }

    @Nonnull
    protected File getNodeStatusDirectory() {
        return new File(this.jiraHome.getHome(), "node-status");
    }

    @Override
    @Nullable
    public NodeSharedHomeStatus readNodeStatus(@Nonnull String nodeId) {
        File nodeStatusFile = new File(this.getNodeStatusDirectory(), nodeId);
        if (!nodeStatusFile.exists()) {
            return null;
        }
        try {
            String content = Files.toString((File)nodeStatusFile, (Charset)Charsets.UTF_8);
            long contentTimestamp = Long.parseLong(content);
            return new NodeSharedHomeStatus(nodeId, contentTimestamp);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error reading node status file " + nodeStatusFile.getAbsolutePath() + ": " + e, e);
        }
    }

    @Override
    public void writeNodeStatus(@Nonnull NodeSharedHomeStatus status) {
        File nodeStatusDir = this.getNodeStatusDirectory();
        nodeStatusDir.mkdirs();
        String nodeId = status.getNodeId();
        File nodeStatusFile = new File(nodeStatusDir, nodeId);
        File nodeStatusFileTmp = new File(nodeStatusDir, nodeId + ".tmp");
        String content = String.valueOf(status.getUpdateTime());
        try {
            Files.write((CharSequence)content, (File)nodeStatusFileTmp, (Charset)Charsets.UTF_8);
            Files.move((File)nodeStatusFileTmp, (File)nodeStatusFile);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error writing node status file " + nodeStatusFile.getAbsolutePath() + ": " + e, e);
        }
    }

    @Override
    public void removeNodeStatus(@Nonnull String nodeId) {
        boolean deleted;
        File nodeStatusDir = this.getNodeStatusDirectory();
        File nodeStatusFile = new File(nodeStatusDir, nodeId);
        if (nodeStatusFile.exists() && !(deleted = nodeStatusFile.delete())) {
            log.warn("Failed to remove node status file " + nodeStatusFile.getAbsolutePath());
        }
    }
}

