/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.disasterrecovery;

import com.atlassian.fugue.Option;
import com.atlassian.jira.cluster.disasterrecovery.ReplicatorTask;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.config.util.SecondaryJiraHome;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.jira.util.log.RateLimitingLogger;
import com.google.common.io.Files;
import java.io.File;
import java.util.concurrent.ExecutorService;

class CopyTask
extends ReplicatorTask {
    private static final RateLimitingLogger log = new RateLimitingLogger(CopyTask.class);
    public static final int RETRIES = 3;
    private final ExecutorService executorService;
    private int retries = 0;

    public CopyTask(File file, JiraHome jiraHome, SecondaryJiraHome secondaryJiraHome, ExecutorService executorService) {
        super(file, jiraHome, secondaryJiraHome);
        this.executorService = executorService;
    }

    @Override
    public void run() {
        try {
            Option<String> relativePath = this.getRelativePathOf(this.jiraHome, this.file);
            if (relativePath.isEmpty()) {
                log.warn(" Attempting to replicate [" + this.file.getAbsolutePath() + "] failed because it is not in JIRA home");
                return;
            }
            String secondaryFilePath = PathUtils.joinPaths((String[])new String[]{this.secondaryJiraHome.getHomePath(), (String)relativePath.get()});
            this.createDirectoriesIfNecessary(secondaryFilePath);
            File to = new File(secondaryFilePath);
            Files.copy((File)this.file, (File)to);
        }
        catch (Exception e) {
            ++this.retries;
            if (this.retries < 3) {
                log.warn(" Error occured while trying to write [" + this.file.getAbsolutePath() + "] to the secondary location, re-adding the task . Retries " + this.retries + " . Error :  " + e.getMessage(), e);
                this.executorService.submit(this);
            }
            log.warn(" Giving up trying to write [" + this.file.getAbsolutePath() + "] after " + this.retries + " retries. Error :  " + e.getMessage(), e);
        }
    }
}

