/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterMessage;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.cluster.EventMessageConsumer;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.OfBizClusterMessageStore;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.dbc.Assertions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizMessageHandlerService
implements MessageHandlerService {
    private static final int INITIAL_DELAY = 3;
    private static final int PERIOD = 3;
    private static final int CHANNEL_MAX_LENGTH = 20;
    private static final int MESSAGE_MAX_LENGTH = 200;
    private static final Logger log = LoggerFactory.getLogger(OfBizMessageHandlerService.class);
    private final ClusterNodes clusterNodes;
    private final OfBizClusterMessageStore clusterMessageStore;
    private final ScheduledExecutorService scheduler;
    private final HashMap<String, List<WeakReference<ClusterMessageConsumer>>> listeners;
    private final EventMessageConsumer eventMessageConsumer;
    private final Map<String, Long> lastMessageProcessedByNodeId = new HashMap<String, Long>();
    @Nullable
    private volatile ScheduledFuture<?> messageHandlerService;
    private final Runnable handler = new Runnable(){

        @Override
        public void run() {
            OfBizMessageHandlerService.this.handleReceivedMessages();
        }
    };

    public OfBizMessageHandlerService(ClusterNodes clusterNodes, OfBizClusterMessageStore clusterMessageStore, EventPublisher eventPublisher) {
        this.clusterMessageStore = clusterMessageStore;
        this.clusterNodes = clusterNodes;
        this.scheduler = Executors.newScheduledThreadPool(1, ThreadFactories.namedThreadFactory("ClusterMessageHandlerServiceThread"));
        this.listeners = new HashMap();
        this.eventMessageConsumer = new EventMessageConsumer(eventPublisher);
        this.registerListener("Import Started", this.eventMessageConsumer);
        this.registerListener("Import Done", this.eventMessageConsumer);
        if (this.getCurrentNode().isClustered()) {
            for (Node node : clusterNodes.all()) {
                if (!node.isClustered()) continue;
                this.lastMessageProcessedByNodeId.put(node.getNodeId(), clusterMessageStore.getLatestMessageByNodeId(node.getNodeId()));
            }
        }
    }

    @Override
    @Nullable
    public ClusterMessage sendMessage(String destinationId, Message message) {
        ClusterMessage clusterMessage = null;
        if (this.getCurrentNode().isClustered()) {
            String sourceId = this.getCurrentNode().getNodeId();
            clusterMessage = this.clusterMessageStore.createMessage(sourceId, destinationId, message.toString());
        }
        return clusterMessage;
    }

    @Override
    public List<ClusterMessage> receiveMessages() {
        ArrayList<ClusterMessage> allMessages = new ArrayList<ClusterMessage>();
        Node currentNode = this.getCurrentNode();
        if (currentNode.isClustered()) {
            for (Node node : this.clusterNodes.all()) {
                if (!node.isClustered() || node.getNodeId().equals(currentNode.getNodeId())) continue;
                Long startAfterId = this.lastMessageProcessedByNodeId.get(node.getNodeId());
                allMessages.addAll(this.clusterMessageStore.getMessages(node, currentNode, startAfterId));
            }
        }
        return allMessages;
    }

    @Override
    public void start() {
        this.messageHandlerService = this.scheduler.scheduleAtFixedRate(this.handler, 3L, 3L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (this.messageHandlerService != null) {
            this.messageHandlerService.cancel(false);
        }
        this.scheduler.shutdown();
    }

    private Node getCurrentNode() {
        return this.clusterNodes.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReceivedMessages() {
        try {
            for (ClusterMessage message : this.receiveMessages()) {
                String channel = message.getMessage().getChannel();
                String supplementalInformation = message.getMessage().getSupplementalInformation();
                String sourceNode = message.getSourceNode();
                try {
                    this.sendLocalFromNode(channel, supplementalInformation, sourceNode);
                }
                catch (Exception e) {
                    log.error("There was a problem handling a cluster message", (Throwable)e);
                }
                finally {
                    this.lastMessageProcessedByNodeId.put(sourceNode, message.getId());
                }
            }
        }
        catch (Exception e) {
            log.error("There was a problem handling a cluster message", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(String channel, ClusterMessageConsumer consumer) {
        HashMap<String, List<WeakReference<ClusterMessageConsumer>>> hashMap = this.listeners;
        synchronized (hashMap) {
            List<WeakReference<ClusterMessageConsumer>> channelListeners = this.listeners.get(channel);
            if (channelListeners == null) {
                channelListeners = new ArrayList<WeakReference<ClusterMessageConsumer>>();
                this.listeners.put(channel, channelListeners);
            }
            channelListeners.add(new WeakReference<ClusterMessageConsumer>(consumer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(String channel, ClusterMessageConsumer consumer) {
        HashMap<String, List<WeakReference<ClusterMessageConsumer>>> hashMap = this.listeners;
        synchronized (hashMap) {
            List channelListeners = this.listeners.get(channel);
            if (channelListeners != null) {
                this.removeRef(channelListeners, consumer);
                if (channelListeners.isEmpty()) {
                    this.listeners.remove(channel);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(ClusterMessageConsumer consumer) {
        HashMap<String, List<WeakReference<ClusterMessageConsumer>>> hashMap = this.listeners;
        synchronized (hashMap) {
            Iterator<List<WeakReference<ClusterMessageConsumer>>> iterator = this.listeners.values().iterator();
            while (iterator.hasNext()) {
                List channelListeners = iterator.next();
                this.removeRef(channelListeners, consumer);
                if (!channelListeners.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    public void sendRemote(String channel, String message) {
        Assertions.notNull((String)"channel", (Object)channel);
        Assertions.is((String)"channel exceeds max length", (channel.length() <= 20 ? 1 : 0) != 0);
        Assertions.is((String)"message exceeds max length", (message.length() <= 200 ? 1 : 0) != 0);
        this.sendMessage("ALL", new Message(channel, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLocalFromNode(String channel, String message, String senderId) {
        ArrayList<ClusterMessageConsumer> channelListeners = new ArrayList<ClusterMessageConsumer>();
        HashMap<String, List<WeakReference<ClusterMessageConsumer>>> hashMap = this.listeners;
        synchronized (hashMap) {
            List<WeakReference<ClusterMessageConsumer>> channelListenerRefs = this.listeners.get(channel);
            if (channelListenerRefs == null) {
                return;
            }
            Iterator<WeakReference<ClusterMessageConsumer>> iterator = channelListenerRefs.iterator();
            while (iterator.hasNext()) {
                WeakReference<ClusterMessageConsumer> consumerReference = iterator.next();
                ClusterMessageConsumer messageConsumer = (ClusterMessageConsumer)consumerReference.get();
                if (messageConsumer != null) {
                    channelListeners.add(messageConsumer);
                    continue;
                }
                iterator.remove();
            }
            if (channelListenerRefs.isEmpty()) {
                this.listeners.remove(channel);
            }
        }
        for (ClusterMessageConsumer messageConsumer : channelListeners) {
            messageConsumer.receive(channel, message, senderId);
        }
    }

    private <T> void removeRef(List<WeakReference<T>> list, T object) {
        Iterator<WeakReference<T>> iterator = list.iterator();
        while (iterator.hasNext()) {
            WeakReference<T> ref = iterator.next();
            if (ref.get() != object) continue;
            iterator.remove();
        }
    }
}

