/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.beehive.db.ClusterNodeHeartbeatService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.index.ha.IndexesRestoredEvent;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.license.ClusterLicenseCheck;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;

public class DefaultClusterManager
implements ClusterManager,
Startable {
    private final ClusterNodes clusterNodes;
    private final EventPublisher eventPublisher;
    private final ClusterLicenseCheck licenseCheck;
    private final MessageHandlerService messageHandlerService;
    private Collection<Node> liveNodes;
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<ClusterNodeHeartbeatService> heartbeatServiceRef = ComponentAccessor.getComponentReference(ClusterNodeHeartbeatService.class);
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<NodeReindexService> nodeReindexServiceRef = ComponentAccessor.getComponentReference(NodeReindexService.class);

    public DefaultClusterManager(ClusterNodes clusterNodes, EventPublisher eventPublisher, ClusterLicenseCheck licenseCheck, MessageHandlerService messageHandlerService) {
        this.clusterNodes = clusterNodes;
        this.eventPublisher = eventPublisher;
        this.licenseCheck = licenseCheck;
        this.messageHandlerService = messageHandlerService;
    }

    public void start() {
        this.eventPublisher.register((Object)this);
    }

    @Nullable
    public String getNodeId() {
        return this.clusterNodes.current().getNodeId();
    }

    public boolean isClustered() {
        return this.clusterNodes.current().isClustered();
    }

    @Override
    public Set<Node> getAllNodes() {
        return this.isClustered() ? this.clusterNodes.all() : ImmutableSet.of();
    }

    @Override
    public boolean isActive() {
        return this.clusterNodes.current().getState().equals((Object)Node.NodeState.ACTIVE);
    }

    @Override
    public void checkIndex() {
        if (!((NodeReindexService)this.nodeReindexServiceRef.get()).canIndexBeRebuilt()) {
            this.requestCurrentIndexFromNode("ANY");
        }
    }

    @Override
    public void requestCurrentIndexFromNode(String node) {
        ((NodeReindexService)this.nodeReindexServiceRef.get()).pause();
        ((NodeReindexService)this.nodeReindexServiceRef.get()).resetIndexCount();
        this.messageHandlerService.sendMessage(node, new Message("Backup Index", null));
    }

    @Override
    public Collection<Node> findLiveNodes() {
        if (this.liveNodes == null) {
            this.refreshLiveNodes();
        }
        return this.liveNodes;
    }

    @Override
    public void refreshLiveNodes() {
        final Collection heartbeatLiveNodesIds = ((ClusterNodeHeartbeatService)this.heartbeatServiceRef.get()).findLiveNodes();
        Collection filter = CollectionUtil.filter(this.getAllNodes(), (Predicate)new Predicate<Node>(){

            public boolean evaluate(Node node) {
                return node != null && node.getState() == Node.NodeState.ACTIVE && heartbeatLiveNodesIds.contains(node.getNodeId());
            }
        });
        this.liveNodes = ImmutableSet.copyOf((Collection)filter);
    }

    @EventListener
    public void releaseNodeReindexService(IndexesRestoredEvent ev) {
        ((NodeReindexService)this.nodeReindexServiceRef.get()).start();
        ((NodeReindexService)this.nodeReindexServiceRef.get()).replayLocalOperations();
    }

    @Override
    public boolean isClusterLicensed() {
        return this.licenseCheck.evaluate().isPass();
    }
}

