/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.AverageAgeChart;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.CreatedVsResolvedChart;
import com.atlassian.jira.charts.DateRangeTimeChart;
import com.atlassian.jira.charts.PieChart;
import com.atlassian.jira.charts.RecentlyCreatedChart;
import com.atlassian.jira.charts.TimeSinceChart;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.util.profiling.UtilTimerStack;

public class DefaultChartFactory
implements ChartFactory {
    private final SearchProvider searchProvider;
    private final VersionManager versionManager;
    private final IssueIndexManager issueIndexManager;
    private final IssueSearcherManager issueSearcherManager;
    private final ConstantsManager constantsManager;
    private final CustomFieldManager customFieldManager;
    private final FieldManager fieldManager;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final ProjectManager projectManager;
    private final TimeZoneManager timeZoneManager;

    public DefaultChartFactory(SearchProvider searchProvider, VersionManager versionManager, IssueIndexManager issueIndexManager, IssueSearcherManager issueSearcherManager, ConstantsManager constantsManager, CustomFieldManager customFieldManager, FieldManager fieldManager, SearchService searchService, ApplicationProperties applicationProperties, ProjectManager projectManager, TimeZoneManager timeZoneManager) {
        this.searchProvider = searchProvider;
        this.versionManager = versionManager;
        this.issueIndexManager = issueIndexManager;
        this.issueSearcherManager = issueSearcherManager;
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
        this.fieldManager = fieldManager;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.projectManager = projectManager;
        this.timeZoneManager = timeZoneManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chart generateCreatedVsResolvedChart(ChartFactory.ChartContext context, int days, ChartFactory.PeriodName periodName, ChartFactory.VersionLabel versionLabel, boolean cumulative, boolean showUnresolvedTrend) {
        UtilTimerStack.push((String)"Generating Created vs Resolved chart");
        try {
            CreatedVsResolvedChart createdVsResolvedChart = new CreatedVsResolvedChart(this.searchProvider, this.versionManager, this.issueIndexManager, this.issueSearcherManager, this.projectManager, this.applicationProperties, this.searchService, this.timeZoneManager);
            if (context.isInline()) {
                Chart chart = createdVsResolvedChart.generateInlineChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, versionLabel, cumulative, showUnresolvedTrend, context.getWidth(), context.getHeight());
                return chart;
            }
            Chart chart = createdVsResolvedChart.generateChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, versionLabel, cumulative, showUnresolvedTrend, context.getWidth(), context.getHeight());
            return chart;
        }
        finally {
            UtilTimerStack.pop((String)"Generating Created vs Resolved chart");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chart generateDateRangeTimeChart(ChartFactory.ChartContext context, int days, ChartFactory.PeriodName periodName, long yAxisTimePeriod, String labelSuffixKey, String dateFieldId) {
        UtilTimerStack.push((String)"Generating Date Range Time chart");
        try {
            DateRangeTimeChart dateRangeChart = new DateRangeTimeChart(this.searchProvider, this.issueIndexManager, this.searchService, this.applicationProperties, this.timeZoneManager);
            if (context.isInline()) {
                Chart chart = dateRangeChart.generateInlineChart(context.getRemoteUser(), dateFieldId, context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight(), yAxisTimePeriod, labelSuffixKey);
                return chart;
            }
            Chart chart = dateRangeChart.generateChart(context.getRemoteUser(), dateFieldId, context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight(), yAxisTimePeriod, labelSuffixKey);
            return chart;
        }
        finally {
            UtilTimerStack.pop((String)"Generating Date Range Time chart");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chart generatePieChart(ChartFactory.ChartContext context, String statisticType) {
        UtilTimerStack.push((String)"Generating Pie chart");
        try {
            PieChart pieChart = new PieChart(this.constantsManager, this.customFieldManager, this.searchService, this.applicationProperties);
            if (context.isInline()) {
                Chart chart = pieChart.generateInlineChart(context.getRemoteUser(), context.getSearchRequest(), statisticType, context.getWidth(), context.getHeight());
                return chart;
            }
            Chart chart = pieChart.generateChart(context.getRemoteUser(), context.getSearchRequest(), statisticType, context.getWidth(), context.getHeight());
            return chart;
        }
        finally {
            UtilTimerStack.pop((String)"Generating Pie chart");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chart generateAverageAgeChart(ChartFactory.ChartContext context, int days, ChartFactory.PeriodName periodName) {
        UtilTimerStack.push((String)"Generating Average Age chart");
        try {
            AverageAgeChart averageAgeChart = new AverageAgeChart(this.searchProvider, this.issueIndexManager, this.timeZoneManager.getLoggedInUserTimeZone());
            if (context.isInline()) {
                Chart chart = averageAgeChart.generateInlineChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight());
                return chart;
            }
            Chart chart = averageAgeChart.generateChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight());
            return chart;
        }
        finally {
            UtilTimerStack.pop((String)"Generating Average Age chart");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chart generateRecentlyCreated(ChartFactory.ChartContext context, int days, ChartFactory.PeriodName periodName) {
        UtilTimerStack.push((String)"Generating Recently Created chart");
        try {
            RecentlyCreatedChart recentlyCreatedChart = new RecentlyCreatedChart(this.searchProvider, this.issueIndexManager, this.searchService, this.applicationProperties, this.timeZoneManager);
            if (context.isInline()) {
                Chart chart = recentlyCreatedChart.generateInlineChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight());
                return chart;
            }
            Chart chart = recentlyCreatedChart.generateChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight());
            return chart;
        }
        finally {
            UtilTimerStack.pop((String)"Generating Recently Created chart");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chart generateTimeSinceChart(ChartFactory.ChartContext context, int days, ChartFactory.PeriodName periodName, boolean cumulative, String dateFieldId) {
        UtilTimerStack.push((String)"Generating Time Since chart");
        try {
            TimeSinceChart timeSinceChart = new TimeSinceChart(this.fieldManager, this.searchProvider, this.issueIndexManager, this.searchService, this.applicationProperties, this.timeZoneManager.getLoggedInUserTimeZone());
            if (context.isInline()) {
                Chart chart = timeSinceChart.generateInlineChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight(), cumulative, dateFieldId);
                return chart;
            }
            Chart chart = timeSinceChart.generateChart(context.getRemoteUser(), context.getSearchRequest(), days, periodName, context.getWidth(), context.getHeight(), cumulative, dateFieldId);
            return chart;
        }
        finally {
            UtilTimerStack.pop((String)"Generating Time Since chart");
        }
    }
}

