/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.slomo;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.cache.slomo.SloMoCacheManager;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SloMoCache<K, V>
implements Cache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(SloMoCache.class);
    private final Cache<K, V> delegate;
    private final SloMoCacheManager manager;

    public SloMoCache(SloMoCacheManager manager, Cache<K, V> delegate) {
        this.delegate = delegate;
        this.manager = manager;
    }

    @Nonnull
    public String getName() {
        return this.delegate.getName();
    }

    public boolean containsKey(K key) {
        this.manager.sleep();
        return this.delegate.containsKey(key);
    }

    @Nonnull
    public Collection<K> getKeys() {
        LOG.warn("Enumerating the keys for '{}' will not be supported by VCache", (Object)this.delegate.getName(), (Object)new IllegalArgumentException("Called getKeys() here"));
        return this.delegate.getKeys();
    }

    @Nullable
    public V get(K key) {
        this.manager.sleep();
        return (V)this.delegate.get(key);
    }

    @Nonnull
    public V get(K key, Supplier<? extends V> supplier) {
        this.manager.sleep();
        return (V)this.delegate.get(key, supplier);
    }

    public void put(K key, V value) {
        this.manager.sleep();
        this.delegate.put(key, value);
    }

    @Nullable
    public V putIfAbsent(K key, V value) {
        this.manager.sleep();
        return (V)this.delegate.putIfAbsent(key, value);
    }

    public void remove(K key) {
        this.manager.sleep();
        this.delegate.remove(key);
    }

    public boolean remove(K key, V value) {
        this.manager.sleep();
        return this.delegate.remove(key, value);
    }

    public void removeAll() {
        this.manager.sleep();
        this.delegate.removeAll();
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.manager.sleep();
        return this.delegate.replace(key, oldValue, newValue);
    }

    public void addListener(CacheEntryListener<K, V> listener, boolean includeValues) {
        LOG.warn("CacheEntryListener for '{}' will not be supported by VCache", (Object)this.delegate.getName(), (Object)new IllegalArgumentException("Added here"));
        this.delegate.addListener(listener, includeValues);
    }

    public void removeListener(CacheEntryListener<K, V> cacheEntryListener) {
        this.delegate.removeListener(cacheEntryListener);
    }
}

