/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.cache.CachedReference;
import com.atlassian.vcache.LocalCacheOperations;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface SingleValueLocalCache<V> {
    public static final String KEY = "cachedReferenceKey";

    @Nonnull
    public V get();

    public void reset();

    public static <V> SingleValueLocalCache<V> of(final LocalCacheOperations<String, V> cache, final Supplier<V> supplier) {
        return new SingleValueLocalCache<V>(){

            @Override
            @Nonnull
            public V get() {
                return cache.get((Object)SingleValueLocalCache.KEY, supplier);
            }

            @Override
            public void reset() {
                cache.remove((Object)SingleValueLocalCache.KEY);
            }
        };
    }

    public static <V> SingleValueLocalCache<V> of(final CachedReference<V> cache) {
        return new SingleValueLocalCache<V>(){

            @Override
            @Nonnull
            public V get() {
                return cache.get();
            }

            @Override
            public void reset() {
                cache.reset();
            }
        };
    }
}

