/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.subtask.conversion.IssueToSubTaskConversionService;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.bulkedit.operation.BulkOperationException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.txnaware.TxnAwareEventFactory;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ProjectField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.transformers.IssueChangeHolderTransformer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionRuntimeException;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanImpl;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class BulkMoveOperationImpl
implements BulkMoveOperation {
    protected static final Logger log = Logger.getLogger(BulkMoveOperationImpl.class);
    private static final String DESCRIPTION_KEY = "bulk.move.operation.description";
    private static final String PARENT_ISSUE_KEY = "parentIssueKey";
    private final WorkflowManager workflowManager;
    private final ProjectManager projectManager;
    private final FieldManager fieldManager;
    private final IssueFactory issueFactory;
    private final IssueManager issueManager;
    private final IssueEventManager issueEventManager;
    private final BulkEditBeanSessionHelper bulkEditBeanSessionHelper;
    private final AttachmentManager attachmentManager;
    private final IssueEventBundleFactory issueEventBundleFactory;
    private final IssueLinkManager issueLinkManager;
    private final SubTaskManager subTaskManager;
    private final IssueToSubTaskConversionService issueToSubTaskConversionService;
    private final TxnAwareEventFactory txnAwareEventFactory;

    public BulkMoveOperationImpl(WorkflowManager workflowManager, ProjectManager projectManager, FieldManager fieldManager, IssueFactory issueFactory, IssueManager issueManager, IssueEventManager issueEventManager, BulkEditBeanSessionHelper bulkEditBeanSessionHelper, AttachmentManager attachmentManager, IssueEventBundleFactory issueEventBundleFactory, IssueLinkManager issueLinkManager, SubTaskManager subTaskManager, IssueToSubTaskConversionService issueToSubTaskConversionService, TxnAwareEventFactory txnAwareEventFactory) {
        this.workflowManager = workflowManager;
        this.projectManager = projectManager;
        this.fieldManager = fieldManager;
        this.issueFactory = issueFactory;
        this.issueManager = issueManager;
        this.issueEventManager = issueEventManager;
        this.bulkEditBeanSessionHelper = bulkEditBeanSessionHelper;
        this.attachmentManager = attachmentManager;
        this.issueEventBundleFactory = issueEventBundleFactory;
        this.issueLinkManager = issueLinkManager;
        this.subTaskManager = subTaskManager;
        this.issueToSubTaskConversionService = issueToSubTaskConversionService;
        this.txnAwareEventFactory = txnAwareEventFactory;
    }

    public boolean canPerform(BulkEditBean bulkEditBean, ApplicationUser applicationUser) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
        for (Issue issueObject : selectedIssues) {
            if (!permissionManager.hasPermission(25, issueObject, applicationUser)) {
                return false;
            }
            Collection subTasks = issueObject.getSubTaskObjects();
            for (Issue subTask : subTasks) {
                if (permissionManager.hasPermission(25, subTask, applicationUser)) continue;
                return false;
            }
        }
        return true;
    }

    public void perform(BulkEditBean bulkEditBean, ApplicationUser applicationUser, Context taskContext) throws BulkOperationException {
        try {
            this.moveIssuesAndIndex(bulkEditBean, applicationUser, taskContext);
            if (bulkEditBean.getSubTaskBulkEditBean() != null) {
                this.moveIssuesAndIndex(bulkEditBean.getSubTaskBulkEditBean(), applicationUser, taskContext);
            }
        }
        catch (Exception e) {
            throw new BulkOperationException((Throwable)e);
        }
    }

    public int getNumberOfTasks(BulkEditBean bulkEditBean) {
        int count = bulkEditBean.getSelectedIssues().size();
        if (bulkEditBean.getSubTaskBulkEditBean() != null) {
            count += bulkEditBean.getSubTaskBulkEditBean().getSelectedIssues().size();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveIssuesAndIndex(BulkEditBean bulkEditBean, ApplicationUser applicationUser, Context taskContext) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        RuntimeException firstException = null;
        for (Object selectedIssue : selectedIssues) {
            Context.Task task = taskContext.start(selectedIssue);
            MutableIssue issue = (MutableIssue)selectedIssue;
            try {
                Transaction txn = Txn.begin();
                try {
                    this.moveIssueInsideTxn(txn, bulkEditBean, applicationUser, issue);
                }
                catch (RuntimeException e) {
                    log.error((Object)String.format("An exception occured while moving '%s' : %s. Rolling back the operation", issue.getKey(), e.getMessage()));
                    firstException = e;
                }
                finally {
                    txn.finallyRollbackIfNotCommitted();
                }
            }
            catch (TransactionRuntimeException tre) {
                log.error((Object)String.format("Unable to obtain database transaction for '%s' : %s", issue.getKey(), tre.getMessage()));
                firstException = tre;
            }
            task.complete();
            if (firstException == null) continue;
            throw firstException;
        }
    }

    private void moveIssueInsideTxn(Transaction txn, BulkEditBean bulkEditBean, ApplicationUser applicationUser, MutableIssue issue) {
        boolean issueProjectMoved;
        MutableIssue newIssue = (MutableIssue)bulkEditBean.getTargetIssueObjects().get(issue);
        boolean bl = issueProjectMoved = !issue.getProjectId().equals(bulkEditBean.getTargetPid());
        if (issueProjectMoved) {
            Project targetProject = bulkEditBean.getTargetProject();
            if (targetProject != null) {
                long incCount = this.projectManager.getNextId(targetProject);
                newIssue.setNumber(Long.valueOf(incCount));
            } else {
                throw new IllegalStateException("Target project unavailable");
            }
        }
        if (issueProjectMoved) {
            this.attachmentManager.moveAttachments((Issue)issue, newIssue.getKey());
        }
        if (!this.workflowManager.getWorkflow((Issue)issue).equals(bulkEditBean.getTargetWorkflow())) {
            Status newStatus = bulkEditBean.getTargetStatusObject((Issue)issue);
            if (newStatus == null) {
                newStatus = issue.getStatusObject();
            }
            this.workflowManager.migrateIssueToWorkflow(newIssue, bulkEditBean.getTargetWorkflow(), newStatus);
        }
        newIssue.setUpdated(new Timestamp(System.currentTimeMillis()));
        this.manageLinks(issue, newIssue, applicationUser);
        newIssue.store();
        IssueChangeHolder issueChangeHolder = this.moveIssueDetails(issue, newIssue, bulkEditBean);
        GenericValue changeGroup = ChangeLogUtils.createChangeGroup(applicationUser, (Issue)issue, (Issue)newIssue, (Collection<ChangeItemBean>)issueChangeHolder.getChangeItems(), false);
        if (issueProjectMoved) {
            this.issueManager.recordMovedIssueKey((Issue)issue);
        }
        txn.commit();
        if (changeGroup != null) {
            this.txnAwareEventFactory.issueChangedEventOnCommit(newIssue.getId(), applicationUser, null, changeGroup.getLong("id"));
        }
        this.dispatchEvents((Issue)newIssue, changeGroup, issueChangeHolder, bulkEditBean, applicationUser, issueProjectMoved);
    }

    void manageLinks(MutableIssue issue, MutableIssue newIssue, ApplicationUser applicationUser) {
        if (!newIssue.getIssueType().isSubTask() && issue.getIssueType().isSubTask()) {
            this.removeLinkFromParent(issue, applicationUser);
        } else if (newIssue.getIssueType().isSubTask() && !issue.getIssueType().isSubTask()) {
            this.addLinkFromNewParent(newIssue, newIssue.getParentObject(), applicationUser);
        } else if (newIssue.getIssueType().isSubTask() && issue.getIssueType().isSubTask() && !Optional.ofNullable(issue.getParentId()).equals(Optional.ofNullable(newIssue.getParentId()))) {
            this.removeLinkFromParent(issue, applicationUser);
            this.addLinkFromNewParent(newIssue, newIssue.getParentObject(), applicationUser);
        }
    }

    private void addLinkFromNewParent(MutableIssue newIssue, Issue newParent, ApplicationUser applicationUser) {
        if (newParent != null) {
            try {
                this.subTaskManager.createSubTaskIssueLink(newParent, (Issue)newIssue, applicationUser);
            }
            catch (CreateException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void removeLinkFromParent(MutableIssue issue, ApplicationUser applicationUser) {
        if (issue.getParentId() != null) {
            List parentLinks = this.issueLinkManager.getOutwardLinks(issue.getParentId());
            parentLinks.stream().filter(link -> link.getIssueLinkType().isSubTaskLinkType() && link.getDestinationId().equals(issue.getId())).forEach(link -> this.issueLinkManager.removeIssueLink(link, applicationUser));
        }
    }

    private void rollback(Transaction txn) {
        txn.rollback();
    }

    public void chooseContextNoValidate(BulkEditBean bulkEditBean, ApplicationUser applicationUser) {
        this.fieldManager.getProjectField().populateFromParams(bulkEditBean.getFieldValuesHolder(), ActionContext.getParameters());
        this.fieldManager.getIssueTypeField().populateFromParams(bulkEditBean.getFieldValuesHolder(), ActionContext.getParameters());
        this.finishChooseContext(bulkEditBean, applicationUser);
    }

    public void chooseContext(BulkEditBean bulkEditBean, ApplicationUser applicationUser, I18nHelper i18nHelper, ErrorCollection errors) {
        Map actionParams = this.extractBulkEditBeanParams(bulkEditBean);
        MutableIssue issueObject = this.getIssueObject(null);
        if (bulkEditBean.isSubTaskCollection()) {
            issueObject.setParentId(new Long(0L));
        }
        SimpleErrorCollection newErrors = new SimpleErrorCollection();
        ProjectField projectField = this.fieldManager.getProjectField();
        projectField.populateFromParams(bulkEditBean.getFieldValuesHolder(), actionParams);
        projectField.validateParams((OperationContext)bulkEditBean, (ErrorCollection)newErrors, i18nHelper, (Issue)issueObject, null);
        if (newErrors.getErrors().containsKey("pid")) {
            newErrors.getErrors().put("project", newErrors.getErrors().get("pid"));
        }
        issueObject.setProjectObject(bulkEditBean.getTargetProject());
        IssueTypeField issueTypeField = this.fieldManager.getIssueTypeField();
        issueTypeField.populateFromParams(bulkEditBean.getFieldValuesHolder(), actionParams);
        issueTypeField.validateParams((OperationContext)bulkEditBean, (ErrorCollection)newErrors, i18nHelper, (Issue)issueObject, null);
        Collection subTaskOptionsForTargetProject = issueTypeField.getOptionsForIssue((Issue)issueObject, true);
        if (subTaskOptionsForTargetProject.isEmpty() && !bulkEditBean.getSubTaskOfSelectedIssues().isEmpty()) {
            newErrors.addError(projectField.getId(), i18nHelper.getText("bulk.move.no.subtask", String.valueOf(bulkEditBean.getSubTaskOfSelectedIssues().size())));
        }
        if (bulkEditBean.getTargetIssueType().isSubTask()) {
            bulkEditBean.setParentIssueKey((String)this.getParam(PARENT_ISSUE_KEY, actionParams));
        } else {
            bulkEditBean.setParentIssueKey(null);
        }
        this.validateParentIssue(bulkEditBean, i18nHelper, (ErrorCollection)newErrors);
        if (newErrors.hasAnyErrors()) {
            Map errorsForFields = newErrors.getErrors();
            Set entries = errorsForFields.entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry1;
                Map.Entry entry = entry1 = iterator.next();
                String field = (String)entry.getKey();
                String message = (String)entry.getValue();
                errors.addError(bulkEditBean.getKey() + field, message);
            }
            errors.getErrorMessages().addAll(newErrors.getErrorMessages());
        }
    }

    protected Object getParam(String id, Map<String, String[]> params) {
        String[] value = params.get(id);
        if (value != null && value.length > 0) {
            return value[0];
        }
        return null;
    }

    private void validateParentIssue(BulkEditBean bulkEditBean, I18nHelper i18nHelper, ErrorCollection errors) {
        if (this.isParentIssueValidationNeeded(bulkEditBean)) {
            String parentIssueKey = bulkEditBean.getParentIssueKey();
            if (parentIssueKey == null) {
                errors.addError(PARENT_ISSUE_KEY, i18nHelper.getText("convert.issue.to.subtask.error.noparentissuekey"));
            } else {
                MutableIssue parentIssue = this.issueManager.getIssueObject(parentIssueKey);
                if (parentIssue == null) {
                    errors.addError(PARENT_ISSUE_KEY, i18nHelper.getText("convert.issue.to.subtask.error.invalidparentissuekey", parentIssueKey));
                } else {
                    this.issueToSubTaskConversionService.validateParentIssue((JiraServiceContext)new JiraServiceContextImpl(ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser(), errors), this.createTempIssue(-1L, parentIssue.getProjectId()), (Issue)parentIssue, PARENT_ISSUE_KEY);
                    if (!parentIssue.getProjectId().equals(bulkEditBean.getTargetPid())) {
                        errors.addError(PARENT_ISSUE_KEY, i18nHelper.getText("convert.issue.to.subtask.error.differentproject", parentIssue.getKey(), ""));
                    }
                    if (bulkEditBean.getSelectedIssues().stream().anyMatch(arg_0 -> BulkMoveOperationImpl.lambda$validateParentIssue$2((Issue)parentIssue, arg_0))) {
                        errors.addError(PARENT_ISSUE_KEY, i18nHelper.getText("convert.issue.to.subtask.error.parentincurrentgroup"));
                    }
                }
            }
        }
    }

    private boolean isParentIssueValidationNeeded(BulkEditBean bulkEditBean) {
        if (bulkEditBean.getParentBulkEditBean() == null) {
            return Optional.ofNullable(bulkEditBean.getTargetIssueTypeObject()).filter(IssueType::isSubTask).isPresent();
        }
        return false;
    }

    private Issue createTempIssue(Long id, Long projectId) {
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectId(projectId);
        return issue;
    }

    @Deprecated
    public void finishChooseContext(MultiBulkMoveBean multiBulkMoveBean, ApplicationUser applicationUser) {
        for (Object o : multiBulkMoveBean.getBulkEditBeans().values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o;
            this.finishChooseContext(bulkEditBean, applicationUser);
        }
    }

    public void finishChooseContext(BulkEditBean bulkEditBean, ApplicationUser applicationUser) {
        bulkEditBean.setTargetFieldLayout();
        this.setMoveFieldLayoutItems(bulkEditBean);
        this.setRemovedFields(bulkEditBean);
        boolean parentIssueToSubtaskConversion = bulkEditBean.getTargetIssueTypeObject().isSubTask() && bulkEditBean.getParentIssueKey() != null;
        Project targetProject = bulkEditBean.getTargetProject();
        ArrayList<Issue> subTasksRequiringMove = new ArrayList<Issue>();
        for (Issue subTask : bulkEditBean.getSubTaskOfSelectedIssues()) {
            if (targetProject.equals(subTask.getProjectObject()) && !parentIssueToSubtaskConversion) continue;
            subTasksRequiringMove.add(subTask);
        }
        if (!subTasksRequiringMove.isEmpty()) {
            BulkEditBeanImpl subTaskBulkEditBean = new BulkEditBeanImpl(this.issueManager);
            subTaskBulkEditBean.setOperationName(bulkEditBean.getOperationName());
            subTaskBulkEditBean.initSelectedIssues(subTasksRequiringMove);
            subTaskBulkEditBean.setTargetProject(targetProject);
            if (parentIssueToSubtaskConversion) {
                subTaskBulkEditBean.setParentIssueKey(bulkEditBean.getParentIssueKey());
            }
            bulkEditBean.setSubTaskBulkEditBean((BulkEditBean)subTaskBulkEditBean);
        }
    }

    private Map extractBulkEditBeanParams(BulkEditBean bulkEditBean) {
        Object bulkEditIssueTypeId;
        String bulkEditKey = bulkEditBean.getKey();
        Map actionParams = ActionContext.getParameters();
        HashedMap modifiedMap = new HashedMap(actionParams);
        Object bulkeditPid = actionParams.get(bulkEditKey + "pid");
        if (bulkeditPid != null) {
            modifiedMap.put("pid", bulkeditPid);
        }
        if ((bulkEditIssueTypeId = actionParams.get(bulkEditKey + this.fieldManager.getIssueTypeField().getId())) != null) {
            modifiedMap.put(this.fieldManager.getIssueTypeField().getId(), bulkEditIssueTypeId);
        }
        Object parentIssueKey = actionParams.get(bulkEditKey + PARENT_ISSUE_KEY);
        modifiedMap.put(PARENT_ISSUE_KEY, parentIssueKey);
        String sameAsBulkEditBean = ParameterUtils.getStringParam((Map)modifiedMap, (String)"sameAsBulkEditBean");
        if (bulkEditBean.getParentBulkEditBean() == null && StringUtils.isNotBlank((String)sameAsBulkEditBean)) {
            String[] pid = (String[])modifiedMap.get(sameAsBulkEditBean + "pid");
            String[] issueTypeId = (String[])modifiedMap.get(sameAsBulkEditBean + this.fieldManager.getIssueTypeField().getId());
            modifiedMap.put(bulkEditKey + "pid", pid);
            modifiedMap.put(bulkEditKey + this.fieldManager.getIssueTypeField().getId(), issueTypeId);
            modifiedMap.put("pid", pid);
            modifiedMap.put(this.fieldManager.getIssueTypeField().getId(), issueTypeId);
            Object parentIssue = actionParams.get(sameAsBulkEditBean + PARENT_ISSUE_KEY);
            modifiedMap.put(bulkEditKey + PARENT_ISSUE_KEY, parentIssue);
            modifiedMap.put(PARENT_ISSUE_KEY, parentIssue);
        }
        ActionContext.setParameters((Map)modifiedMap);
        return modifiedMap;
    }

    public boolean isStatusValid(BulkEditBean bulkEditBean) {
        try {
            return bulkEditBean.getInvalidStatuses().isEmpty();
        }
        catch (WorkflowException e) {
            log.warn((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void moveIssuesAndIndex(BulkEditBean bulkEditBean, ApplicationUser remoteUser) {
        this.moveIssuesAndIndex(bulkEditBean, remoteUser, Contexts.nullContext());
    }

    public void setStatusFields(BulkEditBean bulkEditBean) throws WorkflowException {
        bulkEditBean.populateStatusHolder();
    }

    public void validatePopulateFields(BulkEditBean bulkEditBean, ErrorCollection errors, I18nHelper i18nHelper) {
        Map params = ActionContext.getParameters();
        if (params != null && !params.isEmpty()) {
            Set keys = params.keySet();
            for (Object key1 : keys) {
                String key = (String)key1;
                if (!key.startsWith("retain")) continue;
                String fieldId = StringUtils.substringAfter((String)key, (String)"retain_");
                bulkEditBean.addRetainValue(fieldId);
            }
        }
        List selectedIssues = bulkEditBean.getSelectedIssues();
        HashSet errorCollection = new HashSet();
        this.calculateFieldSubstitutions(bulkEditBean);
        for (Issue selectedIssue1 : selectedIssues) {
            MutableIssue selectedIssue = (MutableIssue)selectedIssue1;
            this.validateFieldLayoutItems(selectedIssue, (MutableIssue)bulkEditBean.getTargetIssueObjects().get(selectedIssue), bulkEditBean.getMoveFieldLayoutItems(), bulkEditBean, errorCollection, errors, i18nHelper);
        }
    }

    private void calculateFieldSubstitutions(BulkEditBean bulkEditBean) {
        Collection fieldLayoutItems = bulkEditBean.getMoveFieldLayoutItems();
        for (Object o : fieldLayoutItems) {
            FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)o;
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            String fieldId = orderableField.getId();
            if (!orderableField.isShown(bulkEditBean.getFirstTargetIssueObject()) || !this.doesFieldHaveMappings(fieldId, ActionContext.getParameters())) continue;
            Map<Long, Long> substitutions = this.createSubstitutionMap(fieldId, ActionContext.getParameters());
            bulkEditBean.getFieldSubstitutionMap().put(orderableField.getId(), substitutions);
            Map sessionFieldSubstitutionMap = this.bulkEditBeanSessionHelper.getFromSession().getFieldSubstitutionMap();
            if (sessionFieldSubstitutionMap.containsKey(orderableField.getId())) {
                Map compositeMap = CompositeMap.of(substitutions, (Map)((Map)sessionFieldSubstitutionMap.get(orderableField.getId())));
                sessionFieldSubstitutionMap.put(orderableField.getId(), compositeMap);
                continue;
            }
            sessionFieldSubstitutionMap.put(orderableField.getId(), substitutions);
        }
    }

    private void validateFieldLayoutItems(MutableIssue selectedIssue, MutableIssue targetIssue, Collection fieldLayoutItems, BulkEditBean bulkEditBean, Collection errorCollection, ErrorCollection errors, I18nHelper i18nHelper) {
        FieldLayout targetFieldLayout = bulkEditBean.getTargetFieldLayoutForType(bulkEditBean.getTargetIssueType().getId());
        for (Object item : fieldLayoutItems) {
            FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)item;
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            String fieldId = orderableField.getId();
            if (orderableField.isShown((Issue)targetIssue)) {
                boolean fieldNeedsMoveForThisIssue = this.fieldNeedsMove(Collections.singletonList(selectedIssue), (Issue)targetIssue, bulkEditBean, targetFieldLayout.getFieldLayoutItem(orderableField)).getResult();
                if (!fieldNeedsMoveForThisIssue && bulkEditBean.isRetainChecked(fieldId)) continue;
                orderableField.populateFromParams(bulkEditBean.getFieldValuesHolder(), ActionContext.getParameters());
                if (this.doesFieldHaveMappings(fieldId, ActionContext.getParameters())) {
                    Map substitutions = (Map)bulkEditBean.getFieldSubstitutionMap().get(fieldId);
                    Object newValue = this.createSubstitutedValues((Issue)selectedIssue, orderableField, substitutions);
                    bulkEditBean.getFieldValuesHolder().put(fieldId, newValue);
                }
                orderableField.validateParams((OperationContext)bulkEditBean, errors, i18nHelper, (Issue)targetIssue, (FieldScreenRenderLayoutItem)new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
                if (errors.hasAnyErrors()) {
                    for (String message : errors.getErrorMessages()) {
                        if (!errorCollection.isEmpty() && errorCollection.contains(message)) continue;
                        errorCollection.add(message);
                    }
                    errors.setErrorMessages(new ArrayList());
                    continue;
                }
                orderableField.updateIssue(fieldLayoutItem, targetIssue, bulkEditBean.getFieldValuesHolder());
                continue;
            }
            orderableField.populateDefaults(bulkEditBean.getFieldValuesHolder(), (Issue)targetIssue);
            SimpleErrorCollection errorCollection2 = new SimpleErrorCollection();
            orderableField.validateParams((OperationContext)bulkEditBean, (ErrorCollection)errorCollection2, i18nHelper, (Issue)targetIssue, (FieldScreenRenderLayoutItem)new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
            if (errorCollection2.getErrors() != null && !errorCollection2.getErrors().isEmpty()) {
                for (String s : errorCollection2.getErrors().values()) {
                    errors.addErrorMessage(this.getFieldName((Field)orderableField, i18nHelper) + ": " + s);
                }
                continue;
            }
            orderableField.updateIssue(fieldLayoutItem, targetIssue, bulkEditBean.getFieldValuesHolder());
        }
        errors.addErrorMessages(errorCollection);
    }

    private Object createSubstitutedValues(Issue selectedIssue, OrderableField orderableField, Map<Long, Long> substitutions) {
        if (orderableField instanceof CustomField) {
            return this.createSubstitutedValuesForCustomFields(selectedIssue, (CustomField)orderableField, substitutions);
        }
        return this.createSubstitutedValuesForSystemFields(selectedIssue, orderableField, substitutions);
    }

    private Collection<Long> createSubstitutedValuesForSystemFields(Issue selectedIssue, OrderableField orderableField, Map<Long, Long> substitutions) {
        String fieldId = orderableField.getId();
        LinkedHashMap workingMap = new LinkedHashMap();
        orderableField.populateFromIssue(workingMap, selectedIssue);
        Collection existingIds = (Collection)workingMap.get(fieldId);
        ArrayList<Long> newValues = new ArrayList<Long>();
        if (existingIds != null) {
            if (existingIds.isEmpty() && substitutions.containsKey(-1L)) {
                newValues.add(substitutions.get(-1L));
            } else {
                for (Long existingId : existingIds) {
                    Long newValue;
                    if (existingId == null || (newValue = substitutions.get(existingId)) == null) continue;
                    newValues.add(newValue);
                }
            }
        }
        return newValues;
    }

    private CustomFieldParams createSubstitutedValuesForCustomFields(Issue selectedIssue, CustomField customField, Map<Long, Long> substitutions) {
        String fieldId = customField.getId();
        LinkedHashMap workingMap = new LinkedHashMap();
        customField.populateFromIssue(workingMap, selectedIssue);
        CustomFieldParams existingValues = (CustomFieldParams)workingMap.get(fieldId);
        ArrayList<String> newValues = new ArrayList<String>();
        if (existingValues != null) {
            Collection existingIdsAsStrings = existingValues.getValuesForNullKey();
            if (existingIdsAsStrings.isEmpty() && substitutions.containsKey(-1L)) {
                newValues.add(substitutions.get(-1L).toString());
            } else {
                for (String existingId : existingIdsAsStrings) {
                    Long key;
                    Long newValue;
                    if (existingId == null || (newValue = substitutions.get(key = this.parseLong(existingId))) == null) continue;
                    newValues.add(newValue.toString());
                }
            }
        }
        return new CustomFieldParamsImpl(customField, newValues);
    }

    private Map<Long, Long> createSubstitutionMap(String fieldId, Map<String, Object> actionParameters) {
        Pattern pattern = Pattern.compile(fieldId + "_(.+)");
        TreeMap<Long, Long> result = new TreeMap<Long, Long>();
        for (String paramName : actionParameters.keySet()) {
            Long newId;
            String value;
            Long oldId;
            Matcher matcher = pattern.matcher(paramName);
            if (!matcher.matches() || (oldId = this.parseLong(matcher.group(1))) == null || (value = ParameterUtils.getStringParam(actionParameters, (String)paramName)) == null || (newId = this.parseLong(value)) == null) continue;
            if (newId.equals(-1L)) {
                newId = null;
            }
            result.put(oldId, newId);
        }
        return result;
    }

    private Long parseLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private boolean doesFieldHaveMappings(String fieldId, Map parameters) {
        String prefix = fieldId + "_";
        for (Object o : parameters.keySet()) {
            String key = (String)o;
            if (!key.startsWith(prefix)) continue;
            String suffix = key.substring(prefix.length());
            try {
                Long.parseLong(suffix);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getFieldName(Field field, I18nHelper i18nHelper) {
        if (field instanceof CustomField) {
            return field.getName();
        }
        return i18nHelper.getText(field.getNameKey());
    }

    private void setMoveFieldLayoutItems(BulkEditBean bulkEditBean) {
        HashSet<FieldLayoutItem> moveFieldLayoutItems = new HashSet<FieldLayoutItem>();
        HashMap<String, MessagedResult> messagedFieldLayoutItems = new HashMap<String, MessagedResult>();
        FieldLayout targetFieldLayout = bulkEditBean.getTargetFieldLayout();
        for (FieldLayoutItem fieldLayoutItem : targetFieldLayout.getVisibleLayoutItems(bulkEditBean.getTargetProject(), EasyList.build((Object)bulkEditBean.getTargetIssueTypeId()))) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            if ("issuetype".equals(orderableField.getId())) continue;
            MessagedResult messagedResult = this.fieldNeedsMove(fieldLayoutItem, bulkEditBean);
            if (messagedResult.getResult()) {
                moveFieldLayoutItems.add(fieldLayoutItem);
                continue;
            }
            if (messagedResult.getMessage() == null) continue;
            messagedFieldLayoutItems.put(fieldLayoutItem.getOrderableField().getName(), messagedResult);
        }
        bulkEditBean.setMessagedFieldLayoutItems(messagedFieldLayoutItems);
        bulkEditBean.setMoveFieldLayoutItems(moveFieldLayoutItems);
    }

    private MessagedResult fieldNeedsMove(FieldLayoutItem fieldLayoutItem, BulkEditBean bulkEditBean) {
        return this.fieldNeedsMove(bulkEditBean.getSelectedIssues(), bulkEditBean.getFirstTargetIssueObject(), bulkEditBean, fieldLayoutItem);
    }

    private MessagedResult fieldNeedsMove(Collection originalIssues, Issue firstTargetIssueObject, BulkEditBean bulkEditBean, FieldLayoutItem fieldLayoutItem) {
        OrderableField orderableField = fieldLayoutItem.getOrderableField();
        if (bulkEditBean.getParentBulkEditBean() != null && orderableField.getId().equals("security") && this.bulkEditBeanIsChangingField(bulkEditBean.getParentBulkEditBean(), "security")) {
            return new MessagedResult(true);
        }
        return orderableField.needsMove(originalIssues, firstTargetIssueObject, fieldLayoutItem);
    }

    private boolean bulkEditBeanIsChangingField(BulkEditBean bulkEditBean, String fieldID) {
        for (Object o : bulkEditBean.getMoveFieldLayoutItems()) {
            FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)o;
            if (fieldLayoutItem.getOrderableField() == null || !fieldID.equals(fieldLayoutItem.getOrderableField().getId())) continue;
            return true;
        }
        return false;
    }

    private void setRemovedFields(BulkEditBean bulkEditBean) {
        HashSet<OrderableField> removedFields = new HashSet<OrderableField>();
        List selectedIssues = bulkEditBean.getSelectedIssues();
        Collection<Field> targetHiddenFields = this.getTargetHiddenFields(bulkEditBean);
        for (Issue issue : selectedIssues) {
            for (Field field : targetHiddenFields) {
                OrderableField orderableField;
                if (!this.fieldManager.isOrderableField(field) || !(orderableField = (OrderableField)field).hasValue(issue)) continue;
                MutableIssue targetIssue = (MutableIssue)bulkEditBean.getTargetIssueObjects().get(issue);
                if (targetIssue == null) {
                    throw new IllegalStateException("Could not find target issue for issue " + issue.getKey() + " in BulkMoveOperation.");
                }
                if (!orderableField.canRemoveValueFromIssueObject((Issue)targetIssue)) continue;
                orderableField.removeValueFromIssueObject(targetIssue);
                removedFields.add(orderableField);
            }
        }
        bulkEditBean.setRemovedFields(removedFields);
    }

    protected Collection<Field> getTargetHiddenFields(BulkEditBean bulkEditBean) {
        return bulkEditBean.getTargetFieldLayout().getHiddenFields(bulkEditBean.getTargetProject(), EasyList.build((Object)bulkEditBean.getTargetIssueTypeId()));
    }

    public String getNameKey() {
        return "bulk.move.operation.name";
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public String getOperationName() {
        return "BulkMove";
    }

    public String getCannotPerformMessageKey() {
        return "bulk.move.cannotperform";
    }

    public JiraWorkflow getWorkflowForType(Long projectId, String issueTypeId) throws WorkflowException {
        return this.workflowManager.getWorkflow(projectId, issueTypeId);
    }

    private IssueChangeHolder moveIssueDetails(MutableIssue oldIssue, MutableIssue newIssue, BulkEditBean bulkEditBean) throws WorkflowException {
        Issue parentIssue;
        JiraWorkflow originalWorkflow;
        Project targetProject;
        DefaultIssueChangeHolder issueChangeHolder = new DefaultIssueChangeHolder();
        Project currentProject = oldIssue.getProjectObject();
        if (!currentProject.equals(targetProject = bulkEditBean.getTargetProject())) {
            issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "project", currentProject.getId().toString(), currentProject.getName(), targetProject.getId().toString(), targetProject.getName()));
            issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "Key", null, oldIssue.getKey(), null, newIssue.getKey()));
        }
        if (!(originalWorkflow = this.workflowManager.getWorkflow((Issue)oldIssue)).equals(bulkEditBean.getTargetWorkflow())) {
            issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "Workflow", oldIssue.getWorkflowId().toString(), originalWorkflow.getName(), newIssue.getWorkflowId().toString(), bulkEditBean.getTargetWorkflow().getName()));
            Status originalStatus = oldIssue.getStatusObject();
            Status newStatus = newIssue.getStatusObject();
            if (originalStatus != null && !originalStatus.equals(newStatus)) {
                issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "status", originalStatus.getId(), originalStatus.getName(), newStatus.getId(), newStatus.getName()));
            }
        }
        Map modifiedFields = newIssue.getModifiedFields();
        for (String fieldId : modifiedFields.keySet()) {
            if (!this.fieldManager.isOrderableField(fieldId)) continue;
            OrderableField field = this.fieldManager.getOrderableField(fieldId);
            if (bulkEditBean.getRetainValues() != null && bulkEditBean.getRetainValues().contains(fieldId)) {
                FieldLayout targetFieldLayout = bulkEditBean.getTargetFieldLayoutForType(bulkEditBean.getTargetIssueType().getId());
                if (!field.needsMove((Collection)EasyList.build((Object)oldIssue), (Issue)newIssue, targetFieldLayout.getFieldLayoutItem(field)).getResult()) continue;
                field.updateValue(targetFieldLayout.getFieldLayoutItem(field), (Issue)newIssue, (ModifiedValue)modifiedFields.get(fieldId), (IssueChangeHolder)issueChangeHolder);
                continue;
            }
            FieldLayoutItem fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(newIssue.getProjectObject(), newIssue.getIssueTypeId()).getFieldLayoutItem(field);
            field.updateValue(fieldLayoutItem, (Issue)newIssue, (ModifiedValue)modifiedFields.get(fieldId), (IssueChangeHolder)issueChangeHolder);
        }
        if (oldIssue.getIssueType().isSubTask() && !newIssue.getIssueType().isSubTask()) {
            parentIssue = oldIssue.getParentObject();
            if (parentIssue != null) {
                issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "Parent", parentIssue.getId().toString(), parentIssue.getKey(), null, null));
            }
        } else if (!oldIssue.getIssueType().isSubTask() && newIssue.getIssueType().isSubTask()) {
            parentIssue = newIssue.getParentObject();
            if (parentIssue != null) {
                issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "Parent", null, null, parentIssue.getId().toString(), parentIssue.getKey()));
            }
        } else if (oldIssue.getIssueType().isSubTask() && newIssue.getIssueType().isSubTask() && !Optional.ofNullable(oldIssue.getParentId()).equals(Optional.ofNullable(newIssue.getParentId()))) {
            Optional<Issue> newParentIssue = Optional.ofNullable(newIssue.getParentObject());
            Optional<Issue> oldParentIssue = Optional.ofNullable(oldIssue.getParentObject());
            if (oldParentIssue.isPresent() || newParentIssue.isPresent()) {
                issueChangeHolder.addChangeItem(new ChangeItemBean("jira", "Parent", (String)oldParentIssue.map(issue -> issue.getId().toString()).orElse(null), (String)oldParentIssue.map(issue -> issue.getKey()).orElse(null), (String)newParentIssue.map(issue -> issue.getId().toString()).orElse(null), (String)newParentIssue.map(issue -> issue.getKey()).orElse(null)));
            }
        }
        this.addChangedIssueSecurityLevel((IssueChangeHolder)issueChangeHolder, (Issue)oldIssue, newIssue);
        newIssue.resetModifiedFields();
        return issueChangeHolder;
    }

    private void addChangedIssueSecurityLevel(IssueChangeHolder changeHolder, Issue oldIssue, MutableIssue newIssue) {
        Long newSecurityLevelId = newIssue.getSecurityLevelId();
        Long oldSecurityLevelId = oldIssue.getSecurityLevelId();
        if (!this.isSecurityLevelEqual(oldSecurityLevelId, newSecurityLevelId)) {
            changeHolder.addChangeItem(new ChangeItemBean("jira", "security", oldSecurityLevelId == null ? null : oldSecurityLevelId.toString(), oldIssue.getSecurityLevel() == null ? null : oldIssue.getSecurityLevel().getString("name"), newSecurityLevelId == null ? null : newSecurityLevelId.toString(), newIssue.getSecurityLevel() == null ? null : newIssue.getSecurityLevel().getString("name")));
        }
    }

    private boolean isSecurityLevelEqual(Long oldSecurityLevelId, Long newSecurityLevelId) {
        if (oldSecurityLevelId == null) {
            oldSecurityLevelId = 0L;
        }
        if (newSecurityLevelId == null) {
            newSecurityLevelId = 0L;
        }
        return oldSecurityLevelId.equals(newSecurityLevelId);
    }

    @VisibleForTesting
    void dispatchEvents(Issue newIssue, GenericValue updateLog, IssueChangeHolder issueChangeHolder, BulkEditBean bulkEditBean, ApplicationUser applicationUser, boolean issueProjectMoved) {
        if (updateLog != null && !issueChangeHolder.getChangeItems().isEmpty()) {
            boolean sendMail = bulkEditBean.isSendBulkNotification();
            Long eventTypeId = issueProjectMoved ? EventType.ISSUE_MOVED_ID : EventType.ISSUE_UPDATED_ID;
            this.issueEventManager.dispatchRedundantEvent(eventTypeId, newIssue, applicationUser, updateLog, sendMail, issueChangeHolder.isSubtasksUpdated());
            IssueEventBundle issueEventBundle = this.issueEventBundleFactory.createIssueUpdateEventBundle(newIssue, updateLog, IssueChangeHolderTransformer.toIssueUpdateBean(issueChangeHolder, eventTypeId, applicationUser, sendMail), applicationUser);
            this.issueEventManager.dispatchEvent(issueEventBundle);
        }
    }

    private MutableIssue getIssueObject(GenericValue issue) {
        return this.issueFactory.getIssue(issue);
    }

    private static /* synthetic */ boolean lambda$validateParentIssue$2(Issue parentIssue, Issue issue) {
        return issue.getKey().equals(parentIssue.getKey());
    }
}

