/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit;

import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOption;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.LongIdsValueHolder;
import com.atlassian.jira.issue.fields.OrderableField;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class AbstractBulkEditMultiSelectFieldOption
implements BulkEditMultiSelectFieldOption {
    public static final String VALUES_SEPARATOR = ", ";

    public Map<String, Object> getFieldValuesMap(Issue issue, OrderableField field, Map<String, Object> fieldValuesHolder) {
        return fieldValuesHolder;
    }

    public boolean validateOperation(OrderableField field, Map<String, Object> fieldValuesHolder) {
        if (fieldValuesHolder.get(field.getId()) instanceof LongIdsValueHolder) {
            return !((LongIdsValueHolder)fieldValuesHolder.get(field.getId())).getValuesToAdd().isEmpty() || ((LongIdsValueHolder)fieldValuesHolder.get(field.getId())).size() > 0;
        }
        return ((Collection)fieldValuesHolder.get(field.getId())).size() > 0;
    }

    public String getFieldValuesToAdd(OrderableField field, Map<String, Object> fieldValuesHolder) {
        Set<String> valuesToAdd;
        if (fieldValuesHolder.get(field.getId()) instanceof LongIdsValueHolder && !(valuesToAdd = LongIdsValueHolder.fromFieldValuesHolder(field.getId(), fieldValuesHolder).getValuesToAdd()).isEmpty()) {
            StringBuilder resultString = new StringBuilder();
            for (String value : valuesToAdd) {
                resultString.append(value).append(VALUES_SEPARATOR);
            }
            return resultString.toString().substring(0, resultString.length() - VALUES_SEPARATOR.length());
        }
        return "";
    }

    private String getNewValuePrefixForField(OrderableField field) {
        if (field.getId().equals("components") || field.getId().equals("versions") || field.getId().equals("fixVersions")) {
            return "nv_";
        }
        return "";
    }
}

