/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;

public class UserSearchUtilities {
    static final Collection<String> SEPARATORS = ImmutableList.of((Object)" ", (Object)"@", (Object)".", (Object)"-", (Object)"\"", (Object)",", (Object)"'", (Object)"(");
    public static final String SEPARATORS_STRING = StringUtils.join(SEPARATORS.iterator(), (String)"");

    static Collection<SearchRestriction> userSearchTermRestrictions(String query, Iterable<Property<String>> searchFields) {
        Assertions.notNull((String)"query", (Object)query);
        Assertions.containsNoNulls((String)"searchFields", searchFields);
        LinkedHashSet terms = Sets.newLinkedHashSet();
        searchFields.forEach(key -> terms.add(new TermRestriction(key, MatchMode.STARTS_WITH, (Object)query)));
        return terms;
    }

    static Predicate<String> createUserMatchPredicate(String query) {
        Assertions.notNull((String)"query", (Object)query);
        String lowercasedQuery = query.toLowerCase();
        if (lowercasedQuery.isEmpty()) {
            return Objects::nonNull;
        }
        char firstLowercaseQueryChar = lowercasedQuery.charAt(0);
        return userPart -> {
            String currentPart = userPart;
            while (currentPart != null) {
                if (lowercasedQuery.length() > currentPart.length()) {
                    return false;
                }
                if (currentPart.substring(0, 1).toLowerCase().charAt(0) == firstLowercaseQueryChar && lowercasedQuery.equals(currentPart.substring(0, lowercasedQuery.length()).toLowerCase())) {
                    return true;
                }
                String[] tokens = StringUtils.splitPreserveAllTokens((String)currentPart, (String)SEPARATORS_STRING, (int)2);
                currentPart = tokens.length == 2 ? tokens[1] : null;
            }
            return false;
        };
    }
}

