/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import com.google.common.collect.ImmutableSet;
import java.io.Reader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.util.Version;

public class UserNameAnalyzer
extends ReusableAnalyzerBase {
    private static final Set<Integer> SEPARATOR_CODE_POINTS = UserSearchUtilities.SEPARATORS.stream().map(separator -> Character.codePointAt(separator, 0)).collect(Collectors.toSet());
    private final Set<Integer> separatorCodePoints;

    public static UserNameAnalyzer forDefaultSeparators() {
        return new UserNameAnalyzer(SEPARATOR_CODE_POINTS);
    }

    public UserNameAnalyzer(Set<Integer> separatorCodePoints) {
        this.separatorCodePoints = ImmutableSet.copyOf(separatorCodePoints);
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader aReader) {
        CharTokenizer source = new CharTokenizer(Version.LUCENE_33, aReader){

            protected boolean isTokenChar(int c) {
                return !UserNameAnalyzer.this.separatorCodePoints.contains(c);
            }
        };
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)new LowerCaseFilter(Version.LUCENE_33, (TokenStream)source));
    }
}

