/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.jira.bc.user.search.UserId;
import com.atlassian.jira.bc.user.search.UserIndexer;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.http.annotation.GuardedBy;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class DirectoryUserIndexer
implements UserIndexer {
    private static final int MAX_TASKS_PER_THREAD = 16;
    private final Directory directory;
    @GuardedBy(value="searcherLock")
    private IndexSearcher indexSearcher;
    private IndexWriter indexWriter;
    private final ReadWriteLock searcherLock = new ReentrantReadWriteLock();
    private volatile boolean initialReindexPerformed = false;

    public DirectoryUserIndexer(Directory directory, Analyzer analyzer, Analyzer exactMatchAnalyzer) {
        this.directory = directory;
        IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_33, (Analyzer)new PerFieldAnalyzerWrapper(analyzer, (Map)ImmutableMap.of((Object)EXACT_DISPLAY_NAME, (Object)exactMatchAnalyzer, (Object)EXACT_EMAIL, (Object)exactMatchAnalyzer, (Object)EXACT_USER_NAME, (Object)exactMatchAnalyzer)));
        try {
            this.indexWriter = new IndexWriter(directory, config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void replaceAllUsers(Consumer<Consumer<OfBizUser>> allUsersConsumerMaker) {
        try {
            this.indexWriter.deleteAll();
            int threadCount = Runtime.getRuntime().availableProcessors();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(threadCount, threadCount, 1L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(threadCount * 16), new ThreadFactoryBuilder().setNameFormat("directory-user-indexer-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());
            allUsersConsumerMaker.accept(user -> executor.submit(() -> {
                Document document = this.translate((OfBizUser)user);
                try {
                    this.indexWriter.addDocument(document);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executor, (long)1L, (TimeUnit)TimeUnit.HOURS);
            this.indexWriter.commit();
            this.initialReindexPerformed = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.refreshSearcher();
    }

    private void refreshSearcher() {
        try {
            this.searcherLock.writeLock().lock();
            if (this.indexSearcher != null) {
                IndexReader reopenedReader;
                IndexReader currentReader = this.indexSearcher.getIndexReader();
                if (currentReader != (reopenedReader = this.indexSearcher.getIndexReader().reopen())) {
                    this.indexSearcher = new IndexSearcher(reopenedReader);
                    currentReader.close();
                }
            } else {
                this.indexSearcher = new IndexSearcher(this.directory);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.searcherLock.writeLock().unlock();
        }
    }

    @Override
    public void index(OfBizUser ... users) {
        try {
            this.indexWriter.addDocuments((Collection)Stream.of(users).map(this::translate).collect(Collectors.toList()));
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.refreshSearcher();
    }

    @Override
    public void deindex(UserId ... userIds) {
        try {
            this.indexWriter.deleteDocuments((Query[])Stream.of(userIds).map(this::translate).toArray(Query[]::new));
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.refreshSearcher();
    }

    @Override
    public void deindexById(long ... internalUserIds) {
        try {
            this.indexWriter.deleteDocuments((Query[])LongStream.of(internalUserIds).mapToObj(this::translateInternalUserId).toArray(Query[]::new));
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.refreshSearcher();
    }

    @Override
    public void deindexByUserName(String ... userNames) {
        try {
            this.indexWriter.deleteDocuments((Query[])Stream.of(userNames).map(this::translateUserName).toArray(Query[]::new));
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.refreshSearcher();
    }

    private Query translateUserName(String userName) {
        BooleanQuery id = new BooleanQuery();
        id.add((Query)new TermQuery(new Term(EXACT_USER_NAME, userName)), BooleanClause.Occur.MUST);
        return id;
    }

    private Query translateInternalUserId(long internalUserId) {
        BooleanQuery id = new BooleanQuery();
        id.add((Query)new TermQuery(new Term("internal_id", String.valueOf(internalUserId))), BooleanClause.Occur.MUST);
        return id;
    }

    private Query translate(UserId userId) {
        BooleanQuery id = new BooleanQuery();
        id.add((Query)new TermQuery(new Term(EXACT_USER_NAME, userId.getName())), BooleanClause.Occur.MUST);
        id.add((Query)new TermQuery(new Term("directory_id", String.valueOf(userId.getDirectoryId()))), BooleanClause.Occur.MUST);
        return id;
    }

    @Override
    public List<User> search(Query query, int skip, int limit, Sort sort) {
        return this.internalSearch(() -> {
            try {
                TopFieldCollector collector = TopFieldCollector.create((Sort)sort, (int)(skip + limit), (boolean)true, (boolean)false, (boolean)false, (boolean)false);
                this.indexSearcher.search(query, (Collector)collector);
                return collector.topDocs(skip, limit);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<User> internalSearch(Supplier<TopDocs> docsSupplier) {
        try {
            this.searcherLock.readLock().lock();
            IndexSearcher indexSearcher = this.getIndexSearcher().orElseThrow(() -> new RuntimeException("Searcher not available at this moment"));
            TopDocs docs = docsSupplier.get();
            List<User> list = ImmutableList.copyOf((Object[])docs.scoreDocs).stream().map(scoreDoc -> {
                try {
                    return indexSearcher.doc(scoreDoc.doc);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).map(doc -> ImmutableUser.newUser().active(Boolean.valueOf(doc.get(ACTIVE)).booleanValue()).directoryId(Long.valueOf(doc.get("directory_id")).longValue()).displayName(doc.get(DISPLAY_NAME)).emailAddress(doc.get(EMAIL)).name(doc.get(USER_NAME)).toUser()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.searcherLock.readLock().unlock();
        }
    }

    private Optional<IndexSearcher> getIndexSearcher() {
        if (this.initialReindexPerformed) {
            return Optional.of(this.indexSearcher);
        }
        return Optional.empty();
    }

    private Document translate(OfBizUser user) {
        Document document = new Document();
        document.add((Fieldable)new Field(ACTIVE, Boolean.toString(user.isActive()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field("directory_id", String.valueOf(user.getDirectoryId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field(DISPLAY_NAME, user.getDisplayName(), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field(EXACT_DISPLAY_NAME, user.getDisplayName(), Field.Store.NO, Field.Index.ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field(EMAIL, user.getEmailAddress(), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field(EXACT_EMAIL, user.getEmailAddress(), Field.Store.NO, Field.Index.ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field(USER_NAME, user.getName(), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field(EXACT_USER_NAME, user.getName(), Field.Store.NO, Field.Index.ANALYZED_NO_NORMS));
        document.add((Fieldable)new Field("internal_id", String.valueOf(user.getId()), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS));
        return document;
    }
}

