/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentComparator;
import com.atlassian.jira.bc.project.component.ProjectComponentStore;
import com.atlassian.jira.cache.CacheAdapter;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@TenantInfo(value=TenantAware.UNRESOLVED)
@EventComponent
public class CachingProjectComponentStore
implements ProjectComponentStore,
Startable {
    private static final String UPDATE_LOCK_NAME = CachingProjectComponentStore.class.getName() + ".updateLock";
    static final String PROJECT_COMPONENTS_CACHE_FEATURE = "jira.jvc." + CachingProjectComponentStore.class.getName() + ".projectToComponents";
    static final String COMPONENT_COMPONENTS_CACHE_FEATURE = "jira.jvc." + CachingProjectComponentStore.class.getName() + ".componentIdToComponent";
    private ClusterLock updateLock;
    @TenantInfo(value=TenantAware.TENANTED)
    private final CacheAdapter<Long, Optional<ProjectComponent>> componentIdToComponentMap;
    @TenantInfo(value=TenantAware.TENANTED)
    private final CacheAdapter<Long, Collection<ProjectComponent>> projectIdToComponentsMap;
    private final ProjectComponentStore delegateStore;
    private final ClusterLockService clusterLockService;

    public CachingProjectComponentStore(ProjectComponentStore delegateStore, ClusterLockService clusterLockService, SwitchingCacheFactory vCacheFactory) {
        this.delegateStore = delegateStore;
        this.clusterLockService = clusterLockService;
        this.componentIdToComponentMap = vCacheFactory.buildSwitchingRequestCache(CachingProjectComponentStore.class.getName() + ".componentIdToComponentMap", Optional.empty(), COMPONENT_COMPONENTS_CACHE_FEATURE);
        this.projectIdToComponentsMap = vCacheFactory.buildSwitchingRequestCache(CachingProjectComponentStore.class.getName() + ".projectIdToComponentsMap", Optional.empty(), PROJECT_COMPONENTS_CACHE_FEATURE);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.projectIdToComponentsMap.removeAll();
        this.componentIdToComponentMap.removeAll();
    }

    public void start() {
        this.updateLock = this.clusterLockService.getLockForName(UPDATE_LOCK_NAME);
    }

    @Override
    public MutableProjectComponent find(Long id) throws EntityNotFoundException {
        Assertions.notNull((String)"id", (Object)id);
        return ((Optional)this.componentIdToComponentMap.get(id, new ComponentByIdCacheLoader(id))).map(MutableProjectComponent::copy).orElseThrow(() -> new EntityNotFoundException("The component with id '" + id + "' does not exist."));
    }

    @Override
    public ProjectComponent getProjectComponent(Long projectComponentId) {
        Assertions.notNull((String)"id", (Object)projectComponentId);
        Optional cacheObject = (Optional)this.componentIdToComponentMap.get(projectComponentId, new ComponentByIdCacheLoader(projectComponentId));
        return cacheObject.orElse(null);
    }

    @Override
    public Collection<MutableProjectComponent> findAllForProject(Long projectId) {
        Collection components = (Collection)this.projectIdToComponentsMap.get(projectId, new ComponentByProjectCacheLoader(projectId));
        return MutableProjectComponent.copy((Collection)components);
    }

    @Override
    public MutableProjectComponent findByComponentName(Long projectId, String componentName) throws EntityNotFoundException {
        Collection<MutableProjectComponent> components = this.findAllForProject(projectId);
        for (MutableProjectComponent c : components) {
            if (!c.getName().equals(componentName)) continue;
            return c;
        }
        throw new EntityNotFoundException("The project with id '" + projectId + "' is not associated with a component with the name '" + componentName + "'.");
    }

    @Override
    public Collection<MutableProjectComponent> findByComponentNameCaseInSensitive(String componentName) {
        return this.findAll().stream().filter(component -> component.getName().equalsIgnoreCase(componentName)).map(MutableProjectComponent::copy).collect(Collectors.toList());
    }

    @Override
    public Long findProjectIdForComponent(Long componentId) throws EntityNotFoundException {
        return ((ProjectComponent)((Optional)this.componentIdToComponentMap.get(componentId, new ComponentByIdCacheLoader(componentId))).orElseThrow(() -> new EntityNotFoundException("The component with the id '" + componentId + "' does not exist."))).getProjectId();
    }

    @Override
    public boolean containsName(String name, Long projectId) {
        if (projectId == null) {
            throw new IllegalArgumentException("Component project ID can not be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Component name can not be null!");
        }
        Collection components = (Collection)this.projectIdToComponentsMap.get(projectId, new ComponentByProjectCacheLoader(projectId));
        return CachingProjectComponentStore.containsNameIgnoreCase(components, name);
    }

    private static boolean containsNameIgnoreCase(Collection<ProjectComponent> components, String name) {
        return components != null && components.stream().filter(component -> name.equalsIgnoreCase(component.getName())).findAny().isPresent();
    }

    @Override
    public MutableProjectComponent store(MutableProjectComponent component) throws EntityNotFoundException, DataAccessException {
        MutableProjectComponent copy = MutableProjectComponent.copy((ProjectComponent)component);
        MutableProjectComponent newComponent = copy.getId() == null ? this.insert(copy) : this.update(copy);
        return newComponent;
    }

    @Override
    public void delete(Long componentId) throws EntityNotFoundException {
        MutableProjectComponent component = null;
        if (componentId != null) {
            component = this.delegateStore.find(componentId);
        }
        this.delegateStore.delete(componentId);
        if (componentId != null) {
            this.componentIdToComponentMap.remove(componentId);
        }
        if (component != null) {
            this.projectIdToComponentsMap.remove(component.getProjectId());
        }
    }

    @Override
    public void deleteAllComponents(@Nonnull Long projectId) {
        this.delegateStore.deleteAllComponents(projectId);
        this.componentIdToComponentMap.removeAll();
        this.projectIdToComponentsMap.remove(projectId);
    }

    @Override
    public Collection findComponentsBylead(String userKey) {
        ArrayList<MutableProjectComponent> leadComponents = new ArrayList<MutableProjectComponent>();
        Collection<ProjectComponent> components = this.findAll();
        for (ProjectComponent component : components) {
            MutableProjectComponent projectComponent = (MutableProjectComponent)component;
            if (projectComponent == null || !TextUtils.stringSet((String)projectComponent.getLead()) || !projectComponent.getLead().equals(userKey)) continue;
            leadComponents.add(projectComponent);
        }
        return leadComponents;
    }

    @Override
    public Collection<ProjectComponent> findAll() {
        ProjectManager projectManager = ComponentAccessor.getProjectManager();
        ArrayList<ProjectComponent> components = new ArrayList<ProjectComponent>();
        List allProjects = projectManager.getProjectObjects();
        for (Project project : allProjects) {
            components.addAll((Collection)this.projectIdToComponentsMap.get(project.getId(), new ComponentByProjectCacheLoader(project.getId())));
        }
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private MutableProjectComponent insert(MutableProjectComponent component) {
        this.updateLock.lock();
        try {
            MutableProjectComponent mutableProjectComponent;
            String name = component.getName();
            if (this.containsName(name, component.getProjectId())) {
                throw this.createIllegalArgumentExceptionForName(name);
            }
            try {
                mutableProjectComponent = component = this.delegateStore.store(component);
            }
            catch (EntityNotFoundException e) {
                MutableProjectComponent mutableProjectComponent2 = null;
                this.componentIdToComponentMap.remove(component.getId());
                this.projectIdToComponentsMap.remove(component.getProjectId());
                this.updateLock.unlock();
                return mutableProjectComponent2;
                {
                    catch (Throwable throwable) {
                        this.componentIdToComponentMap.remove(component.getId());
                        this.projectIdToComponentsMap.remove(component.getProjectId());
                        throw throwable;
                    }
                }
            }
            this.componentIdToComponentMap.remove(component.getId());
            this.projectIdToComponentsMap.remove(component.getProjectId());
            return mutableProjectComponent;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutableProjectComponent update(MutableProjectComponent component) throws EntityNotFoundException, DataAccessException {
        this.updateLock.lock();
        try {
            MutableProjectComponent old = this.find(component.getId());
            if (!old.equalsName(component) && this.containsName(component.getName(), component.getProjectId())) {
                throw new IllegalArgumentException("New component name '" + component.getName() + "' is not unique!");
            }
            this.delegateStore.store(component);
            this.updateCache((ProjectComponent)component);
            MutableProjectComponent mutableProjectComponent = component;
            return mutableProjectComponent;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    private void updateCache(ProjectComponent component) {
        Long id = component.getId();
        Long projectId = component.getProjectId();
        this.componentIdToComponentMap.remove(id);
        this.projectIdToComponentsMap.remove(projectId);
    }

    private IllegalArgumentException createIllegalArgumentExceptionForName(String name) {
        return new IllegalArgumentException("Component name = '" + name + "' is not unique");
    }

    private Collection<ProjectComponent> sortByComponentNames(Collection<MutableProjectComponent> components) {
        ArrayList<MutableProjectComponent> componentList = new ArrayList<MutableProjectComponent>(components);
        Collections.sort(componentList, ProjectComponentComparator.INSTANCE);
        return componentList;
    }

    private class ComponentByProjectCacheLoader
    implements Supplier<Collection<ProjectComponent>> {
        private final Long projectId;

        ComponentByProjectCacheLoader(Long projectId) {
            this.projectId = projectId;
        }

        @Override
        public Collection<ProjectComponent> get() {
            return CachingProjectComponentStore.this.sortByComponentNames(CachingProjectComponentStore.this.delegateStore.findAllForProject(this.projectId));
        }
    }

    private class ComponentByIdCacheLoader
    implements Supplier<Optional<ProjectComponent>> {
        private final Long id;

        ComponentByIdCacheLoader(Long id) {
            this.id = id;
        }

        @Override
        public Optional<ProjectComponent> get() {
            try {
                return Optional.of(CachingProjectComponentStore.this.delegateStore.find(this.id));
            }
            catch (EntityNotFoundException e) {
                return Optional.empty();
            }
        }
    }
}

