/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.CloneIssueCommand;
import com.atlassian.jira.bc.issue.CloneIssueTaskContext;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.NotRequiredFieldScreenRenderLayoutItem;
import com.atlassian.jira.bc.issue.events.WorkflowManualTransitionExecutionEvent;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.concurrent.BarrierFactory;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.IssueFieldsCharacterLimitExceededException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.UpdateIssueRequest;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ResolutionSystemField;
import com.atlassian.jira.issue.fields.SummarySystemField;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.WorkflowIssueOperationImpl;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.TransitionOptions;
import com.atlassian.jira.workflow.WorkflowFunctionUtils;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowProgressAware;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIssueService
implements IssueService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIssueService.class);
    private final IssueFactory issueFactory;
    private final IssueCreationHelperBean issueCreationHelperBean;
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final WorkflowManager workflowManager;
    private final IssueWorkflowManager issueWorkflowManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final EventPublisher eventPublisher;
    private final IssuePropertyService issuePropertyService;
    private final ApplicationProperties applicationProperties;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkManager issueLinkManager;
    private final RemoteIssueLinkManager remoteIssueLinkManager;
    private final AttachmentManager attachmentManager;
    private final SubTaskManager subTaskManager;
    private final CustomFieldManager customFieldManager;
    private final TaskManager taskManager;
    private final BarrierFactory barrierFactory;

    public DefaultIssueService(IssueFactory issueFactory, IssueCreationHelperBean issueCreationHelperBean, FieldManager fieldManager, IssueManager issueManager, PermissionManager permissionManager, FieldScreenRendererFactory fieldScreenRendererFactory, WorkflowManager workflowManager, IssueWorkflowManager issueWorkflowManager, FieldLayoutManager fieldLayoutManager, FieldConfigSchemeManager fieldConfigSchemeManager, EventPublisher eventPublisher, IssuePropertyService issuePropertyService, ApplicationProperties applicationProperties, IssueLinkTypeManager issueLinkTypeManager, IssueLinkManager issueLinkManager, RemoteIssueLinkManager remoteIssueLinkManager, AttachmentManager attachmentManager, SubTaskManager subTaskManager, CustomFieldManager customFieldManager, TaskManager taskManager, BarrierFactory barrierFactory) {
        this.issueFactory = issueFactory;
        this.issueCreationHelperBean = issueCreationHelperBean;
        this.fieldManager = fieldManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.workflowManager = workflowManager;
        this.issueWorkflowManager = issueWorkflowManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.eventPublisher = eventPublisher;
        this.issuePropertyService = issuePropertyService;
        this.applicationProperties = applicationProperties;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkManager = issueLinkManager;
        this.remoteIssueLinkManager = remoteIssueLinkManager;
        this.attachmentManager = attachmentManager;
        this.subTaskManager = subTaskManager;
        this.customFieldManager = customFieldManager;
        this.taskManager = taskManager;
        this.barrierFactory = barrierFactory;
    }

    public IssueService.IssueResult getIssue(@Nullable ApplicationUser user, Long issueId) {
        I18nHelper i18n = this.getI18n(user);
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        return new IssueService.IssueResult(this.getIssue(user, issue, i18n, (ErrorCollection)errors), (ErrorCollection)errors);
    }

    public IssueService.IssueResult getIssue(@Nullable ApplicationUser user, String issueKey) {
        I18nHelper i18n = this.getI18n(user);
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        return new IssueService.IssueResult(this.getIssue(user, issue, i18n, (ErrorCollection)errors), (ErrorCollection)errors);
    }

    public IssueService.CreateValidationResult validateCreate(ApplicationUser user, IssueInputParameters issueInputParameters) {
        if (issueInputParameters == null) {
            throw new IllegalArgumentException("Can not validate issue creation with a null IssueInputParameters.");
        }
        MutableIssue issue = this.constructNewIssue();
        return this.validateCreate(user, issue, issueInputParameters);
    }

    public IssueService.CreateValidationResult validateSubTaskCreate(ApplicationUser user, Long parentId, IssueInputParameters issueInputParameters) {
        MutableIssue issue = this.constructNewIssue();
        issue.setParentId(parentId);
        return this.validateCreate(user, issue, issueInputParameters);
    }

    public IssueService.IssueResult create(ApplicationUser user, IssueService.CreateValidationResult createValidationResult) {
        return this.create(user, createValidationResult, null);
    }

    public IssueService.IssueResult create(ApplicationUser user, IssueService.CreateValidationResult createValidationResult, String initialWorkflowActionName) {
        if (createValidationResult == null) {
            throw new IllegalArgumentException("You can not create an issue with a null validation result.");
        }
        if (!createValidationResult.isValid()) {
            throw new IllegalStateException("You can not create an issue with an invalid validation result.");
        }
        if (createValidationResult.getIssue() == null) {
            throw new IllegalArgumentException("You can not create a null issue.");
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        MutableIssue issue = createValidationResult.getIssue();
        fields.put("issue", issue);
        MutableIssue originalIssue = this.issueManager.getIssueObject(issue.getId());
        fields.put("originalissueobject", originalIssue);
        fields.put("pkey", issue.getProjectObject().getKey());
        if (initialWorkflowActionName != null) {
            fields.put("submitbutton", initialWorkflowActionName);
        }
        fields.put("issueProperties", createValidationResult.getProperties());
        try {
            GenericValue newIssueGV = this.issueManager.createIssue(user, fields);
            return new IssueService.IssueResult(this.issueFactory.getIssue(newIssueGV));
        }
        catch (IssueFieldsCharacterLimitExceededException e) {
            log.error("Exception occurred when creating issue", (Throwable)e);
            return this.handleIssueFieldsCharacterLimitExceeded(this.getI18n(user), e);
        }
        catch (CreateException e) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            this.handleCreateException(this.getI18n(user), (ErrorCollection)errors, e);
            return new IssueService.IssueResult(null, (ErrorCollection)errors);
        }
    }

    public IssueService.UpdateValidationResult validateUpdate(ApplicationUser user, Long issueId, IssueInputParameters issueInputParameters) {
        if (issueInputParameters == null) {
            throw new IllegalArgumentException("You must provide a non-null issueInputParameters to update an issue.");
        }
        I18nHelper i18n = this.getI18n(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Map<String, Object> fieldValuesHolder = this.cloneFieldValuesHolder(issueInputParameters);
        Map properties = issueInputParameters.properties();
        HistoryMetadata historyMetadata = issueInputParameters.getHistoryMetadata();
        if (issueId == null) {
            errors.addErrorMessage(i18n.getText("issue.service.update.issue.is.null"));
            return new IssueService.UpdateValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, historyMetadata, properties);
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            errors.addErrorMessage(i18n.getText("issue.service.update.issue.is.null"));
            return new IssueService.UpdateValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, historyMetadata, properties);
        }
        if (!this.hasPermissionToEdit(user, (Issue)issue, i18n, (ErrorCollection)errors)) {
            return new IssueService.UpdateValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, historyMetadata, properties);
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        MutableIssue copiedIssue = this.copyIssue(issue);
        MutableIssue updatedIssue = this.validateAndUpdateIssueFromFields(user, copiedIssue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errorCollection, i18n, this.getUpdateFieldScreenRenderer((Issue)issue), true, null);
        this.validIssueProperties(issueInputParameters, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            updatedIssue = null;
            errors.addErrorCollection((ErrorCollection)errorCollection);
        }
        return new IssueService.UpdateValidationResult(updatedIssue, (ErrorCollection)errors, fieldValuesHolder, historyMetadata, properties);
    }

    public IssueService.IssueResult update(ApplicationUser user, IssueService.UpdateValidationResult issueValidationResult) {
        return this.update(user, issueValidationResult, EventDispatchOption.ISSUE_UPDATED, true);
    }

    public IssueService.IssueResult update(ApplicationUser user, IssueService.UpdateValidationResult issueValidationResult, EventDispatchOption eventDispatchOption, boolean sendMail) {
        MutableIssue updatedIssue;
        if (issueValidationResult == null) {
            throw new IllegalArgumentException("You can not update an issue with a null validation result.");
        }
        if (!issueValidationResult.isValid()) {
            throw new IllegalStateException("You can not update an issue with an invalid validation result.");
        }
        MutableIssue issue = issueValidationResult.getIssue();
        if (eventDispatchOption == null) {
            throw new IllegalArgumentException("You can not update an issue with a null EventDispatchOption.");
        }
        if (issue == null) {
            throw new IllegalArgumentException("You can not update a null issue.");
        }
        try {
            UpdateIssueRequest updateIssueRequest = UpdateIssueRequest.builder().eventDispatchOption(eventDispatchOption).sendMail(sendMail).historyMetadata(issueValidationResult.getHistoryMetadata()).issueProperties(issueValidationResult.getProperties()).build();
            updatedIssue = (MutableIssue)this.issueManager.updateIssue(user, issue, updateIssueRequest);
        }
        catch (IssueFieldsCharacterLimitExceededException e) {
            log.error("Exception occurred editing issue: " + (Object)((Object)e), (Throwable)e);
            return this.handleIssueFieldsCharacterLimitExceeded(this.getI18n(user), e);
        }
        catch (RuntimeException e) {
            log.error("Exception occurred editing issue: " + e, (Throwable)e);
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(this.getI18n(user).getText("admin.errors.issues.exception.occured", (Object)e));
            return new IssueService.IssueResult(null, (ErrorCollection)errors);
        }
        return new IssueService.IssueResult(updatedIssue);
    }

    private IssueService.IssueResult handleIssueFieldsCharacterLimitExceeded(I18nHelper i18n, IssueFieldsCharacterLimitExceededException e) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        for (String fieldId : e.getInvalidFieldIds()) {
            errors.addError(fieldId, i18n.getText("field.error.text.toolong", (Object)e.getMaxNumberOfCharacters()));
        }
        return new IssueService.IssueResult(null, (ErrorCollection)errors);
    }

    public IssueService.DeleteValidationResult validateDelete(ApplicationUser user, Long issueId) {
        I18nHelper i18n = this.getI18n(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (issueId == null) {
            errors.addErrorMessage(i18n.getText("issue.service.delete.issue.is.null"));
            return new IssueService.DeleteValidationResult(null, (ErrorCollection)errors);
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            errors.addErrorMessage(i18n.getText("issue.service.delete.issue.is.null"));
            return new IssueService.DeleteValidationResult(null, (ErrorCollection)errors);
        }
        if (this.hasPermissionToDelete(user, (Issue)issue, i18n, (ErrorCollection)errors)) {
            return new IssueService.DeleteValidationResult(issue, (ErrorCollection)errors);
        }
        return new IssueService.DeleteValidationResult(null, (ErrorCollection)errors);
    }

    public ErrorCollection delete(ApplicationUser user, IssueService.DeleteValidationResult issueValidationResult) {
        return this.delete(user, issueValidationResult, EventDispatchOption.ISSUE_DELETED, true);
    }

    public ErrorCollection delete(ApplicationUser user, IssueService.DeleteValidationResult issueValidationResult, EventDispatchOption eventDispatchOption, boolean sendMail) {
        if (eventDispatchOption == null) {
            throw new IllegalArgumentException("You can not delete an issue with a null EventDispatchOption.");
        }
        if (issueValidationResult == null) {
            throw new IllegalArgumentException("You can not delete an issue with a null IssueValidationResult.");
        }
        if (!issueValidationResult.isValid()) {
            throw new IllegalStateException("You can not delete an issue with an invalid validation result.");
        }
        if (issueValidationResult.getIssue() == null) {
            throw new IllegalArgumentException("You can not delete a null issue.");
        }
        MutableIssue issue = issueValidationResult.getIssue();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        try {
            this.issueManager.deleteIssue(user, issue, eventDispatchOption, sendMail);
        }
        catch (RemoveException e) {
            log.error("There was an exception while trying to delete the issue '" + issue.getKey() + "'.", (Throwable)e);
            errors.addErrorMessage(this.getI18n(user).getText("issue.service.issue.deletion.error", issue.getKey()));
        }
        return errors;
    }

    public boolean isEditable(Issue issue, ApplicationUser user) {
        return this.issueManager.isEditable(issue, user);
    }

    public IssueService.TransitionValidationResult validateTransition(ApplicationUser user, Long issueId, int actionId, IssueInputParameters issueInputParameters) {
        return this.validateTransition(user, issueId, actionId, issueInputParameters, TransitionOptions.defaults());
    }

    public IssueService.TransitionValidationResult validateTransition(ApplicationUser user, Long issueId, int actionId, IssueInputParameters issueInputParameters, TransitionOptions transitionOptions) {
        MutableIssue updatedIssue;
        if (issueInputParameters == null) {
            throw new IllegalArgumentException("You must provide a non-null issueInputParameters.");
        }
        I18nHelper i18n = this.getI18n(user);
        Map<String, Object> fieldValuesHolder = this.cloneFieldValuesHolder(issueInputParameters);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (issueId == null) {
            errors.addErrorMessage(i18n.getText("issue.service.transition.issue.is.null"));
            return new IssueService.TransitionValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, null, actionId);
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            errors.addErrorMessage(i18n.getText("issue.service.transition.issue.is.null"));
            return new IssueService.TransitionValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, null, actionId);
        }
        String originalAssigneeId = issue.getAssigneeId();
        ActionDescriptor actionDescriptor = this.getActionDescriptor((Issue)issue, actionId);
        if (actionDescriptor == null) {
            errors.addErrorMessage(i18n.getText("issue.service.transition.issue.no.action", String.valueOf(actionId)));
            return new IssueService.TransitionValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, null, actionId);
        }
        if (!this.issueWorkflowManager.isValidAction((Issue)issue, actionId, transitionOptions, user)) {
            errors.addErrorMessage(i18n.getText("issue.service.transition.issue.action.invalid", actionDescriptor.getName(), issue.getKey()));
            return new IssueService.TransitionValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, null, actionId);
        }
        if (StringUtils.isNotEmpty((String)actionDescriptor.getView()) || issueInputParameters.skipScreenCheck()) {
            updatedIssue = this.validateAndUpdateIssueFromFields(user, issue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errors, i18n, this.getTransitionFieldScreenRenderer((Issue)issue, actionDescriptor), false, actionId);
            if (errors.hasAnyErrors()) {
                return new IssueService.TransitionValidationResult(null, (ErrorCollection)errors, fieldValuesHolder, null, actionId);
            }
        } else {
            updatedIssue = issue;
        }
        Map<String, Object> additionalParams = this.createAdditionalParameters(user, fieldValuesHolder, transitionOptions, issueInputParameters.getHistoryMetadata(), originalAssigneeId);
        return new IssueService.TransitionValidationResult(updatedIssue, (ErrorCollection)errors, fieldValuesHolder, additionalParams, actionId);
    }

    public IssueService.IssueResult transition(ApplicationUser user, IssueService.TransitionValidationResult transitionResult) {
        if (transitionResult == null) {
            throw new IllegalArgumentException("You must provide a non-null transition result to transition an issue through workflow.");
        }
        if (!transitionResult.isValid()) {
            throw new IllegalStateException("You can not transition an issue with an invalid validation result.");
        }
        MutableIssue issue = transitionResult.getIssue();
        if (issue == null) {
            throw new IllegalArgumentException("You can not transition a null issue.");
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SimpleWorkflowProgressAware workflowProgressAware = new SimpleWorkflowProgressAware(transitionResult.getActionId(), user, (ErrorCollection)errorCollection, transitionResult.getAdditionInputs(), issue);
        this.workflowManager.doWorkflowAction((WorkflowProgressAware)workflowProgressAware);
        IssueService.IssueResult issueResult = new IssueService.IssueResult(this.issueManager.getIssueObject(issue.getId()), (ErrorCollection)errorCollection);
        this.triggerEventsForManualTransition(issueResult, transitionResult);
        return issueResult;
    }

    private void triggerEventsForManualTransition(IssueService.IssueResult issueResult, IssueService.TransitionValidationResult transitionResult) {
        String projectTypeKey;
        TransitionOptions transitionOptions = TransitionOptions.toTransitionOptions((Map)transitionResult.getAdditionInputs());
        MutableIssue issue = issueResult.getIssue();
        try {
            projectTypeKey = issue.getProjectObject().getProjectTypeKey().getKey();
        }
        catch (NullPointerException e) {
            projectTypeKey = "unknown";
        }
        if (!transitionOptions.isAutomaticTransition()) {
            this.eventPublisher.publish((Object)new WorkflowManualTransitionExecutionEvent(transitionResult.getActionId(), issue.getId(), issue.getProjectId(), issue.getIssueTypeId(), projectTypeKey, issueResult.isValid()));
            Instrumentation.pullCounter(InstrumentationName.WORKFLOW_MANUAL_TRANSITION).incrementAndGet();
        } else {
            Instrumentation.pullCounter(InstrumentationName.WORKFLOW_AUTOMATIC_TRANSITION).incrementAndGet();
        }
    }

    public IssueService.AssignValidationResult validateAssign(ApplicationUser user, Long issueId, String assignee) {
        I18nHelper i18n = this.getI18n(user);
        final HashMap<String, String> fieldValuesHolder = new HashMap<String, String>();
        OrderableField field = (OrderableField)this.fieldManager.getField("assignee");
        fieldValuesHolder.put(field.getId(), assignee);
        OperationContext operationContext = new OperationContext(){

            public Map<String, Object> getFieldValuesHolder() {
                return fieldValuesHolder;
            }

            public IssueOperation getIssueOperation() {
                return IssueOperations.EDIT_ISSUE_OPERATION;
            }
        };
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (issueId == null) {
            errors.addErrorMessage(i18n.getText("issue.service.transition.issue.is.null"));
            return new IssueService.AssignValidationResult(null, (ErrorCollection)errors, assignee);
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        field.validateParams(operationContext, (ErrorCollection)errors, i18n, (Issue)issue, null);
        return new IssueService.AssignValidationResult(issue, (ErrorCollection)errors, assignee);
    }

    public IssueService.IssueResult assign(ApplicationUser user, IssueService.AssignValidationResult assignResult) {
        MutableIssue issue = assignResult.getIssue();
        OrderableField field = (OrderableField)this.fieldManager.getField("assignee");
        FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout((Issue)issue).getFieldLayoutItem(field);
        HashMap<String, String> assigneeFieldHolder = new HashMap<String, String>();
        assigneeFieldHolder.put(field.getId(), assignResult.getAssigneeId());
        field.updateIssue(fieldLayoutItem, issue, assigneeFieldHolder);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            this.issueManager.updateIssue(user, issue, EventDispatchOption.ISSUE_ASSIGNED, true);
        }
        catch (RuntimeException e) {
            log.error("There was an exception while trying to update the issue '" + issue.getKey() + "'.", (Throwable)e);
            errorCollection.addErrorMessage(this.getI18n(user).getText("admin.errors.issues.exception.occured", issue.getKey()));
        }
        return new IssueService.IssueResult(issue, (ErrorCollection)errorCollection);
    }

    public IssueService.CloneValidationResult validateClone(@Nullable ApplicationUser user, Issue issue, final String summary, boolean cloneAttachments, boolean cloneSubTasks, boolean cloneLinks, Map<CustomField, Optional<Boolean>> cloneOptionSelections) {
        I18nHelper i18n = this.getI18n(user);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        OperationContext context = new OperationContext(){

            public Map<String, Object> getFieldValuesHolder() {
                return new FieldValuesHolderImpl((Map<String, ?>)ImmutableMap.of((Object)"summary", (Object)summary));
            }

            public IssueOperation getIssueOperation() {
                return IssueOperations.CREATE_ISSUE_OPERATION;
            }
        };
        if (issue == null) {
            errorCollection.addErrorMessage(i18n.getText("issue.service.issue.wasdeleted"), ErrorCollection.Reason.NOT_FOUND);
        } else if (this.hasPermissionToView(user, issue, i18n, (ErrorCollection)errorCollection) & this.hasPermissionToCreate(user, issue.getProjectObject(), i18n, (ErrorCollection)errorCollection)) {
            SummarySystemField summaryField = (SummarySystemField)this.fieldManager.getOrderableField("summary");
            summaryField.validateParams(context, (ErrorCollection)errorCollection, i18n, issue, null);
        }
        return new IssueService.CloneValidationResult(issue, (ErrorCollection)errorCollection, summary, cloneAttachments, cloneSubTasks, cloneLinks, cloneOptionSelections);
    }

    public IssueService.AsynchronousTaskResult clone(ApplicationUser user, IssueService.CloneValidationResult cloneValidationResult) {
        Issue originalIssue = cloneValidationResult.getIssue();
        I18nHelper i18n = this.getI18n(user);
        String taskName = i18n.getText("cloneissue.task.name", originalIssue.getKey());
        CloneIssueCommand cloneCommand = new CloneIssueCommand(user, originalIssue, cloneValidationResult.getSummary(), cloneValidationResult.isCloneAttachments(), cloneValidationResult.isCloneSubTasks(), cloneValidationResult.isCloneLinks(), cloneValidationResult.getCloneOptionSelections(), this.issueManager, this.issueFactory, this.applicationProperties, this.issueLinkTypeManager, this.issueLinkManager, this.remoteIssueLinkManager, this.attachmentManager, this.subTaskManager, this.permissionManager, this.customFieldManager, log, i18n, this.barrierFactory);
        CloneIssueTaskContext taskContext = new CloneIssueTaskContext(originalIssue.getId());
        TaskDescriptor<CloneIssueCommand.CloneIssueResult> task = this.taskManager.submitTask(cloneCommand, taskName, taskContext, false);
        return new IssueService.AsynchronousTaskResult(task.getTaskId());
    }

    public IssueInputParameters newIssueInputParameters() {
        return new IssueInputParametersImpl();
    }

    public IssueInputParameters newIssueInputParameters(Map<String, String[]> actionParameters) {
        return new IssueInputParametersImpl(actionParameters);
    }

    private void handleCreateException(I18nHelper i18n, ErrorCollection errors, CreateException createException) {
        String errMsg = i18n.getText("admin.errors.issues.error.creating", createException.getMessage());
        Throwable cause = createException.getCause();
        if (cause instanceof InvalidInputException) {
            InvalidInputException inputException = (InvalidInputException)cause;
            this.handleInvalidInputException(errors, inputException);
        } else {
            String genericErrorMessage = i18n.getText("admin.errors.issues.error.creating.generic");
            log.error("Error creating issue: ", (Throwable)createException);
            errors.addErrorMessage(genericErrorMessage);
        }
    }

    private void handleInvalidInputException(ErrorCollection errors, InvalidInputException inputException) {
        for (Object e : inputException.getGenericErrors()) {
            String error = (String)e;
            errors.addErrorMessage(error);
        }
        for (Object object : inputException.getErrors().entrySet()) {
            Map.Entry entry = (Map.Entry)object;
            errors.addError((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Nullable
    MutableIssue validateAndUpdateIssueFromFields(ApplicationUser user, MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, ErrorCollection errorCollection, I18nHelper i18n, FieldScreenRenderer fieldScreenRenderer, boolean updateComment, @Nullable Integer workflowActionId) {
        SimpleErrorCollection localCollection = new SimpleErrorCollection();
        OperationContextImpl operationContext = workflowActionId == null ? new OperationContextImpl((IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION, fieldValuesHolder) : new OperationContextImpl((IssueOperation)new WorkflowIssueOperationImpl(this.workflowManager.getActionDescriptor((Issue)issue, workflowActionId.intValue())), fieldValuesHolder);
        this.validateAndPopulateParams(user, issue, issueInputParameters, fieldValuesHolder, (OperationContext)operationContext, (ErrorCollection)localCollection, i18n, fieldScreenRenderer);
        if (!localCollection.hasAnyErrors()) {
            this.updateIssueFromFields(fieldScreenRenderer, issue, user, fieldValuesHolder, updateComment, issueInputParameters);
        } else {
            issue = null;
            errorCollection.addErrorCollection((ErrorCollection)localCollection);
        }
        return issue;
    }

    IssueService.CreateValidationResult validateCreate(ApplicationUser user, MutableIssue issue, IssueInputParameters issueInputParameters) {
        I18nHelper i18n = this.getI18n(user);
        if (issueInputParameters == null) {
            throw new IllegalArgumentException("You must provide non-null issue input parameters to validate an issue.");
        }
        if (issue == null) {
            throw new IllegalArgumentException("You must provide a non-null issue to validate and populate.");
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Map<String, Object> fieldValuesHolder = this.cloneFieldValuesHolder(issueInputParameters);
        boolean skipLicenceCheck = issueInputParameters.skipLicenceCheck();
        if (skipLicenceCheck || !this.licenseInvalidForIssueCreation(user, (ErrorCollection)errorCollection, i18n)) {
            issue = this.validateAndSetProject(issue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errorCollection, i18n);
            issue = this.validateAndSetIssueType(issue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errorCollection, i18n);
            if (!errorCollection.hasAnyErrors() && this.hasPermissionToCreate(user, issue.getProjectObject(), i18n, (ErrorCollection)errorCollection)) {
                issue = this.validateAndCreateIssueFromFields(user, issue, issueInputParameters, fieldValuesHolder, (ErrorCollection)errorCollection, i18n);
                this.validIssueProperties(issueInputParameters, (ErrorCollection)errorCollection);
            }
        }
        if (errorCollection.hasAnyErrors()) {
            issue = null;
        }
        return new IssueService.CreateValidationResult(issue, (ErrorCollection)errorCollection, fieldValuesHolder, issueInputParameters.properties());
    }

    boolean validIssueProperties(IssueInputParameters issueInputParameters, ErrorCollection errorCollection) {
        issueInputParameters.properties().forEach((key, value) -> {
            EntityPropertyService.PropertyInput ip1 = new EntityPropertyService.PropertyInput(value.toString(), key);
            ErrorCollection result = this.issuePropertyService.validatePropertyInput(ip1);
            errorCollection.addErrorCollection(result);
        });
        return !errorCollection.hasAnyErrors();
    }

    Map<String, Object> cloneFieldValuesHolder(IssueInputParameters issueInputParameters) {
        HashMap<String, Object> clonedFieldValuesHolder = new HashMap<String, Object>();
        clonedFieldValuesHolder.putAll(issueInputParameters.getFieldValuesHolder());
        clonedFieldValuesHolder.put("formToken", issueInputParameters.getFormToken());
        return clonedFieldValuesHolder;
    }

    MutableIssue validateAndCreateIssueFromFields(ApplicationUser user, MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, ErrorCollection errorCollection, I18nHelper i18n) {
        FieldScreenRenderer fieldScreenRenderer = this.getCreateFieldScreenRenderer((Issue)issue);
        Collection providedFields = issueInputParameters.getProvidedFields();
        if (providedFields == null) {
            providedFields = this.issueCreationHelperBean.getProvidedFieldNames((Issue)issue);
        }
        this.issueCreationHelperBean.validateCreateIssueFields((JiraServiceContext)new JiraServiceContextImpl(user, errorCollection), providedFields, (Issue)issue, fieldScreenRenderer, (OperationContext)new OperationContextImpl((IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, fieldValuesHolder), issueInputParameters, i18n);
        if (!errorCollection.hasAnyErrors()) {
            this.issueCreationHelperBean.updateIssueFromFieldValuesHolder(fieldScreenRenderer, issue, fieldValuesHolder);
        }
        return issue;
    }

    MutableIssue validateAndSetIssueType(MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, ErrorCollection errorCollection, I18nHelper i18n) {
        this.issueCreationHelperBean.validateIssueType((Issue)issue, (OperationContext)new OperationContextImpl((IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, fieldValuesHolder), issueInputParameters.getActionParameters(), errorCollection, i18n);
        if (!errorCollection.hasAnyErrors()) {
            issue.setIssueTypeId(issueInputParameters.getIssueTypeId());
        }
        return issue;
    }

    MutableIssue validateAndSetProject(MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, ErrorCollection errorCollection, I18nHelper i18n) {
        this.issueCreationHelperBean.validateProject((Issue)issue, (OperationContext)new OperationContextImpl((IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, fieldValuesHolder), issueInputParameters.getActionParameters(), errorCollection, i18n);
        if (!errorCollection.hasAnyErrors()) {
            issue.setProjectId(issueInputParameters.getProjectId());
        }
        return issue;
    }

    void updateIssueFromFields(FieldScreenRenderer fieldScreenRenderer, MutableIssue issue, ApplicationUser user, Map<String, Object> fieldValuesHolder, boolean updateComment, IssueInputParameters issueInputParameters) {
        if (updateComment) {
            this.updateIssueWithComment(issue, user, fieldValuesHolder);
        }
        if (!issueInputParameters.skipScreenCheck()) {
            this.updateIssueFromFieldsWithScreenCheck(fieldScreenRenderer, issue, fieldValuesHolder, issueInputParameters);
        } else {
            this.updateIssueFromFieldsWithoutScreenCheck(fieldScreenRenderer, issue, fieldValuesHolder, issueInputParameters);
        }
    }

    private void updateIssueFromFieldsWithScreenCheck(FieldScreenRenderer fieldScreenRenderer, MutableIssue issue, Map<String, Object> fieldValuesHolder, IssueInputParameters issueInputParameters) {
        boolean retainIssueValues = issueInputParameters.retainExistingValuesWhenParameterNotProvided();
        boolean onlyValidatePresentFields = issueInputParameters.onlyValidatePresentFieldsWhenRetainingExistingValues();
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                if (!fieldScreenRenderLayoutItem.isShow((Issue)issue)) continue;
                OrderableField orderableField = fieldScreenRenderLayoutItem.getOrderableField();
                if (retainIssueValues && !issueInputParameters.isFieldPresent(orderableField.getId()) && onlyValidatePresentFields) continue;
                orderableField.updateIssue(fieldScreenRenderLayoutItem.getFieldLayoutItem(), issue, fieldValuesHolder);
            }
        }
    }

    private void updateIssueFromFieldsWithoutScreenCheck(FieldScreenRenderer fieldScreenRenderer, MutableIssue issue, Map<String, Object> fieldValuesHolder, IssueInputParameters issueInputParameters) {
        boolean retainIssueValues = issueInputParameters.retainExistingValuesWhenParameterNotProvided();
        boolean onlyValidatePresentFields = issueInputParameters.onlyValidatePresentFieldsWhenRetainingExistingValues();
        Set orderableFields = this.fieldManager.getOrderableFields();
        for (OrderableField orderableField : orderableFields) {
            if (!this.canEditThisField(issue, orderableField) || retainIssueValues && !issueInputParameters.isFieldPresent(orderableField.getId()) && onlyValidatePresentFields || orderableField instanceof CommentSystemField) continue;
            FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem(issue, orderableField, fieldScreenRenderer);
            orderableField.updateIssue(fieldLayoutItem, issue, fieldValuesHolder);
        }
    }

    private FieldLayoutItem getFieldLayoutItem(MutableIssue issue, OrderableField orderableField, FieldScreenRenderer fieldScreenRenderer) {
        FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = this.getFieldScreenRenderLayoutItem(issue, orderableField, fieldScreenRenderer, false);
        if (fieldScreenRenderLayoutItem != null) {
            return fieldScreenRenderLayoutItem.getFieldLayoutItem();
        }
        return null;
    }

    void validateAndPopulateParams(ApplicationUser user, MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, OperationContext operationContext, ErrorCollection errorCollection, I18nHelper i18n, FieldScreenRenderer fieldScreenRenderer) {
        if (issueInputParameters.getCommentValue() != null) {
            OrderableField field = (OrderableField)this.fieldManager.getField(SystemSearchConstants.forComments().getFieldId());
            field.populateFromParams(fieldValuesHolder, issueInputParameters.getActionParameters());
            field.validateParams(operationContext, errorCollection, i18n, (Issue)issue, this.getFieldScreenRendererLayoutItemForField(user, (Issue)issue, field));
        }
        if (!issueInputParameters.skipScreenCheck()) {
            this.validateAndPopulateParamsWithScreenCheck(issue, issueInputParameters, fieldValuesHolder, operationContext, errorCollection, i18n, fieldScreenRenderer);
        } else {
            this.validateAndPopulateParamsWithoutScreenCheck(issue, issueInputParameters, fieldValuesHolder, operationContext, errorCollection, i18n, fieldScreenRenderer);
        }
    }

    private void validateAndPopulateParamsWithScreenCheck(MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, OperationContext operationContext, ErrorCollection errorCollection, I18nHelper i18n, FieldScreenRenderer fieldScreenRenderer) {
        boolean retainIssueValues = issueInputParameters.retainExistingValuesWhenParameterNotProvided();
        boolean onlyValidatePresentFields = issueInputParameters.onlyValidatePresentFieldsWhenRetainingExistingValues();
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                if (!fieldScreenRenderLayoutItem.isShow((Issue)issue)) continue;
                OrderableField orderableField = fieldScreenRenderLayoutItem.getOrderableField();
                if (retainIssueValues && !issueInputParameters.isFieldPresent(orderableField.getId())) {
                    if (onlyValidatePresentFields) continue;
                    orderableField.populateFromIssue(fieldValuesHolder, (Issue)issue);
                } else {
                    orderableField.populateFromParams(fieldValuesHolder, issueInputParameters.getActionParameters());
                }
                orderableField.validateParams(operationContext, errorCollection, i18n, (Issue)issue, fieldScreenRenderLayoutItem);
            }
        }
    }

    private void validateAndPopulateParamsWithoutScreenCheck(MutableIssue issue, IssueInputParameters issueInputParameters, Map<String, Object> fieldValuesHolder, OperationContext operationContext, ErrorCollection errorCollection, I18nHelper i18n, FieldScreenRenderer fieldScreenRenderer) {
        boolean retainIssueValues = issueInputParameters.retainExistingValuesWhenParameterNotProvided();
        boolean onlyValidatePresentFields = issueInputParameters.onlyValidatePresentFieldsWhenRetainingExistingValues();
        Set orderableFields = this.fieldManager.getOrderableFields();
        for (OrderableField orderableField : orderableFields) {
            if (!this.canEditThisField(issue, orderableField)) continue;
            FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = this.getFieldScreenRenderLayoutItem(issue, orderableField, fieldScreenRenderer, true);
            if (retainIssueValues && !issueInputParameters.isFieldPresent(orderableField.getId())) {
                if (onlyValidatePresentFields) continue;
                if (!(orderableField instanceof ResolutionSystemField) || issue.getResolution() != null) {
                    orderableField.populateFromIssue(fieldValuesHolder, (Issue)issue);
                }
            } else {
                orderableField.populateFromParams(fieldValuesHolder, issueInputParameters.getActionParameters());
            }
            orderableField.validateParams(operationContext, errorCollection, i18n, (Issue)issue, fieldScreenRenderLayoutItem);
        }
    }

    private boolean canEditThisField(MutableIssue issue, OrderableField orderableField) {
        if (orderableField instanceof CustomField) {
            CustomField customField = (CustomField)orderableField;
            return this.fieldConfigSchemeManager.isRelevantForIssueContext((IssueContext)issue, (ConfigurableField)customField);
        }
        return true;
    }

    private FieldScreenRenderLayoutItem getFieldScreenRenderLayoutItem(MutableIssue issue, OrderableField orderableField, FieldScreenRenderer fieldScreenRenderer, boolean useFallback) {
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                if (!fieldScreenRenderLayoutItem.isShow((Issue)issue) || !orderableField.equals(fieldScreenRenderLayoutItem.getOrderableField())) continue;
                return fieldScreenRenderLayoutItem;
            }
        }
        if (useFallback) {
            return this.getFieldScreenRenderLayoutItemFallback(orderableField);
        }
        return null;
    }

    private FieldScreenRenderLayoutItem getFieldScreenRenderLayoutItemFallback(OrderableField orderableField) {
        boolean needFallback;
        NotRequiredFieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = null;
        boolean bl = needFallback = !(orderableField instanceof CustomField);
        if (needFallback) {
            fieldScreenRenderLayoutItem = new NotRequiredFieldScreenRenderLayoutItem();
        }
        return fieldScreenRenderLayoutItem;
    }

    boolean licenseInvalidForIssueCreation(ApplicationUser user, ErrorCollection errorCollection, I18nHelper i18n) {
        SimpleErrorCollection errorCollection1 = new SimpleErrorCollection();
        this.issueCreationHelperBean.validateLicense(user, (ErrorCollection)errorCollection1, i18n);
        if (errorCollection1.hasAnyErrors()) {
            errorCollection.addErrorCollection((ErrorCollection)errorCollection1);
            return true;
        }
        return false;
    }

    boolean hasPermissionToEdit(ApplicationUser user, Issue issue, I18nHelper i18n, ErrorCollection errors) {
        boolean hasPermission = this.issueManager.isEditable(issue, user);
        if (!hasPermission) {
            errors.addErrorMessage(i18n.getText("editissue.error.no.edit.permission"), user == null ? ErrorCollection.Reason.NOT_LOGGED_IN : ErrorCollection.Reason.FORBIDDEN);
        }
        return hasPermission;
    }

    boolean hasPermissionToView(ApplicationUser user, Issue issue, I18nHelper i18n, ErrorCollection errorCollection) {
        boolean hasPermission = this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user);
        if (!hasPermission) {
            errorCollection.addErrorMessage(i18n.getText("admin.errors.issues.no.permission.to.see"), user == null ? ErrorCollection.Reason.NOT_LOGGED_IN : ErrorCollection.Reason.FORBIDDEN);
        }
        return hasPermission;
    }

    boolean hasPermissionToCreate(ApplicationUser user, Project project, I18nHelper i18n, ErrorCollection errors) {
        boolean hasPermission = this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, user);
        if (!hasPermission) {
            errors.addErrorMessage(i18n.getText("createissue.projectnopermission"), user == null ? ErrorCollection.Reason.NOT_LOGGED_IN : ErrorCollection.Reason.FORBIDDEN);
        }
        return hasPermission;
    }

    boolean hasPermissionToDelete(ApplicationUser user, Issue issue, I18nHelper i18n, ErrorCollection errors) {
        boolean hasPermission = this.permissionManager.hasPermission(ProjectPermissions.DELETE_ISSUES, issue, user);
        if (!hasPermission) {
            errors.addErrorMessage(i18n.getText("admin.errors.issues.no.permission.to.delete"), user == null ? ErrorCollection.Reason.NOT_LOGGED_IN : ErrorCollection.Reason.FORBIDDEN);
        }
        return hasPermission;
    }

    MutableIssue constructNewIssue() {
        return this.issueFactory.getIssue();
    }

    MutableIssue copyIssue(MutableIssue issue) {
        return this.issueFactory.getIssue(issue.getGenericValue());
    }

    FieldScreenRenderer getCreateFieldScreenRenderer(Issue issue) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION);
    }

    FieldScreenRenderer getUpdateFieldScreenRenderer(Issue issue) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION);
    }

    FieldScreenRenderer getTransitionFieldScreenRenderer(Issue issue, ActionDescriptor actionDescriptor) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, actionDescriptor);
    }

    MutableIssue getIssue(ApplicationUser user, MutableIssue issue, I18nHelper i18n, ErrorCollection errorCollection) {
        if (issue == null) {
            errorCollection.addErrorMessage(i18n.getText("issue.service.issue.wasdeleted"), ErrorCollection.Reason.NOT_FOUND);
        } else if (this.hasPermissionToView(user, (Issue)issue, i18n, errorCollection)) {
            return issue;
        }
        return null;
    }

    void updateIssueWithComment(MutableIssue issue, ApplicationUser user, Map<String, Object> fieldValuesHolder) {
        OrderableField commentField = (OrderableField)this.fieldManager.getField(SystemSearchConstants.forComments().getFieldId());
        FieldLayoutItem fieldLayoutItem = this.getFieldScreenRendererLayoutItemForField(user, (Issue)issue, commentField).getFieldLayoutItem();
        commentField.updateIssue(fieldLayoutItem, issue, fieldValuesHolder);
    }

    FieldScreenRenderLayoutItem getFieldScreenRendererLayoutItemForField(ApplicationUser user, Issue issue, OrderableField field) {
        FieldScreenRenderer renderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(user, issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION, false);
        return renderer.getFieldScreenRenderLayoutItem(field);
    }

    ActionDescriptor getActionDescriptor(Issue issue, int actionId) {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
        if (workflow == null) {
            return null;
        }
        WorkflowDescriptor descriptor = workflow.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        return descriptor.getAction(actionId);
    }

    I18nHelper getI18n(ApplicationUser user) {
        return new I18nBean(user);
    }

    Map<String, Object> createAdditionalParameters(ApplicationUser user, Map<String, Object> fieldValuesHolder, TransitionOptions transitionOptions, HistoryMetadata historyMetadata, String originalAssigneeId) {
        HashMap<String, Object> additionalParams = new HashMap<String, Object>();
        WorkflowFunctionUtils.populateParamsWithUser(additionalParams, (ApplicationUser)user);
        CommentSystemField commentSystemField = (CommentSystemField)this.fieldManager.getOrderableField("comment");
        commentSystemField.populateAdditionalInputs(fieldValuesHolder, additionalParams);
        additionalParams.putAll(transitionOptions.getWorkflowParams());
        if (historyMetadata != null) {
            additionalParams.put("history_metadata", historyMetadata);
        }
        additionalParams.put("originalAssigneeId", originalAssigneeId);
        return additionalParams;
    }

    private class SimpleWorkflowProgressAware
    implements WorkflowProgressAware {
        private int action;
        private final ApplicationUser remoteUser;
        private final ErrorCollection errorCollection;
        private final Map additionalInputs;
        private final MutableIssue issue;

        private SimpleWorkflowProgressAware(int action, ApplicationUser remoteUser, ErrorCollection errorCollection, Map additionalInputs, MutableIssue issue) {
            this.action = action;
            this.remoteUser = remoteUser;
            this.errorCollection = errorCollection;
            this.additionalInputs = additionalInputs;
            this.issue = issue;
        }

        public ApplicationUser getRemoteUser() {
            return this.remoteUser;
        }

        public ApplicationUser getRemoteApplicationUser() {
            return this.remoteUser;
        }

        public int getAction() {
            return this.action;
        }

        public void setAction(int action) {
            this.action = action;
        }

        public void addErrorMessage(String error) {
            this.errorCollection.addErrorMessage(error);
        }

        public void addError(String name, String error) {
            this.errorCollection.addError(name, error);
        }

        public Map getAdditionalInputs() {
            return this.additionalInputs;
        }

        public MutableIssue getIssue() {
            return this.issue;
        }

        public Project getProject() {
            return this.issue.getProjectObject();
        }

        public Project getProjectObject() {
            return this.issue.getProjectObject();
        }
    }
}

