/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue;

import com.atlassian.fugue.Either;
import com.atlassian.jira.concurrent.Barrier;
import com.atlassian.jira.concurrent.BarrierFactory;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.FixedSized;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class CloneIssueCommand
implements Callable<CloneIssueResult>,
ProvidesTaskProgress {
    private final ApplicationUser user;
    private final Issue originalIssue;
    private final String summary;
    private final boolean cloneAttachments;
    private final boolean cloneSubTasks;
    private final boolean cloneLinks;
    private Map<CustomField, Optional<Boolean>> cloneOptionSelections;
    private final IssueManager issueManager;
    private final IssueFactory issueFactory;
    private final ApplicationProperties applicationProperties;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkManager issueLinkManager;
    private final RemoteIssueLinkManager remoteIssueLinkManager;
    private final AttachmentManager attachmentManager;
    private final SubTaskManager subTaskManager;
    private final PermissionManager permissionManager;
    private final CustomFieldManager customFieldManager;
    private final Logger log;
    private final I18nHelper i18nHelper;
    private volatile TaskProgressSink taskProgressSink;
    private final Barrier cloneIssueBarrier;

    public CloneIssueCommand(ApplicationUser user, Issue originalIssue, String summary, boolean cloneAttachments, boolean cloneSubTasks, boolean cloneLinks, Map<CustomField, Optional<Boolean>> cloneOptionSelections, IssueManager issueManager, IssueFactory issueFactory, ApplicationProperties applicationProperties, IssueLinkTypeManager issueLinkTypeManager, IssueLinkManager issueLinkManager, RemoteIssueLinkManager remoteIssueLinkManager, AttachmentManager attachmentManager, SubTaskManager subTaskManager, PermissionManager permissionManager, CustomFieldManager customFieldManager, Logger log, I18nHelper i18nHelper, BarrierFactory barrierFactory) {
        this.user = user;
        this.originalIssue = originalIssue;
        this.summary = summary;
        this.cloneAttachments = cloneAttachments;
        this.cloneSubTasks = cloneSubTasks;
        this.cloneLinks = cloneLinks;
        this.cloneOptionSelections = cloneOptionSelections;
        this.issueManager = issueManager;
        this.issueFactory = issueFactory;
        this.applicationProperties = applicationProperties;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkManager = issueLinkManager;
        this.remoteIssueLinkManager = remoteIssueLinkManager;
        this.attachmentManager = attachmentManager;
        this.subTaskManager = subTaskManager;
        this.permissionManager = permissionManager;
        this.customFieldManager = customFieldManager;
        this.log = log;
        this.i18nHelper = i18nHelper;
        this.cloneIssueBarrier = barrierFactory.getBarrier("cloneIssue");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloneIssueResult call() {
        int totalProgressSize = this.estimateProgressRequired();
        Context context = Contexts.builder().sized((Sized)new FixedSized(totalProgressSize)).progressSubTask(this.taskProgressSink, this.i18nHelper, "cloneissue.progress.cloning.current.step").build();
        try {
            MutableIssue cloneIssue = this.issueFactory.cloneIssue(this.originalIssue);
            this.prepareForCloningIssue(this.user, this.originalIssue, cloneIssue, this.cloneOptionSelections);
            cloneIssue.setSummary(this.summary);
            Context.Task taskStep = context.start((Object)this.originalIssue);
            Issue issue = this.issueManager.createIssueObject(this.user, (Issue)cloneIssue);
            taskStep.complete();
            Set<Long> originalIssueIdSet = this.idsOfOriginalIssueIncludingSubTaskIfNeeded(this.user, this.originalIssue, this.cloneSubTasks);
            this.cloneIssueDependencies(context, this.user, this.originalIssue, issue, originalIssueIdSet, this.cloneAttachments, this.cloneSubTasks, this.cloneLinks);
            this.cloneIssueBarrier.await();
            CloneIssueResult cloneIssueResult = new CloneIssueResult(cloneIssue.getKey());
            return cloneIssueResult;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessage(this.i18nHelper.getText("admin.errors.exception") + " " + e);
            CloneIssueResult cloneIssueResult = new CloneIssueResult(null, (ErrorCollection)errorCollection);
            return cloneIssueResult;
        }
        finally {
            for (int i = 0; i < context.getNumberOfTasksToCompletion(); ++i) {
                context.start(null).complete();
            }
        }
    }

    private int estimateProgressRequired() {
        int total = 1;
        if (this.cloneAttachments && this.attachmentManager.attachmentsEnabled()) {
            total += this.attachmentManager.getAttachments(this.originalIssue).size();
        }
        if (this.cloneLinks && this.issueLinkManager.isLinkingEnabled()) {
            total += this.issueLinkManager.getInwardLinks(this.originalIssue.getId()).size();
            total += this.issueLinkManager.getOutwardLinks(this.originalIssue.getId()).size();
            total += this.remoteIssueLinkManager.getRemoteIssueLinksForIssue(this.originalIssue).size();
        }
        if (this.subTaskManager.isSubTasksEnabled() && this.cloneSubTasks) {
            total += this.originalIssue.getSubTaskObjects().size();
        }
        return total;
    }

    private void prepareForCloningIssue(ApplicationUser user, Issue originalIssue, MutableIssue cloneIssue, Map<CustomField, Optional<Boolean>> cloneOptionSelections) {
        this.setNotCloningFieldsToBlankByDefault(user, originalIssue, cloneIssue);
        this.cloneSomeFieldsFromOriginalIssue(user, originalIssue, cloneIssue, cloneOptionSelections);
    }

    private void setNotCloningFieldsToBlankByDefault(ApplicationUser user, Issue originalIssue, MutableIssue cloneIssue) {
        cloneIssue.setCreated(null);
        cloneIssue.setUpdated(null);
        cloneIssue.setVotes(null);
        cloneIssue.setWatches(Long.valueOf(0L));
        cloneIssue.setStatus(null);
        cloneIssue.setWorkflowId(null);
        cloneIssue.setEstimate(originalIssue.getOriginalEstimate());
        cloneIssue.setTimeSpent(null);
        cloneIssue.setResolutionDate(null);
        if (!this.isCanModifyReporter(user, (Issue)cloneIssue)) {
            cloneIssue.setReporter(user);
        }
    }

    private void cloneIssueDependencies(Context context, ApplicationUser user, Issue originalIssue, Issue cloneIssue, Set<Long> originalIssueIdSet, boolean cloneAttachments, boolean cloneSubTasks, boolean cloneLinks) throws Exception {
        HashMap<Long, Long> newIssueIdMap = new HashMap<Long, Long>();
        newIssueIdMap.put(originalIssue.getId(), cloneIssue.getId());
        this.linkCloningIssueToOriginalOne(user, originalIssue, cloneIssue);
        context.setName(this.i18nHelper.getText("cloneissue.progress.cloning.attachments"));
        this.cloneAttachmentsIfNeeded(context, user, originalIssue, cloneIssue, cloneAttachments);
        context.setName(this.i18nHelper.getText("cloneissue.progress.cloning.issue.links"));
        this.cloneLinksIfNeeded(context, user, originalIssue, cloneIssue, originalIssueIdSet, cloneSubTasks, cloneLinks, newIssueIdMap);
        if (this.isCloningSubTask(originalIssue)) {
            this.linkCloningSubTaskToOriginalSubTaskParent(user, originalIssue, cloneIssue);
        } else {
            context.setName(this.i18nHelper.getText("cloneissue.progress.cloning.subtasks"));
            Map<Long, Long> subtaskIdMap = this.cloneSubTasksIfNeeded(context, user, originalIssue, cloneIssue, originalIssueIdSet, cloneAttachments, cloneSubTasks, cloneLinks);
            newIssueIdMap.putAll(subtaskIdMap);
        }
    }

    private void cloneSomeFieldsFromOriginalIssue(ApplicationUser user, Issue originalIssue, MutableIssue clonedIssue, Map<CustomField, Optional<Boolean>> cloneOptionSelections) {
        clonedIssue.setFixVersions(this.withoutArchivedVersions(originalIssue.getFixVersions()));
        clonedIssue.setAffectedVersions(this.withoutArchivedVersions(originalIssue.getAffectedVersions()));
        this.cloneCustomFields(user, originalIssue, clonedIssue, cloneOptionSelections);
    }

    @VisibleForTesting
    void cloneCustomFields(ApplicationUser user, Issue originalIssue, MutableIssue clonedIssue, Map<CustomField, Optional<Boolean>> cloneOptionSelections) {
        List<CustomField> customFields = this.getCustomFields(originalIssue);
        for (CustomField cf : customFields) {
            Object clonedValue;
            Optional<Boolean> cloneOption = cloneOptionSelections.get(cf);
            if (cloneOption == null) {
                cloneOption = Optional.empty();
            }
            if ((clonedValue = cf.getCustomFieldType().getCloneValue(cf, originalIssue, cloneOption)) == null) continue;
            clonedIssue.setCustomFieldValue(cf, clonedValue);
        }
    }

    private Collection withoutArchivedVersions(Collection<Version> versions) {
        ArrayList<Version> notArchivedVersions = new ArrayList<Version>();
        for (Version version : versions) {
            if (version.isArchived()) continue;
            notArchivedVersions.add(version);
        }
        return notArchivedVersions;
    }

    private void linkCloningIssueToOriginalOne(ApplicationUser user, Issue originalIssue, Issue cloneIssue) throws CreateException {
        IssueLinkType cloneIssueLinkType = this.getCloneIssueLinkType();
        if (cloneIssueLinkType != null) {
            this.issueLinkManager.createIssueLink(cloneIssue.getId(), originalIssue.getId(), cloneIssueLinkType.getId(), null, user);
        }
    }

    public IssueLinkType getCloneIssueLinkType() {
        IssueLinkType cloneIssueLinkType = null;
        String cloneLinkTypeName = this.applicationProperties.getDefaultBackedString("jira.clone.linktype.name");
        if (StringUtils.isBlank((String)cloneLinkTypeName)) {
            cloneIssueLinkType = null;
        } else {
            Collection cloneIssueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypesByName(cloneLinkTypeName);
            if (CollectionUtils.isEmpty((Collection)cloneIssueLinkTypes)) {
                this.log.warn("The clone link type '" + cloneLinkTypeName + "' does not exist. A link to the original issue will not be created.");
                cloneIssueLinkType = null;
            } else {
                for (IssueLinkType issueLinkType : cloneIssueLinkTypes) {
                    if (!issueLinkType.getName().equals(cloneLinkTypeName)) continue;
                    cloneIssueLinkType = issueLinkType;
                }
            }
        }
        return cloneIssueLinkType;
    }

    private void cloneAttachmentsIfNeeded(Context context, ApplicationUser user, Issue originalIssue, Issue clone, boolean cloneAttachments) throws CreateException {
        if (cloneAttachments && this.attachmentManager.attachmentsEnabled()) {
            Map result = this.attachmentManager.copyAttachments(context, originalIssue, user, clone.getKey());
            for (Either either : result.values()) {
                if (!either.isLeft()) continue;
                AttachmentError error = (AttachmentError)either.left().get();
                this.log.warn(error.getLogMessage(), (Throwable)error.getException().getOrNull());
            }
        }
    }

    private void cloneLinksIfNeeded(Context context, ApplicationUser user, Issue originalIssue, Issue cloneIssue, Set<Long> originalIssueIdSet, boolean cloneSubTasks, boolean cloneLinks, Map<Long, Long> newIssueIdMap) throws CreateException {
        if (cloneLinks && this.issueLinkManager.isLinkingEnabled()) {
            List inwardLinks = this.issueLinkManager.getInwardLinks(originalIssue.getId());
            this.cloneInwardLinks(context, user, originalIssue, cloneIssue, originalIssueIdSet, inwardLinks, newIssueIdMap);
            List outwardLinks = this.issueLinkManager.getOutwardLinks(originalIssue.getId());
            this.cloneOutwardLinks(context, user, originalIssue, cloneIssue, originalIssueIdSet, outwardLinks, newIssueIdMap);
            this.cloneRemoteIssueLinks(context, user, originalIssue, cloneIssue);
        }
    }

    private void cloneInwardLinks(Context context, ApplicationUser user, Issue originalIssue, Issue cloneIssue, Set<Long> originalIssueIdSet, Collection<IssueLink> givenLinks, Map<Long, Long> newIssueIdMap) throws CreateException {
        this.cloningGivenIssueLinks(context, user, originalIssue, cloneIssue, originalIssueIdSet, givenLinks, true, newIssueIdMap);
    }

    private void cloneOutwardLinks(Context context, ApplicationUser user, Issue originalIssue, Issue cloneIssue, Set<Long> originalIssueIdSet, Collection<IssueLink> givenLinks, Map<Long, Long> newIssueIdMap) throws CreateException {
        this.cloningGivenIssueLinks(context, user, originalIssue, cloneIssue, originalIssueIdSet, givenLinks, false, newIssueIdMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloningGivenIssueLinks(Context context, ApplicationUser user, Issue originalIssue, Issue cloneIssue, Set<Long> originalIssueIdSet, Collection<IssueLink> givenLinks, boolean isCopyingInwardLinks, Map<Long, Long> newIssueIdMap) throws CreateException {
        for (IssueLink issueLink : givenLinks) {
            Context.Task taskStep = context.start((Object)originalIssue);
            try {
                Long workingIssueId;
                if (!this.isCopyableLink(issueLink)) continue;
                Long l = workingIssueId = isCopyingInwardLinks ? issueLink.getSourceId() : issueLink.getDestinationId();
                if (originalIssueIdSet.contains(workingIssueId)) {
                    workingIssueId = newIssueIdMap.get(workingIssueId);
                }
                if (workingIssueId == null) continue;
                if (isCopyingInwardLinks) {
                    this.log.debug("Creating inward link to " + cloneIssue.getKey() + " (cloned from " + originalIssue.getKey() + ", link " + issueLink + ")");
                    this.issueLinkManager.createIssueLink(workingIssueId, cloneIssue.getId(), issueLink.getIssueLinkType().getId(), null, user);
                    continue;
                }
                this.log.debug("Creating outward link from " + cloneIssue.getKey() + " (cloned from " + originalIssue.getKey() + ", link " + issueLink + ")");
                this.issueLinkManager.createIssueLink(cloneIssue.getId(), workingIssueId, issueLink.getIssueLinkType().getId(), null, user);
            }
            finally {
                taskStep.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneRemoteIssueLinks(Context context, ApplicationUser user, Issue originalIssue, Issue cloneIssue) throws CreateException {
        List originalLinks = this.remoteIssueLinkManager.getRemoteIssueLinksForIssue(originalIssue);
        for (RemoteIssueLink originalLink : originalLinks) {
            Context.Task taskStep = context.start((Object)originalLink);
            try {
                RemoteIssueLink link = new RemoteIssueLinkBuilder(originalLink).id(null).issueId(cloneIssue.getId()).build();
                this.remoteIssueLinkManager.createRemoteIssueLink(link, user);
            }
            finally {
                taskStep.complete();
            }
        }
    }

    private boolean isCopyableLink(IssueLink checkingLink) {
        return !checkingLink.isSystemLink() && (this.getCloneIssueLinkType() == null || this.givenLinkTypeIsNotSameAsCloneIssueLinkType(checkingLink));
    }

    private boolean givenLinkTypeIsNotSameAsCloneIssueLinkType(IssueLink checkingLink) {
        return !this.getCloneIssueLinkType().getId().equals(checkingLink.getIssueLinkType().getId());
    }

    private Set<Long> idsOfOriginalIssueIncludingSubTaskIfNeeded(ApplicationUser user, Issue originalIssue, boolean cloneSubTasks) {
        HashSet<Long> originalIssues = new HashSet<Long>();
        originalIssues.add(originalIssue.getId());
        if (this.subTaskManager.isSubTasksEnabled() && cloneSubTasks) {
            for (Issue subTask : originalIssue.getSubTaskObjects()) {
                originalIssues.add(subTask.getId());
            }
        }
        return originalIssues;
    }

    private boolean isCloningSubTask(Issue originalIssue) {
        return originalIssue.isSubTask();
    }

    private void linkCloningSubTaskToOriginalSubTaskParent(ApplicationUser user, Issue originalIssue, Issue cloneIssue) throws CreateException {
        Issue subTaskParent = originalIssue.getParentObject();
        this.subTaskManager.createSubTaskIssueLink(subTaskParent, cloneIssue, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Long> cloneSubTasksIfNeeded(Context context, ApplicationUser user, Issue originalIssue, Issue cloneIssue, Set<Long> originalIssueIdSet, boolean cloneAttachments, boolean cloneSubTasks, boolean cloneLinks) throws Exception {
        HashMap<Long, Long> newIssueIdMap = new HashMap<Long, Long>();
        String clonePrefixProperties = this.applicationProperties.getDefaultBackedString("jira.clone.prefix");
        if (this.subTaskManager.isSubTasksEnabled() && cloneSubTasks) {
            for (Issue originalSubTask : originalIssue.getSubTaskObjects()) {
                Context.Task taskStep = context.start((Object)originalIssue);
                try {
                    MutableIssue cloneSubTask = this.issueFactory.cloneIssue(originalSubTask);
                    String subTaskSummary = cloneSubTask.getSummary();
                    String cloneSummary = StringUtils.isBlank((String)clonePrefixProperties) ? subTaskSummary : StringUtils.join((Object[])new Object[]{clonePrefixProperties, subTaskSummary}, (String)" ");
                    cloneSubTask.setSummary(cloneSummary);
                    this.prepareForCloningIssue(user, originalSubTask, cloneSubTask, this.cloneOptionSelections);
                    cloneSubTask.setParentId(cloneIssue.getId());
                    Issue subTask = this.issueManager.createIssueObject(user, (Issue)cloneSubTask);
                    newIssueIdMap.put(originalSubTask.getId(), subTask.getId());
                    this.cloneLinksIfNeeded(Contexts.nullContext(), user, originalSubTask, subTask, originalIssueIdSet, cloneSubTasks, cloneLinks, newIssueIdMap);
                    this.subTaskManager.createSubTaskIssueLink(cloneIssue, subTask, user);
                    this.cloneAttachmentsIfNeeded(Contexts.nullContext(), user, originalSubTask, subTask, cloneAttachments);
                }
                finally {
                    taskStep.complete();
                }
            }
        }
        return newIssueIdMap;
    }

    public boolean isCanModifyReporter(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(ProjectPermissions.MODIFY_REPORTER, issue, user);
    }

    public List<CustomField> getCustomFields(Issue issue) {
        return this.customFieldManager.getCustomFieldObjects(issue.getProjectId(), issue.getIssueTypeId());
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }

    public static final class CloneIssueResult
    implements Serializable {
        private final SimpleErrorCollection errorCollection;
        private final String issueKey;

        public CloneIssueResult(String issueKey, ErrorCollection errorCollection) {
            this.issueKey = issueKey;
            Assertions.notNull((String)"errorCollection", (Object)errorCollection);
            this.errorCollection = new SimpleErrorCollection(errorCollection);
        }

        public CloneIssueResult(String issueKey) {
            this.issueKey = issueKey;
            this.errorCollection = new SimpleErrorCollection();
        }

        public String getIssueKey() {
            return this.issueKey;
        }

        public ErrorCollection getErrorCollection() {
            return this.errorCollection;
        }

        public boolean isSuccessful() {
            return !this.errorCollection.hasAnyErrors();
        }
    }
}

