/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.jira.bc.dataimport.DowngradeUtil;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.model.querydsl.QUpgradeHistory;
import com.atlassian.jira.model.querydsl.QUpgradeVersionHistory;
import com.atlassian.jira.model.querydsl.UpgradeHistoryDTO;
import com.atlassian.jira.model.querydsl.UpgradeVersionHistoryDTO;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.DowngradeException;
import com.atlassian.jira.upgrade.DowngradeTask;
import com.atlassian.jira.upgrade.MissingDowngradeTaskException;
import com.atlassian.jira.upgrade.ReindexRequirement;
import com.atlassian.jira.upgrade.util.BuildNumberDao;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.DowngradeUtilsImpl;
import com.google.common.annotations.VisibleForTesting;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DowngradeWorker {
    private static final Logger log = LoggerFactory.getLogger(DowngradeWorker.class);
    private final BuildUtilsInfo buildUtilsInfo;
    private final DbConnectionManager dbConnectionManager;
    private final OfBizDelegator ofBizDelegator;
    private final ApplicationProperties applicationProperties;

    public DowngradeWorker(BuildUtilsInfo buildUtilsInfo, DbConnectionManager dbConnectionManager, OfBizDelegator ofBizDelegator, ApplicationProperties applicationProperties) {
        this.buildUtilsInfo = buildUtilsInfo;
        this.dbConnectionManager = dbConnectionManager;
        this.ofBizDelegator = ofBizDelegator;
        this.applicationProperties = applicationProperties;
    }

    public void downgrade(Mode downgradeMode) throws DowngradeException {
        List<Integer> downgradeTaskNumbers = this.findDowngradeTasksToRun();
        Map<Integer, DowngradeTask> downgradeTaskMap = DowngradeUtil.loadDowngradeTasks();
        DowngradeUtil.verifyTasksExist(downgradeTaskNumbers, downgradeTaskMap);
        log.info("______ Performing Downgrade ______");
        for (Integer downgradeTaskNumber : downgradeTaskNumbers) {
            DowngradeTask downgradeTask = downgradeTaskMap.get(downgradeTaskNumber);
            this.runDowngradeTask(downgradeTask);
            this.persistReindexRequirement(downgradeTask, downgradeMode);
            this.undoUpgradeHistory(downgradeTaskNumber);
        }
        log.info("______ Downgrade Complete ______");
    }

    public void writeNewBuildNumbers() {
        DowngradeUtilsImpl downgradeUtilsInfo = new DowngradeUtilsImpl();
        BuildNumberDao buildNumberDao = new BuildNumberDao(downgradeUtilsInfo, this.applicationProperties);
        buildNumberDao.setDatabaseBuildNumber(this.buildUtilsInfo.getCurrentBuildNumber());
        buildNumberDao.setJiraVersion(this.buildUtilsInfo.getVersion());
        buildNumberDao.setMinimumDowngradeVersion();
        buildNumberDao.insertUpgradeVersionHistory(this.ofBizDelegator, this.buildUtilsInfo.getCurrentBuildNumber(), this.buildUtilsInfo.getVersion());
    }

    public boolean canDowngrade() throws DowngradeException {
        List<Integer> downgradeTaskNumbers = this.findDowngradeTasksToRun();
        Map<Integer, DowngradeTask> downgradeTaskMap = DowngradeUtil.loadDowngradeTasks();
        try {
            DowngradeUtil.verifyTasksExist(downgradeTaskNumbers, downgradeTaskMap);
            return true;
        }
        catch (MissingDowngradeTaskException e) {
            return false;
        }
    }

    @VisibleForTesting
    List<Integer> findDowngradeTasksToRun() throws DowngradeException {
        List upgradeHistoryItems = this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUpgradeHistory.UPGRADE_HISTORY).from((Expression)QUpgradeHistory.UPGRADE_HISTORY)).fetch());
        return DowngradeUtil.findDowngradeTasksToRun(upgradeHistoryItems, this.buildUtilsInfo.getApplicationBuildNumber());
    }

    private void runDowngradeTask(DowngradeTask downgradeTask) throws DowngradeException {
        log.info("Performing Downgrade Task " + downgradeTask.getBuildNumber() + ": " + downgradeTask.getShortDescription());
        try {
            downgradeTask.setDbConnectionManager(this.dbConnectionManager);
            downgradeTask.setOfBizDelegator(this.ofBizDelegator);
            downgradeTask.downgrade();
        }
        catch (DowngradeException ex) {
            log.error("Downgrade Task " + downgradeTask.getBuildNumber() + " failed.", (Throwable)ex);
            throw ex;
        }
        log.info("Downgrade Task " + downgradeTask.getBuildNumber() + " succeeded.");
    }

    private void persistReindexRequirement(DowngradeTask downgradeTask, Mode downgradeMode) {
        switch (downgradeMode) {
            case IMPORT: {
                return;
            }
            case START_UP: {
                this.persistReindexRequirement(downgradeTask.reindexRequired());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void persistReindexRequirement(ReindexRequirement reindexRequirement) {
        switch (reindexRequirement) {
            case NONE: {
                return;
            }
            case FOREGROUND: {
                DowngradeUtil.setReindexRequirement(this.applicationProperties, reindexRequirement);
                return;
            }
            case BACKGROUND: {
                ReindexRequirement currentReindexRequirement = DowngradeUtil.getReindexRequirement(this.applicationProperties);
                if (currentReindexRequirement == ReindexRequirement.NONE) {
                    DowngradeUtil.setReindexRequirement(this.applicationProperties, reindexRequirement);
                }
                return;
            }
        }
        throw new IllegalStateException();
    }

    @VisibleForTesting
    void undoUpgradeHistory(Integer downgradeTaskNumber) {
        this.dbConnectionManager.execute(dbConnection -> {
            List upgradeHistoryItems = ((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUpgradeHistory.UPGRADE_HISTORY).from((Expression)QUpgradeHistory.UPGRADE_HISTORY)).fetch();
            for (UpgradeHistoryDTO upgradeHistoryItem : upgradeHistoryItems) {
                String buildNumberString = upgradeHistoryItem.getTargetbuild();
                Integer buildNumber = NumberUtils.toInt((String)buildNumberString, (int)-1);
                if (buildNumber < downgradeTaskNumber) continue;
                dbConnection.delete((RelationalPath<?>)QUpgradeHistory.UPGRADE_HISTORY).where((Predicate)QUpgradeHistory.UPGRADE_HISTORY.targetbuild.eq((Object)buildNumberString)).execute();
            }
        });
        this.dbConnectionManager.execute(dbConnection -> {
            List upgradeHistoryItems = ((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY).from((Expression)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY)).fetch();
            for (UpgradeVersionHistoryDTO upgradeHistoryItem : upgradeHistoryItems) {
                String buildNumberString = upgradeHistoryItem.getTargetbuild();
                Integer buildNumber = NumberUtils.toInt((String)buildNumberString, (int)-1);
                if (buildNumber < downgradeTaskNumber) continue;
                dbConnection.delete((RelationalPath<?>)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY).where((Predicate)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY.targetbuild.eq((Object)buildNumberString)).execute();
            }
        });
        int newDbBuildNumber = downgradeTaskNumber - 1;
        log.info("Setting current build number to " + newDbBuildNumber);
        this.applicationProperties.setString("jira.version.patched", String.valueOf(newDbBuildNumber));
    }

    public static enum Mode {
        IMPORT,
        START_UP;

    }
}

