/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.activeobjects.spi.ActiveObjectsImportExportException;
import com.atlassian.activeobjects.spi.Backup;
import com.atlassian.activeobjects.spi.HotRestartEvent;
import com.atlassian.activeobjects.spi.NullRestoreProgressMonitor;
import com.atlassian.core.util.FileSize;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.spi.EventExecutorFactory;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.dataimport.ConstrainedBuildUtilsInfo;
import com.atlassian.jira.bc.dataimport.DataImportFinishedEvent;
import com.atlassian.jira.bc.dataimport.DataImportParams;
import com.atlassian.jira.bc.dataimport.DataImportProductionDependencies;
import com.atlassian.jira.bc.dataimport.DataImportPropertiesAdapter;
import com.atlassian.jira.bc.dataimport.DataImportPropertiesValidationService;
import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.bc.dataimport.DatabaseImportCompletedEvent;
import com.atlassian.jira.bc.dataimport.DowngradeUtil;
import com.atlassian.jira.bc.dataimport.DowngradeWorker;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ImportStartedEvent;
import com.atlassian.jira.bc.dataimport.OfbizImportHandler;
import com.atlassian.jira.bc.dataimport.OfbizImportHandlerFactory;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.bean.export.IllegalXMLCharactersException;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.entity.EntityEngineImpl;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.event.JiraEventExecutorFactory;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.index.request.ReindexRequestManager;
import com.atlassian.jira.model.querydsl.UpgradeHistoryDTO;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.task.ProgressMonitoringFileInputStream;
import com.atlassian.jira.task.StepTaskProgressSink;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.upgrade.DowngradeException;
import com.atlassian.jira.upgrade.UpgradeConstraints;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.upgrade.UpgradeManagerParams;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build6040;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.DirectorySynchroniserBarrier;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.XmlReader;
import com.atlassian.jira.util.ZipUtils;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.concurrent.BoundedExecutor;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.xml.JiraFileInputStream;
import com.atlassian.jira.util.xml.XMLEscapingReader;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.jira.web.action.setup.DevModeSecretSauce;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeManager;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.atlassian.security.xml.SecureXmlParserFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class DefaultDataImportService
implements DataImportService {
    private static final Logger log = Logger.getLogger(DefaultDataImportService.class);
    private static final int DEFAULT_THREADS = 10;
    private static final int DEFAULT_MAXQUEUESIZE = 100;
    private final GlobalPermissionManager permissionManager;
    private final JiraHome jiraHome;
    private final JiraLicenseUpdaterService jiraLicenseService;
    private final I18nHelper.BeanFactory beanFactory;
    private final OfBizDelegator ofBizDelegator;
    private final ExternalLinkUtil externalLinkUtil;
    private final ApplicationProperties applicationProperties;
    private final BuildUtilsInfo buildUtilsInfo;
    private final TaskManager taskManager;
    private final ServiceManager serviceManager;
    private final MailQueue mailQueue;
    private final ComponentFactory factory;
    private final DataImportProductionDependencies dependencies;
    private final DevModeSecretSauce devModeSecretSauce;
    private final ThreadFactory threadFactory;
    private final DbConnectionManager dbConnectionManager;
    private final JiraEventExecutorFactory eventExecutorFactory;
    private final JiraProperties jiraSystemProperties;
    private final ReindexRequestManager reindexRequestManager;
    private final ClusterManager clusterManager;
    private final DataImportPropertiesValidationService propertiesValidationService;
    private final OfbizImportHandlerFactory ofbizImportHandlerFactory;

    public DefaultDataImportService(DataImportProductionDependencies dependencies, GlobalPermissionManager permissionManager, JiraHome jiraHome, JiraLicenseUpdaterService jiraLicenseService, I18nHelper.BeanFactory beanFactory, OfBizDelegator ofBizDelegator, ExternalLinkUtil externalLinkUtil, ApplicationProperties applicationProperties, BuildUtilsInfo buildUtilsInfo, TaskManager taskManager, ServiceManager serviceManager, MailQueue mailQueue, ComponentFactory factory, DbConnectionManager dbConnectionManager, EventExecutorFactory eventExecutorFactory, JiraProperties jiraSystemProperties, ReindexRequestManager reindexRequestManager, ClusterManager clusterManager, UpgradeConstraints upgradeConstraints, DataImportPropertiesValidationService propertiesValidationService, OfbizImportHandlerFactory ofbizImportHandlerFactory) {
        this.dependencies = dependencies;
        this.permissionManager = permissionManager;
        this.jiraHome = jiraHome;
        this.jiraLicenseService = jiraLicenseService;
        this.beanFactory = beanFactory;
        this.ofBizDelegator = ofBizDelegator;
        this.externalLinkUtil = externalLinkUtil;
        this.applicationProperties = applicationProperties;
        this.buildUtilsInfo = new ConstrainedBuildUtilsInfo(upgradeConstraints, buildUtilsInfo);
        this.taskManager = taskManager;
        this.serviceManager = serviceManager;
        this.mailQueue = mailQueue;
        this.factory = factory;
        this.dbConnectionManager = dbConnectionManager;
        this.jiraSystemProperties = jiraSystemProperties;
        this.reindexRequestManager = reindexRequestManager;
        this.clusterManager = clusterManager;
        this.eventExecutorFactory = (JiraEventExecutorFactory)eventExecutorFactory;
        this.devModeSecretSauce = new DevModeSecretSauce(jiraSystemProperties);
        this.threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("JIRA-Import-Thread-%d").build();
        this.propertiesValidationService = propertiesValidationService;
        this.ofbizImportHandlerFactory = ofbizImportHandlerFactory;
    }

    private static boolean checkFile(ErrorCollection errors, I18nHelper i18n, File file) {
        if (!file.exists()) {
            errors.addError("filename", i18n.getText("admin.errors.could.not.find.file", file.getAbsolutePath()));
            return false;
        }
        if (!file.isFile()) {
            errors.addError("filename", i18n.getText("admin.errors.file.is.directory", file.getAbsolutePath()));
            return false;
        }
        if (!file.canRead()) {
            errors.addError("filename", i18n.getText("admin.errors.file.readable", file.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public DataImportService.ImportValidationResult validateImport(ApplicationUser loggedInUser, DataImportParams params) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.beanFactory.getInstance(loggedInUser);
        if (!params.isSetup() && !this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, loggedInUser)) {
            errors.addErrorMessage(i18n.getText("admin.errors.import.permission"));
        }
        if (params.isSetup() && this.applicationProperties.getString("jira.setup") != null) {
            errors.addErrorMessage(i18n.getText("admin.errors.import.already.setup"));
        }
        this.checkFileIsValid(params, (ErrorCollection)errors, i18n);
        if (StringUtils.isNotBlank((String)params.getLicenseString())) {
            JiraLicenseService.ValidationResult validationResult = this.jiraLicenseService.validate(i18n, params.getLicenseString());
            errors.addErrorCollection(validationResult.getErrorCollection());
        }
        if (this.getAOBackup() == null) {
            errors.addErrorMessage(i18n.getText("data.import.error.no.ao"));
        }
        this.checkClusterNotActive((ErrorCollection)errors, i18n);
        return new DataImportService.ImportValidationResult((ErrorCollection)errors, params);
    }

    private void checkFileIsValid(DataImportParams params, ErrorCollection errors, I18nHelper i18n) {
        if (params.getUnsafeJiraBackup() == null) {
            if (params.getFilename() == null) {
                errors.addErrorMessage(i18n.getText("admin.errors.must.enter.xml2"));
            } else {
                DefaultDataImportService.checkFile(errors, i18n, this.getSafeFile(params));
            }
        } else {
            DefaultDataImportService.checkFile(errors, i18n, params.getUnsafeJiraBackup());
        }
        if (params.getUnsafeAOBackup() != null) {
            DefaultDataImportService.checkFile(errors, i18n, params.getUnsafeAOBackup());
        }
    }

    public void checkClusterNotActive(ErrorCollection errors, I18nHelper i18n) {
        if (this.clusterManager.isClustered()) {
            ArrayList otherLiveNodes = new ArrayList();
            String thisNode = this.clusterManager.getNodeId();
            if (thisNode != null) {
                Collection<Node> liveNodes = this.clusterManager.findLiveNodes();
                otherLiveNodes.addAll(liveNodes.stream().filter(liveNode -> !thisNode.equals(liveNode.getNodeId())).collect(Collectors.toList()));
            }
            if (!otherLiveNodes.isEmpty()) {
                StringBuilder nodes = new StringBuilder();
                CollectionUtil.foreach(otherLiveNodes, element -> {
                    if (nodes.length() > 0) {
                        nodes.append(", ");
                    }
                    nodes.append(element.getNodeId());
                });
                errors.addErrorMessage(i18n.getText("data.import.error.active.cluster1"));
                errors.addErrorMessage(i18n.getText("data.import.error.active.cluster2", thisNode, nodes.toString()));
                errors.addErrorMessage(i18n.getText("data.import.error.active.cluster3"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataImportService.ImportResult doImport(ApplicationUser loggedInUser, DataImportService.ImportValidationResult result, TaskProgressSink taskProgressSink) {
        if (result == null) {
            throw new IllegalArgumentException("You cannot perform an import with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You cannot perform an import with an invalid validation result. " + result.getErrorCollection());
        }
        I18nHelper i18n = this.beanFactory.getInstance(loggedInUser);
        log.info((Object)"Running JIRA Data Import...");
        DataImportService.ImportResult.Builder importResultBuilder = new DataImportService.ImportResult.Builder(result.getParams());
        int threads = PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.import.threads", (int)10);
        int maxQueueSize = PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.import.maxqueuesize", (int)100);
        BoundedExecutor pool = new BoundedExecutor(Executors.newFixedThreadPool(threads, this.threadFactory), maxQueueSize);
        OfbizImportHandler ofbizImportHandler = this.ofbizImportHandlerFactory.create(result.getParams().isUseDefaultPaths(), this.propertiesValidationService.getPropertyKeysToRecord(), pool);
        JiraLicenseService.ValidationResult licenseValidationResult = this.parseXmlAndValidateBackupData(result.getParams(), importResultBuilder, i18n, ofbizImportHandler, taskProgressSink);
        if (!importResultBuilder.isValid()) {
            return importResultBuilder.build();
        }
        ServiceResult propertiesValidationResult = this.propertiesValidationService.validate(result.getParams(), new DataImportPropertiesAdapter(ofbizImportHandler));
        if (!propertiesValidationResult.isValid()) {
            Collection errorMessages = propertiesValidationResult.getErrorCollection().getErrorMessages();
            return importResultBuilder.withImportError(DataImportService.ImportError.FAILED_VALIDATION).addValidationErrorMessages(errorMessages).build();
        }
        Option xmlExportTime = ofbizImportHandler.getExportDate().flatMap(xmlExportTime1 -> {
            try {
                return Option.some((Object)Long.parseLong(xmlExportTime1));
            }
            catch (NumberFormatException e) {
                return Option.none();
            }
        });
        this.broadcastEvent(new ImportStartedEvent(xmlExportTime));
        boolean success = false;
        try {
            this.shutdownAndFlushAsyncServices(result.getParams());
            success = this.performImport(result.getParams(), importResultBuilder, i18n, pool, ofbizImportHandler, licenseValidationResult, taskProgressSink);
            if (success && importResultBuilder.isValid()) {
                this.createDefaultGroupsForNewLicense(licenseValidationResult, result.getParams().isStartupDataOnly());
                this.startAsyncServices();
            }
        }
        finally {
            this.broadcastEvent(new ImportCompletedEvent(success, xmlExportTime));
        }
        taskProgressSink.makeProgress(100L, i18n.getText("data.import.completed"), i18n.getText("data.import.completed.imported", (Object)ofbizImportHandler.getEntityCount()));
        log.info((Object)"JIRA Data Import has finished.");
        return importResultBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JiraLicenseService.ValidationResult parseXmlAndValidateBackupData(DataImportParams params, DataImportService.ImportResult.Builder importResult, I18nHelper i18n, OfbizImportHandler ofbizImportHandler, TaskProgressSink taskProgressSink) {
        ErrorCollection errors = importResult.getErrorCollection();
        File safeFileName = this.getJiraBackupFile(params);
        InputSource inputSource = this.getInputSource(safeFileName, errors, i18n, taskProgressSink);
        if (inputSource == null) {
            return null;
        }
        JiraLicenseService.ValidationResult licenseValidationResult = null;
        try {
            XMLReader reader = SecureXmlParserFactory.newXmlReader();
            log.info((Object)"Importing XML data...");
            ofbizImportHandler.setCreateEntities(false);
            log.debug((Object)"Start parsing XML with SAX Parser.");
            reader.setContentHandler(ofbizImportHandler);
            reader.parse(inputSource);
            log.debug((Object)"XML successfully parsed.");
            Integer xmlBuildNumber = this.getBuildNumberFromImportFile(ofbizImportHandler);
            if (!this.checkDowngrade(params, importResult, i18n, ofbizImportHandler, errors, xmlBuildNumber)) {
                JiraLicenseService.ValidationResult validationResult = null;
                return validationResult;
            }
            if (!this.checkXMLBuildNumber(i18n, errors, xmlBuildNumber)) {
                JiraLicenseService.ValidationResult validationResult = null;
                return validationResult;
            }
            licenseValidationResult = this.validateLicense(params, i18n, ofbizImportHandler, errors);
            this.checkIndex(importResult, i18n, ofbizImportHandler, errors);
            this.checkAttachment(importResult, i18n, ofbizImportHandler, errors);
            if (ofbizImportHandler.getErrorCollection().hasAnyErrors()) {
                errors.addErrors(ofbizImportHandler.getErrorCollection().getErrors());
            }
        }
        catch (SAXParseException e) {
            log.error((Object)("Error parsing export file: " + e), (Throwable)e);
            errors.addErrorMessage(i18n.getText("data.import.error.parsing.export.file", (Object)e));
        }
        catch (Exception e) {
            log.error((Object)("Error importing data: " + e), (Throwable)e);
            errors.addErrorMessage(i18n.getText("admin.errors.error.importing.data", (Object)e));
        }
        finally {
            this.closeInputSource(inputSource);
        }
        return licenseValidationResult;
    }

    private Integer getBuildNumberFromImportFile(OfbizImportHandler ofbizImportHandler) {
        String val = ofbizImportHandler.getBuildNumber();
        if (val == null) {
            return null;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException("Invalid build number '" + ofbizImportHandler.getBuildNumber() + "' in the import file.");
        }
    }

    private void createDefaultGroupsForNewLicense(JiraLicenseService.ValidationResult licenseValidationResult, boolean isStartupData) {
        if (licenseValidationResult != null && licenseValidationResult.getLicenseDetails() != null && !isStartupData) {
            this.dependencies.getApplicationConfigurationHelper().configureApplicationsForImport(licenseValidationResult.getLicenseDetails());
        }
    }

    private boolean checkXMLBuildNumber(I18nHelper i18n, ErrorCollection errors, Integer xmlBuildNumber) {
        if (xmlBuildNumber != null && !this.doesXmlMeetMinimumVersionRequirement(xmlBuildNumber)) {
            errors.addErrorMessage(i18n.getText("data.import.error.xml.too.old", this.externalLinkUtil.getProperty("external.link.jira.confluence.upgrade.guide.for.old.versions")));
            return false;
        }
        return true;
    }

    private void checkIndex(DataImportService.ImportResult.Builder importResult, I18nHelper i18n, OfbizImportHandler ofbizImportHandler, ErrorCollection errors) {
        String indexPath = ofbizImportHandler.getIndexPath();
        if (indexPath != null) {
            File indexDir = new File(indexPath);
            if (!indexDir.exists()) {
                errors.addErrorMessage(i18n.getText("setup.error.index.filepath", indexDir.getAbsolutePath()));
                importResult.setSpecificError(DataImportService.ImportError.CUSTOM_PATH_EXCEPTION, "path not found");
            } else if (!indexDir.isDirectory() || !indexDir.canWrite()) {
                errors.addErrorMessage(i18n.getText("setup.error.index.filepath.writeerror", indexDir.getAbsolutePath()));
            }
        }
    }

    private void checkAttachment(DataImportService.ImportResult.Builder importResult, I18nHelper i18n, OfbizImportHandler ofbizImportHandler, ErrorCollection errors) {
        String attachmentPath = ofbizImportHandler.getAttachmentPath();
        if (attachmentPath != null) {
            File attachmentDir = new File(attachmentPath);
            if (!attachmentDir.exists()) {
                errors.addErrorMessage(i18n.getText("attachfile.error.invalid", attachmentDir.getAbsolutePath()));
                importResult.setSpecificError(DataImportService.ImportError.CUSTOM_PATH_EXCEPTION, "path not found");
            } else if (!attachmentDir.isDirectory() || !attachmentDir.canWrite()) {
                errors.addErrorMessage(i18n.getText("attachfile.error.writeerror", attachmentDir.getAbsolutePath()));
            }
        }
    }

    private boolean checkDowngrade(DataImportParams params, DataImportService.ImportResult.Builder importResult, I18nHelper i18n, OfbizImportHandler ofbizImportHandler, ErrorCollection errors, Integer xmlBuildNumber) {
        String sourceJiraVersion = ofbizImportHandler.getVersion();
        String downgradeVersion = ofbizImportHandler.getMinimumDowngradeVersion();
        if (this.isXmlNewerThanThisVersion(xmlBuildNumber)) {
            if (this.canDowngrade(ofbizImportHandler)) {
                if (params.isAllowDowngrade()) {
                    log.info((Object)("Downgrading from JIRA version " + sourceJiraVersion));
                } else {
                    importResult.setSpecificError(DataImportService.ImportError.DOWNGRADE_FROM_ONDEMAND, sourceJiraVersion);
                }
            } else {
                if (StringUtils.isBlank((String)downgradeVersion)) {
                    downgradeVersion = sourceJiraVersion;
                }
                errors.addErrorMessage(i18n.getText("data.import.error.xml.newer.1", sourceJiraVersion, downgradeVersion));
                errors.addErrorMessage(i18n.getText("data.import.error.xml.newer.2", downgradeVersion));
                return false;
            }
        }
        return true;
    }

    private JiraLicenseService.ValidationResult validateLicense(DataImportParams params, I18nHelper i18n, OfbizImportHandler ofbizImportHandler, ErrorCollection errors) {
        JiraLicenseService.ValidationResult result = null;
        if (!params.isNoLicenseCheck()) {
            if (StringUtils.isNotBlank((String)params.getLicenseString())) {
                String licenseString = params.getLicenseString();
                result = this.jiraLicenseService.validate(i18n, licenseString);
                errors.addErrors(result.getErrorCollection().getErrors());
            } else if (!params.isStartupDataOnly()) {
                result = this.validateLicenses(ofbizImportHandler.getLicenseStrings(), errors, i18n);
            }
        }
        return result;
    }

    private JiraLicenseService.ValidationResult validateLicenses(Iterable<String> licenses, ErrorCollection errors, I18nHelper i18n) {
        Iterable results = this.jiraLicenseService.validate(i18n, licenses);
        JiraLicenseService.ValidationResult licenseValidationResult = null;
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            JiraLicenseService.ValidationResult result;
            licenseValidationResult = result = (JiraLicenseService.ValidationResult)iterator.next();
            ErrorCollection errorCollection = result.getErrorCollection();
            if (!errorCollection.hasAnyErrors()) continue;
            errors.addErrors(errorCollection.getErrors());
            return result;
        }
        return licenseValidationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreActiveObjects(File safeFileName, I18nHelper i18n, ErrorCollection errors) {
        Backup activeObjectsBackup = this.getAOBackup();
        if (activeObjectsBackup == null) {
            log.error((Object)"Unable complete the restore: Cannot find ActiveObjects. Is the plugin enabled?");
            errors.addErrorMessage(i18n.getText("data.import.error.no.ao"));
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = ZipUtils.streamForZipFileEntry(safeFileName, "activeobjects.xml");
            if (inputStream == null) {
                log.info((Object)String.format("Unable to find ActiveObjects backup (%s) inside of zip file: %s", "activeobjects.xml", safeFileName));
            } else {
                activeObjectsBackup.restore(inputStream, NullRestoreProgressMonitor.INSTANCE);
            }
        }
        catch (ActiveObjectsImportExportException e) {
            log.error((Object)"Error during ActiveObjects restore", (Throwable)e);
            if (e.getTableName() != null) {
                errors.addErrorMessage(i18n.getText("admin.import.restore.activeobjects.exception", (Object)e.getPluginInformation()) + " " + i18n.getText("admin.import.restore.activeobjects.exception.importing.table", e.getTableName()) + " " + i18n.getText("admin.import.restore.activeobjects.exception.check.log"));
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(i18n.getText("admin.import.restore.activeobjects.exception", (Object)e.getPluginInformation()));
                if (e.getCause() != null) {
                    String msg = e.getCause().getMessage();
                    sb.append(" ").append(i18n.getText("admin.import.restore.activeobjects.exception.additional.info.exception", msg));
                    if (!msg.endsWith(".")) {
                        sb.append('.');
                    }
                }
                sb.append(" ").append(i18n.getText("admin.import.restore.activeobjects.exception.check.log"));
                errors.addErrorMessage(sb.toString());
            }
        }
        catch (IOException e) {
            log.error((Object)("Error attempting to import ActiveObjects backup: " + e), (Throwable)e);
            errors.addErrorMessage(i18n.getText("admin.errors.error.importing.data", (Object)e));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to close zip stream during ActiveObjects restore", (Throwable)e);
                }
            }
        }
    }

    Backup getAOBackup() {
        return (Backup)ComponentAccessor.getOSGiComponentInstanceOfType(Backup.class);
    }

    private void shutdownAndFlushAsyncServices(DataImportParams params) {
        LifecycleAwareSchedulerService schedulerService = this.dependencies.getSchedulerService();
        if (params.isQuickImport()) {
            this.pauseAndFlushScheduler(schedulerService);
            this.removeLocalServices();
        } else {
            schedulerService.shutdown();
        }
        this.cleanUpEvents();
        this.cleanUpTaskManager(params);
        this.cleanUpCrowd();
        try {
            this.mailQueue.sendBuffer();
        }
        catch (Exception e) {
            log.warn((Object)("Sending buffer failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private void removeLocalServices() {
        for (JiraServiceContainer service : this.serviceManager.getServices()) {
            try {
                if (!service.isLocalService()) continue;
                this.serviceManager.removeService(service.getId());
            }
            catch (Exception e) {
                log.warn((Object)("Unable to remove service " + service), (Throwable)e);
            }
        }
    }

    private void cleanUpCrowd() {
        DirectorySynchroniserBarrier barrier = this.factory.createObject(DirectorySynchroniserBarrier.class);
        if (!barrier.await(20L, TimeUnit.SECONDS)) {
            log.error((Object)"Unable to stop remote directory synchronization.");
        }
    }

    private void cleanUpEvents() {
        this.eventExecutorFactory.shutdown();
    }

    private void cleanUpTaskManager(DataImportParams params) {
        if (params.isQuickImport()) {
            if (!this.taskManager.awaitUntilActiveTasksComplete(20L)) {
                log.error((Object)"There were still running tasks during the live import:");
                for (TaskDescriptor<?> descriptor : this.taskManager.getLiveTasks()) {
                    log.error((Object)(" -\t" + descriptor.getDescription()));
                }
            }
        } else {
            this.taskManager.shutdownAndWait(5L);
        }
    }

    private void pauseAndFlushScheduler(LifecycleAwareSchedulerService schedulerService) {
        try {
            schedulerService.standby();
        }
        catch (SchedulerServiceException e) {
            throw new SchedulerRuntimeException("Failed to place scheduler service into standby mode", (Throwable)e);
        }
        Integer waitUntil = this.jiraSystemProperties.getInteger("jira.quickimport.current.job.completion.timeout.sec", Integer.valueOf(30));
        try {
            boolean returnValue = schedulerService.waitUntilIdle((long)waitUntil.intValue(), TimeUnit.SECONDS);
            if (!returnValue) {
                log.warn((Object)("timed out waiting for atlassian scheduler currently executing jobs to complete; background jobs touching the database during quick-import can lead to (flake)\njobs " + schedulerService.getLocallyRunningJobs()));
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"interrupted while waiting for currently executing jobs to complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performImport(DataImportParams params, DataImportService.ImportResult.Builder importResult, I18nHelper i18n, BoundedExecutor pool, OfbizImportHandler ofbizImportHandler, JiraLicenseService.ValidationResult licenseValidationResult, TaskProgressSink taskProgressSink) {
        ErrorCollection errors = importResult.getErrorCollection();
        try {
            if (!this.removeActiveObjects(i18n, errors)) {
                boolean bl = false;
                return bl;
            }
            this.removeAllEntities();
            long entityCount = ofbizImportHandler.getEntityCount();
            if (log.isInfoEnabled()) {
                log.info((Object)("Started storing " + entityCount + " Generic Values."));
            }
            XMLReader xmlReader = SecureXmlParserFactory.newXmlReader();
            ofbizImportHandler.setTaskProgressSink(new I18nTaskProgressSink(new StepTaskProgressSink(20L, 90L, entityCount, taskProgressSink), i18n, entityCount));
            if (!this.restoreData(importResult, i18n, pool, ofbizImportHandler, xmlReader, params, errors)) {
                boolean bl = false;
                return bl;
            }
            log.info((Object)"Finished storing Generic Values.");
            this.broadcastEvent(new DatabaseImportCompletedEvent());
            File aoBackupFile = this.getAOBackupFile(params);
            if ("zip".equalsIgnoreCase(FilenameUtils.getExtension((String)aoBackupFile.getAbsolutePath()))) {
                this.restoreActiveObjects(aoBackupFile, i18n, errors);
                if (errors.hasAnyErrors()) {
                    boolean bl = false;
                    return bl;
                }
            }
            this.dependencies.refreshSequencer();
            this.createUserKeysIfNecessary();
            if (params.isAllowDowngrade()) {
                this.executeDowngradeTasks();
            }
            this.broadcastEvent(HotRestartEvent.INSTANCE);
            this.restartJira(params, licenseValidationResult);
            this.dependencies.getPluginEventManager().broadcast((Object)new DataImportFinishedEvent());
            this.checkConsistency(i18n, taskProgressSink);
            UpgradeManagerParams upgradeManagerParams = UpgradeManagerParams.builder().setSetupMode(params.isSetup()).withoutReindexAllowed().withoutDelay().build();
            UpgradeManager.Status status = this.upgradeJira(i18n, taskProgressSink, upgradeManagerParams);
            if (!status.successful()) {
                this.setErrorMessage(importResult, status.getErrors());
                boolean bl = false;
                return bl;
            }
            this.updateLookAndFeel();
            if (!params.isStartupDataOnly()) {
                this.reindex();
                this.upgradePlugins(params);
            }
            this.dependencies.addRecoveryMapping();
            this.applyMailSettingsAccordingTo(params);
            boolean bl = true;
            return bl;
        }
        catch (SAXParseException e) {
            log.error((Object)("Error parsing export file: " + e), (Throwable)e);
            errors.addErrorMessage(i18n.getText("data.import.error.parsing.export.file", (Object)e));
        }
        catch (DowngradeException ex) {
            log.error((Object)("Unable to downgrade data: " + ex.getMessage()));
            errors.addErrorMessage(i18n.getText("admin.errors.error.importing.data", ex.getMessage()));
        }
        catch (Exception e) {
            log.error((Object)("Error importing data: " + e), (Throwable)e);
            errors.addErrorMessage(i18n.getText("admin.errors.error.importing.data", (Object)e));
        }
        finally {
            pool.shutdownAndWait();
        }
        return false;
    }

    protected void createUserKeysIfNecessary() {
        EntityEngineImpl entityEngine = new EntityEngineImpl(this.ofBizDelegator);
        Long applicationKeys = (Long)Select.countFrom("ApplicationUser").runWith(entityEngine).singleValue();
        if (applicationKeys == null || applicationKeys == 0L) {
            UpgradeTask_Build6040.mapUsernamesToKeys(entityEngine);
        }
    }

    private void applyMailSettingsAccordingTo(DataImportParams params) {
        if (params.shouldChangeOutgoingMail()) {
            if (params.outgoingMail()) {
                this.dependencies.getMailSettings().send().enable();
            } else {
                this.dependencies.getMailSettings().send().disable();
            }
        }
    }

    private void executeDowngradeTasks() throws DowngradeException {
        new DowngradeWorker(this.buildUtilsInfo, this.dbConnectionManager, this.ofBizDelegator, this.applicationProperties).downgrade(DowngradeWorker.Mode.IMPORT);
    }

    private void upgradePlugins(DataImportParams params) {
        PluginUpgradeManager upgradeManager;
        List upgrade;
        if (params.isQuickImport() && (upgrade = (upgradeManager = this.dependencies.getPluginUpgradeManager()).upgrade()) != null && !upgrade.isEmpty()) {
            I18nHelper instance = this.beanFactory.getInstance(Locale.ENGLISH);
            log.error((Object)"Upgrade of plugins failed:");
            for (Message message : upgrade) {
                log.error((Object)("\t" + instance.getText(message.getKey(), (Object)message.getArguments())));
            }
        }
        this.dependencies.getPluginEventManager().broadcast((Object)new JiraStartedEvent());
    }

    private void updateLookAndFeel() {
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        lookAndFeelBean.updateSettingsHash();
    }

    private void setErrorMessage(DataImportService.ImportResult.Builder importResult, Collection<String> upgradeErrors) {
        StringBuilder errorString = new StringBuilder();
        for (String upgradeError : upgradeErrors) {
            errorString.append(upgradeError).append("\n");
        }
        importResult.setSpecificError(DataImportService.ImportError.UPGRADE_EXCEPTION, errorString.toString());
    }

    private UpgradeManager.Status upgradeJira(I18nHelper i18n, TaskProgressSink taskProgressSink, UpgradeManagerParams upgradeManagerParams) throws IllegalXMLCharactersException {
        UpgradeManager.Status status = this.dependencies.getUpgradeManager().doUpgradeIfNeededAndAllowed(null, upgradeManagerParams);
        taskProgressSink.makeProgress(96L, i18n.getText("data.import.indexing"), i18n.getText("data.import.indexing.progress"));
        return status;
    }

    private void checkConsistency(I18nHelper i18n, TaskProgressSink taskProgressSink) throws Exception {
        this.dependencies.getConsistencyChecker().checkDataConsistency(ServletContextProvider.getServletContext());
        taskProgressSink.makeProgress(92L, i18n.getText("data.import.upgrade"), i18n.getText("data.import.upgrade.progress"));
    }

    private void restartJira(DataImportParams params, JiraLicenseService.ValidationResult licenseValidationResult) throws Exception {
        this.dependencies.refreshSequencer();
        if (StringUtils.isNotBlank((String)params.getLicenseString()) && licenseValidationResult != null) {
            this.jiraLicenseService.setLicenseNoEvent(licenseValidationResult);
        }
        this.globalRefresh(params.isQuickImport());
    }

    private boolean restoreData(DataImportService.ImportResult.Builder importResult, I18nHelper i18n, BoundedExecutor pool, OfbizImportHandler ofbizImportHandler, XMLReader saxParser, DataImportParams params, ErrorCollection errors) throws SAXException, IOException {
        InputSource inputSource = this.getInputSource(this.getSafeFile(params), errors, i18n, TaskProgressSink.NULL_SINK);
        ofbizImportHandler.setCreateEntities(true);
        saxParser.setContentHandler(ofbizImportHandler);
        saxParser.parse(inputSource);
        pool.shutdownAndWait();
        if (ofbizImportHandler.getImportError() != null) {
            importResult.getErrorCollection().addErrorMessage(i18n.getText("admin.errors.unknown.error.during.import", ofbizImportHandler.getImportError().getMessage()));
            return false;
        }
        return true;
    }

    private void startAsyncServices() {
        try {
            this.dependencies.getSchedulerService().start();
        }
        catch (SchedulerServiceException e) {
            throw new SchedulerRuntimeException("Unable to start the scheduler service", (Throwable)e);
        }
    }

    private void closeInputSource(InputSource is) {
        if (is != null) {
            IOUtils.closeQuietly((InputStream)is.getByteStream());
            IOUtils.closeQuietly((Reader)is.getCharacterStream());
        }
    }

    private void globalRefresh(boolean quickImport) throws Exception {
        try {
            this.dependencies.globalRefresh(quickImport);
        }
        catch (RuntimeException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private boolean isXmlNewerThanThisVersion(Integer xmlBuildNumber) {
        return xmlBuildNumber != null && xmlBuildNumber > this.buildUtilsInfo.getApplicationBuildNumber();
    }

    private boolean canDowngrade(OfbizImportHandler ofbizImportHandler) {
        List<UpgradeHistoryDTO> upgradeHistoryItems = ofbizImportHandler.getUpgradeHistory();
        return DowngradeUtil.canDowngrade(upgradeHistoryItems, this.buildUtilsInfo.getApplicationBuildNumber());
    }

    private boolean doesXmlMeetMinimumVersionRequirement(int xmlBuildNumber) {
        try {
            int minimumVersionBuildNumber = Integer.parseInt(this.buildUtilsInfo.getMinimumUpgradableBuildNumber());
            return xmlBuildNumber >= minimumVersionBuildNumber;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException("Illegal value for MinimumUpgradableBuildNumber: " + this.buildUtilsInfo.getMinimumUpgradableBuildNumber());
        }
    }

    private InputSource getInputSource(File file, ErrorCollection errors, I18nHelper i18n, TaskProgressSink taskProgressSink) {
        ProgressMonitoringFileInputStream inputStream;
        try {
            JiraFileInputStream stream = new JiraFileInputStream(file, "entities.xml");
            inputStream = new ProgressMonitoringFileInputStream(stream, new StepTaskProgressSink(0L, 20L, stream.getSize(), taskProgressSink), i18n.getText("data.import.parse.xml"), i18n.getText("data.import.parse.progress", "{0}", FileSize.format((long)stream.getSize())));
        }
        catch (FileNotFoundException e) {
            errors.addErrorMessage(i18n.getText("data.import.could.not.find.file.at", file.getAbsolutePath()));
            return null;
        }
        catch (IOException e) {
            log.error((Object)("Error importing from zip file: \"" + file.getAbsolutePath() + "\""), (Throwable)e);
            errors.addErrorMessage(i18n.getText("data.import.error.importing.from.zip", "\"" + file.getAbsolutePath() + "\"", e.getMessage()));
            return null;
        }
        if (this.applicationProperties.getOption("jira.exportimport.cleanxml")) {
            Reader reader = this.getFilteredReader(inputStream);
            return new InputSource(reader);
        }
        return new InputSource(inputStream);
    }

    private void reindex() throws Exception {
        IndexLifecycleManager indexManager = this.dependencies.getIndexLifecycleManager();
        indexManager.deactivate();
        indexManager.activate(Contexts.percentageLogger((Sized)indexManager, (Logger)log));
        this.reindexRequestManager.clearAll();
    }

    private boolean removeActiveObjects(I18nHelper i18n, ErrorCollection errors) {
        Backup aoBackup = this.getAOBackup();
        if (aoBackup == null) {
            log.error((Object)"Unable to delete ActiveObjects tables. Is the ActiveObjects plugin enabled?");
            errors.addErrorMessage(i18n.getText("data.import.error.no.ao"));
            return false;
        }
        aoBackup.clear();
        return true;
    }

    private void removeAllEntities() throws GenericEntityException {
        log.info((Object)"Removing all entries from the database.");
        ModelReader reader = this.ofBizDelegator.getModelReader();
        Collection ec = reader.getEntityNames();
        TreeSet entityNames = new TreeSet(ec);
        for (String entityName : entityNames) {
            ModelEntity modelEntity = reader.getModelEntity(entityName);
            if (modelEntity != null) {
                if (!(modelEntity instanceof ModelViewEntity)) {
                    this.ofBizDelegator.removeByAnd(entityName, Collections.emptyMap());
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No need to remove records from View entity '" + entityName + "'"));
                continue;
            }
            log.warn((Object)("Nothing known about entity '" + entityName + "' - cannot delete."));
        }
        log.info((Object)"All entries removed.");
    }

    private Reader getFilteredReader(InputStream is) {
        try {
            XmlReader xmlReader = XmlReader.createReader(is);
            return new XMLEscapingReader(new InputStreamReader(xmlReader.getInputStream(), xmlReader.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e, (Throwable)e);
            throw new InvalidSourceException("Unsupported encoding.", e);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new InvalidSourceException("IO error has occurred.", e);
        }
    }

    private File getSafeFile(DataImportParams params) {
        File file = new File(params.getFilename());
        if ((params.isSetup() || this.hasSecretSauce(file)) && file.exists()) {
            return file;
        }
        return new File(this.jiraHome.getImportDirectory().getAbsolutePath(), file.getName());
    }

    File getJiraBackupFile(DataImportParams params) {
        if (params.getUnsafeJiraBackup() != null) {
            return params.getUnsafeJiraBackup();
        }
        return this.getSafeFile(params);
    }

    File getAOBackupFile(DataImportParams params) {
        if (params.getUnsafeAOBackup() != null) {
            return params.getUnsafeAOBackup();
        }
        return this.getJiraBackupFile(params);
    }

    @VisibleForTesting
    EventPublisher getEventPublisher() {
        return (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
    }

    private boolean hasSecretSauce(File file) {
        return this.devModeSecretSauce.isBoneFideJiraDeveloper() && file.getParentFile() != null;
    }

    private void broadcastEvent(Object event) {
        EventPublisher publisher = this.getEventPublisher();
        if (publisher == null) {
            log.error((Object)("Could not broadcast event due missing EventPublisher: " + event));
            return;
        }
        publisher.publish(event);
    }

    static class I18nTaskProgressSink
    implements TaskProgressSink {
        private final TaskProgressSink delegate;
        private final I18nHelper i18n;
        private final long totalSize;

        I18nTaskProgressSink(TaskProgressSink delegate, I18nHelper i18n, long totalSize) {
            this.delegate = delegate;
            this.i18n = i18n;
            this.totalSize = totalSize;
        }

        public void makeProgress(long taskProgress, String currentSubTask, String message) {
            this.delegate.makeProgress(taskProgress, this.i18n.getText(currentSubTask), this.i18n.getText(message, Long.toString(taskProgress), Long.toString(this.totalSize)));
        }
    }

    static class InvalidSourceException
    extends RuntimeException {
        public InvalidSourceException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }
}

