/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar.temporary;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.TemporaryAvatar;
import com.atlassian.jira.avatar.TemporaryAvatars;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.ExecutingHttpRequest;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpSession;

public class TemporaryAvatarsImpl
implements TemporaryAvatars {
    private final AvatarManager avatarManager;

    public TemporaryAvatarsImpl(AvatarManager avatarManager) {
        this.avatarManager = avatarManager;
    }

    public void storeTemporaryAvatar(ApplicationUser remoteUser, TemporaryAvatar avatar, Avatar.Type type, String ownerId) throws IllegalAccessException {
        Assertions.notNull((String)"type", (Object)type);
        IconType iconType = IconType.of((String)type.getName());
        if (iconType == null) {
            throw new IllegalAccessException("The icon type " + type.getName() + " is unknown.");
        }
        this.storeTemporaryAvatar(remoteUser, avatar, iconType, new IconOwningObjectId(ownerId));
    }

    public void storeTemporaryAvatar(ApplicationUser remoteUser, TemporaryAvatar avatar, @Nonnull IconType iconType, IconOwningObjectId ownerId) throws IllegalAccessException {
        if (!this.avatarManager.userCanCreateFor(remoteUser, iconType, ownerId)) {
            throw new IllegalAccessException("User cannot store temporary avatars");
        }
        ExecutingHttpRequest.get().getSession().setAttribute("tempAvatarFile", (Object)avatar);
    }

    public TemporaryAvatar getCurrentTemporaryAvatar() {
        HttpSession session = ExecutingHttpRequest.get().getSession();
        return (TemporaryAvatar)session.getAttribute("tempAvatarFile");
    }

    public void dispose(TemporaryAvatar avatar) {
        avatar.getFile().delete();
        HttpSession session = ExecutingHttpRequest.get().getSession();
        session.removeAttribute("tempAvatarFile");
    }
}

