/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImageDataStorage;
import com.atlassian.jira.avatar.AvatarTagger;
import com.atlassian.jira.avatar.AvatarTranscoder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

@ParametersAreNonnullByDefault
public class AvatarTranscoderImpl
implements AvatarTranscoder {
    private static final String PNG_EXTENSION = ".png";
    private final AvatarTagger avatarTagger;
    private final AvatarImageDataStorage avatarImageDataStorage;

    public AvatarTranscoderImpl(AvatarTagger avatarTagger, AvatarImageDataStorage avatarImageDataStorage) {
        this.avatarTagger = avatarTagger;
        this.avatarImageDataStorage = avatarImageDataStorage;
    }

    @Override
    public File getOrCreateRasterizedAvatarFile(Avatar avatar, Avatar.Size size, InputStream inputStream) throws IOException {
        Preconditions.checkArgument((boolean)avatar.isSystemAvatar(), (Object)"Avatar must be a system avatar");
        return this.writeToFileIfEmpty(this.getTranscodedFile(avatar, size), fileOutputStream -> this.transcodeAndTag(inputStream, fileOutputStream, size));
    }

    @Override
    public void transcodeAndTag(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.transcodeAndTag(inputStream, outputStream, Avatar.Size.MEDIUM);
    }

    @Override
    public byte[] transcodeAndTag(String imageKey, InputStream inputStream, Avatar.Size size) throws IOException {
        String filename = this.rasterFileName(this.sanitizeFileName(imageKey), size);
        File fileWithPng = this.writeToFileIfEmpty(this.getFile(filename), outputStream -> this.transcodeAndTag(inputStream, outputStream, size));
        try (FileInputStream stream = new FileInputStream(fileWithPng);){
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
    }

    private void transcodeAndTag(InputStream inputStream, OutputStream outputStream, Avatar.Size size) throws IOException {
        try {
            TranscoderInput transcoderInput = new TranscoderInput(inputStream);
            ByteArrayOutputStream transcoded = new ByteArrayOutputStream();
            TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)transcoded);
            PNGTranscoder transcoder = this.newPNGTranscoder(size);
            transcoder.transcode(transcoderInput, transcoderOutput);
            this.avatarTagger.tag(new ByteArrayInputStream(transcoded.toByteArray()), outputStream);
        }
        catch (TranscoderException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    PNGTranscoder createPngTranscoder() {
        return new PNGTranscoder();
    }

    @VisibleForTesting
    File getTranscodedFile(Avatar avatar, Avatar.Size size) {
        return this.getFile(this.rasterAvatarFileName(avatar, size));
    }

    private File writeToFileIfEmpty(File file, FileWriter fileWriter) throws IOException {
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                try (FileOutputStream outputStream = new FileOutputStream(file);){
                    fileWriter.write(outputStream);
                }
            }
            catch (IOException e) {
                FileUtils.deleteQuietly((File)file);
                throw new IOException(e);
            }
            catch (Exception e) {
                FileUtils.deleteQuietly((File)file);
                throw new RuntimeException(e);
            }
        }
        return file;
    }

    private File getFile(String filename) {
        File base = this.avatarImageDataStorage.getAvatarBaseDirectory();
        return new File(base, filename);
    }

    private String rasterAvatarFileName(Avatar avatar, Avatar.Size size) {
        return this.rasterFileName(avatar.getFileName(), size);
    }

    private String rasterFileName(String baseFilename, Avatar.Size size) {
        return FilenameUtils.removeExtension((String)(size.param + "_" + baseFilename)) + PNG_EXTENSION;
    }

    private String sanitizeFileName(String imageKey) {
        String forbiddenCharacters = "[^\\w+\\.]";
        return imageKey.replaceAll("^" + forbiddenCharacters + "+", "").replaceAll(forbiddenCharacters, "_");
    }

    private PNGTranscoder newPNGTranscoder(Avatar.Size size) {
        PNGTranscoder transcoder = this.createPngTranscoder();
        transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(size.getPixels()));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(size.getPixels()));
        return transcoder;
    }

    private static interface FileWriter {
        public void write(FileOutputStream var1) throws IOException;
    }
}

