/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.db;

import com.atlassian.jira.appconsistency.db.TableColumnCheckResult;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.upgrade.util.UpgradeUtils;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Build178SchemaCheck
implements StartupCheck {
    private static final Logger log = LoggerFactory.getLogger(Build178SchemaCheck.class);
    private static final String INSTRUCTIONS_URL = ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.confluence.3.7.upgrade.guide");
    private static final String FAULT_DESC = "We have detected that JIRA is configured to connect to a database from a previous version of JIRA. If you have just upgraded JIRA, you may need to consult <a href=\"" + INSTRUCTIONS_URL + "\">the 3.7 Upgrade Guide</a>.";
    private static final String NAME = "Build178SchemaCheck";
    private boolean isOk = true;

    @Override
    public String getFaultDescription() {
        return FAULT_DESC;
    }

    @Override
    public String getHTMLFaultDescription() {
        return this.getFaultDescription();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isOk() {
        log.debug("Checking database...");
        ArrayList<TableColumnCheckResult> tableColumnCheckResults = new ArrayList<TableColumnCheckResult>();
        tableColumnCheckResults.add(new TableColumnCheckResult("notification", "type"));
        tableColumnCheckResults.add(new TableColumnCheckResult("notification", "parameter"));
        tableColumnCheckResults.add(new TableColumnCheckResult("mailserver", "type"));
        tableColumnCheckResults.add(new TableColumnCheckResult("jiraeventtype", "type"));
        tableColumnCheckResults.add(new TableColumnCheckResult("schemepermissions", "type"));
        tableColumnCheckResults.add(new TableColumnCheckResult("schemeissuesecurities", "type"));
        tableColumnCheckResults.add(new TableColumnCheckResult("fieldlayout", "type"));
        tableColumnCheckResults.add(new TableColumnCheckResult("SchemePermissions", "parameter"));
        tableColumnCheckResults.add(new TableColumnCheckResult("SchemeIssueSecurities", "parameter"));
        tableColumnCheckResults.add(new TableColumnCheckResult("PortletConfiguration", "position"));
        tableColumnCheckResults.add(new TableColumnCheckResult("version"));
        this.doColumnTableChecks(tableColumnCheckResults);
        this.checkColumnsAreInTables(tableColumnCheckResults);
        this.checkTableDoesNotExist("version", tableColumnCheckResults);
        log.debug("Database checks finished.");
        return this.isOk;
    }

    private void checkColumnsAreInTables(List<TableColumnCheckResult> tableColumnCheckResults) {
        for (TableColumnCheckResult tableColumnCheckResult : tableColumnCheckResults) {
            boolean bl = this.isOk = !tableColumnCheckResult.isExists();
            if (this.isOk) continue;
            log.error("Found column: '" + tableColumnCheckResult.getColumnName() + "' in table: '" + tableColumnCheckResult.getTableName() + "', this column should not be present.");
            break;
        }
    }

    private void checkTableDoesNotExist(String table, List<TableColumnCheckResult> tableColumnCheckResults) {
        if (this.isOk) {
            for (TableColumnCheckResult tableColumnCheckResult : tableColumnCheckResults) {
                if (!tableColumnCheckResult.getTableName().equalsIgnoreCase(table)) continue;
                boolean bl = this.isOk = !tableColumnCheckResult.isExists();
                if (this.isOk) continue;
                log.error("Found table '" + table + "', this table should not be present.");
            }
        }
    }

    void doColumnTableChecks(List<TableColumnCheckResult> tableColumnCheckResults) {
        UpgradeUtils.doColumnsOrTablesExist(tableColumnCheckResults);
    }

    public String toString() {
        return NAME;
    }
}

